<?php

/*

  $Id: regions1.php, v 1.0 2002/12/15 14:29:56 Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com
  Copyright (c) 2003 osCommerce
  Released under the GNU General Public License

  The Exchange Project - Community Made Shopping!
  http://www.theexchangeproject.org
  
  http://www.phpmania.org
  PHPmania.org -  2004. Todos os direitos reservados.

*/

  class regions1 {
    var $code, $title, $description, $enabled, $regions1;

// class constructor
    function regions1() {
      $this->code = 'regions1';
      $this->title = MODULE_SHIPPING_REGIONS1_TEXT_TITLE;
      $this->description = MODULE_SHIPPING_REGIONS1_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_SHIPPING_REGIONS1_SORT_ORDER;
      $this->icon = '';
      $this->enabled = ((MODULE_SHIPPING_REGIONS1_STATUS == 'True') ? true : false);
      // CUSTOMIZE THIS SETTING FOR THE NUMBER OF REGIONS1 NEEDED
      $this->regions1 = 5;
    }

// class methods
    function quote($method = '') {
      global $order, $shipping_weight, $cart, $total_count;
      
      if (MODULE_SHIPPING_REGIONS1_MODE == 'Preo') {
        $order_total_price = $cart->show_total();
      } 
      if (MODULE_SHIPPING_REGIONS1_MODE == 'Peso') {
        $order_total_price = $shipping_weight;
      }
      if (MODULE_SHIPPING_REGIONS1_MODE == 'Por_item') {
        $order_total_price = $total_count;
      }      

      $dest_state = $order->delivery['state'];
      $dest_country = $order->delivery['country']['title'];
      
      $dest_region = 0;
      $error = false;

      for ($i=1; $i<=$this->regions1; $i++) {
        $regions1_table = constant('MODULE_SHIPPING_REGIONS1' . $i);
        $country_states_or_countries = split("[,]", $regions1_table);
        if (in_array($dest_state, $country_states_or_countries)) {
          $dest_region = $i;
          break;
        }
      }
      if ($dest_region == 0) {
              for ($i=1; $i<=$this->regions1; $i++) {
                $regions1_table = constant('MODULE_SHIPPING_REGIONS1' . $i);
                $country_states_or_countries = split("[,]", $regions1_table);
                if (in_array($dest_country, $country_states_or_countries)) {
                  $dest_region = $i;
                  break;
                }
              }
      }

      if ($dest_region == 0) {
        $error = true;
      } else {
        $shipping = -1;
        $region_cost = constant('MODULE_SHIPPING_REGIONS1_COST' . $i);

        $regions1_table = split("[:,]" , $region_cost);

        if ((MODULE_SHIPPING_REGIONS1_MODE == 'Preo') || (MODULE_SHIPPING_REGIONS1_MODE == 'Peso')) {
                for ($i=0; $i<sizeof($regions1_table); $i+=2) {
                  if ($order_total_price <= $regions1_table[$i]) {
                    $shipping = $regions1_table[$i+1];
                    $shipping_method = MODULE_SHIPPING_REGIONS1_TEXT_WAY . ' ' . "$dest_state" . ' ' . MODULE_SHIPPING_REGIONS1_TEXT_UNITS;
                    break;
                  }
                }
        }
        if (MODULE_SHIPPING_REGIONS1_MODE == 'Por_item') {
                         $shipping = $regions1_table[1] * $order_total_price;
                            $shipping_method = MODULE_SHIPPING_REGIONS1_ITEM . ' ' . $total_count . ' ' . MODULE_SHIPPING_REGIONS1_ITEMS . ' ' . "$dest_state" . ' ' . MODULE_SHIPPING_REGIONS1_TEXT_UNITS;
           }        
        
        
        if ($shipping == -1) {
          $shipping_cost = 0;
          $shipping_method = MODULE_SHIPPING_REGIONS1_UNDEFINED_RATE;
        } else {
          $shipping_cost = ($shipping + MODULE_SHIPPING_REGIONS1_HANDLING + SHIPPING_HANDLING);
        }
      }

      $this->quotes = array('id' => $this->code,
                            'module' => MODULE_SHIPPING_REGIONS1_TEXT_TITLE,
                            'methods' => array(array('id' => $this->code,
                                                     'title' => $shipping_method,
                                                     'cost' => $shipping_cost)));

      if (tep_not_null($this->icon)) $this->quotes['icon'] = tep_image($this->icon, $this->title);

      if ($error == true) $this->quotes['error'] = MODULE_SHIPPING_REGIONS1_INVALID_ZONE;

      return $this->quotes;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_REGIONS1_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Entrega Correios Normal', 'MODULE_SHIPPING_REGIONS1_STATUS', 'True', 'Ativar Entrega normal?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Taxa de manipulao', 'MODULE_SHIPPING_REGIONS1_HANDLING', '0', 'Taxa de manipulao para este mtodo de transporte.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Modo', 'MODULE_SHIPPING_REGIONS1_MODE', 'Peso', ' a tabela de transporte baseado em Peso total ou Quantia Total de pedidos.', '6', '0', 'tep_cfg_select_option(array(\'Peso\', \'Preo\', \'Por_item\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordem de exibio.', 'MODULE_SHIPPING_REGIONS1_SORT_ORDER', '0', 'Determina a ordem de exibio do meio de envio.', '6', '0', now())");
      for ($i = 1; $i <= $this->regions1; $i++) {
        $default_countries = '';
        if ($i == 1) {
          $default_states_or_countries = 'Parana,Rio de Janeiro,Minas Gerais,Santa Catarina,Distrito Federal,Espirito Santo,Sao Paulo';
          $default_prices = '1:8.00,2:8.00,3:8.00,4:8.00,5:8.00,15:8.00,25:8.00,35:8.00,55:8.00,75:8.00,85:8.00';
        }
        if ($i == 2) {
          $default_states_or_countries = 'Tocantins,Alagoas,Sergipe,Paraiba,Pernambuco,Piaui,Rondonia,Acre,Amapa,Amazonas,Ceara,Maranhao';
          $default_prices = '1:8.00,2:8.00,3:8.00,4:8.00,5:8.00,15:8.00,25:8.00,35:8.00,55:8.00,75:8.00,85:8.00';
        }
        if ($i == 3) {
          $default_states_or_countries = 'Mato Grosso do Sul,Rio Grande do Sul,Bahia,Goias,Mato Grosso,Parah,Rio Grande do Norte,Roraima';
          $default_prices = '1:8.00,2:8.00,3:8.00,4:8.00,5:8.00,15:8.00,25:8.00,35:8.00,55:8.00,75:8.00,85:8.00';
        }
        if ($i == 4) {
          $default_states_or_countries = '';
          $default_prices = '';
        }
        if ($i == 5) {
          $default_states_or_countries = '';
          $default_prices = '';
        }
        tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Regio " . $i ." Estados', 'MODULE_SHIPPING_REGIONS1" . $i ."', '" . $default_states_or_countries . "', 'Separar por vrgula se tiver mais de um estado', '6', '0', now())");
        tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Regio " . $i ." Tarifas', 'MODULE_SHIPPING_REGIONS1_COST" . $i ."', '" . $default_prices . "' , 'Exemplo: 1:5.00,2:5.50,3:6.00,... 1  o peso, 5.00  o valor', '6', '0', now())");
      }
    }

    function remove() {
      $keys = '';
      $keys_array = $this->keys();
      for ($i=0; $i<sizeof($keys_array); $i++) {
        $keys .= "'" . $keys_array[$i] . "',";
      }
      $keys = substr($keys, 0, -1);

      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in (" . $keys . ")");
    }

    function keys() {
      $keys = array('MODULE_SHIPPING_REGIONS1_STATUS', 'MODULE_SHIPPING_REGIONS1_HANDLING', 'MODULE_SHIPPING_REGIONS1_MODE', 'MODULE_SHIPPING_REGIONS1_SORT_ORDER');

      for ($i=1; $i<=$this->regions1; $i++) {
        $keys[] = 'MODULE_SHIPPING_REGIONS1' . $i;
        $keys[] = 'MODULE_SHIPPING_REGIONS1_COST' . $i;
      }

      return $keys;
    }
  }
?>
