<?php
/*
  $Id: brpay2.php,v 1.0 2006/06/06 19:57:15 hpdl Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  Adapatao: ALAN MAIA - alanmaia@globo.com
  Colaboradores: Para quem ajudar
*/

  class brpay2 {
    var $code, $title, $description, $enabled;

// class constructor
    function brpay2() {
      global $order;

      $this->code = 'brpay2';
      $this->title = MODULE_PAYMENT_BRPAY_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_BRPAY_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_PAYMENT_BRPAY_SORT_ORDER;
      $this->enabled = ((MODULE_PAYMENT_BRPAY_STATUS == 'True') ? true : false);

      if ((int)MODULE_PAYMENT_BRPAY_ORDER_STATUS_ID > 0) {
        $this->order_status = MODULE_PAYMENT_BRPAY_ORDER_STATUS_ID;
      }

      if (is_object($order)) $this->update_status();

      $this->form_action_url = 'https://www.brpay.com.br/security/webpagamentos/webpagto.aspx';
    }

// class methods
    function update_status() {
      global $order;

      if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_BRPAY_ZONE > 0) ) {
        $check_flag = false;
        $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_BRPAY_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
        while ($check = tep_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->billing['zone_id']) {
            $check_flag = true;
            break;
          }
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }

    function javascript_validation() {
      return false;
    }

    function selection() {
      return array('id' => $this->code,
                   'module' => $this->title);
    }

    function pre_confirmation_check() {
      return false;
    }

    function confirmation() {
      return array('title' => MODULE_PAYMENT_BRPAY_TEXT_DESCRIPTION);
    }

    function process_button() {
      global $order, $currencies, $currency;

      if (MODULE_PAYMENT_BRPAY_CURRENCY == 'Selected Currency') {
        $my_currency = $currency;
      } else {
        $my_currency = substr(MODULE_PAYMENT_BRPAY_CURRENCY, 1);
      }
      if (!in_array($my_currency, array('BRL'))) {
        $my_currency = 'BRL';
      }
      $process_button_string = tep_draw_hidden_field('cmd', '_xclick') .
                               tep_draw_hidden_field('email_cobranca', MODULE_PAYMENT_BRPAY_ID) .
                               tep_draw_hidden_field('item_id_1', MODULE_ORDER_TOTAL_TOTAL_TITLE) .
                               tep_draw_hidden_field('item_descr_1', "Sua(s) Compra(s) no Site AazonInfo") .
                               tep_draw_hidden_field('item_quant_1', 1 ) .
                               tep_draw_hidden_field('item_valor_1', number_format($order->info['total']*100)) .
                               tep_draw_hidden_field('item_frete', number_format($order->info['shipping_cost'] * $currencies->get_value($my_currency), $currencies->get_decimal_places($my_currency))) .
                               tep_draw_hidden_field('tipo', CP) .
                               tep_draw_hidden_field('moeda', BRL) .
                               tep_draw_hidden_field('cliente_nome', $order->billing['firstname'] .' '. $order->billing['lastname']).
                               tep_draw_hidden_field('cliente_cep', $order->customer['postcode']).
                               tep_draw_hidden_field('cliente_email', $order->billing['email_address']).
                               tep_draw_hidden_field('submit', tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL')) .
                               tep_draw_hidden_field('cancel_return', tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));

    return $process_button_string;
    }

    function before_process() {
      return false;
    }

    function after_process() {
      return false;
    }

    function output_error() {
      return false;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_BRPAY_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
         tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Habilitar Modulo BRPay', 'MODULE_PAYMENT_BRPAY_STATUS', 'True', 'Voce aceita pagamentos pelo BRPay ?', '6', '3', 'tep_cfg_select_option(array(\'Sim\', \'Nao\'), ', now())");tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('E-Mail', 'MODULE_PAYMENT_BRPAY_ID', 'you@yourbusiness.com', 'Email usado para receber pelo BRPay', '6', '4', now())");
         tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) values ('Define o Status do Pagamento', 'MODULE_PAYMENT_BRPAY_ORDER_STATUS_ID', '0', 'Set the status of orders made with this payment module to this value', '6', '0', 'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', now())");
    }

    function remove() {
         tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
         return array('MODULE_PAYMENT_BRPAY_ID', 'MODULE_PAYMENT_BRPAY_ORDER_STATUS_ID');
    }
  }
?>
