<?php

/*

  aprovafacilvbv.php 16/06/2005

  Mdulo de Pagamento osCommerce 2.2 para aprovar Cartes de Crdito atravs do servio Aprova Fcil com conectividade VerifiedByVisa

  O Aprova Fcil suporta atualmente as bandeiras Visa, Mastercard, Amex, Dinners, Sollo, Fininvest, Hipercard e JCB

  O Aprova Fcil permite vendas  vista ou parceladas utilizando cartes VISA internacionais ou nacionais (valid only in Brazil)

  O download do Aprova Fcil pode ser efetuado em http://www.aprovafacil.com

  Copyright (c) 2004-2005 Cobre Bem Tecnologia <suporte@cobrebem.com>
  Copyright (c) 2002 osCommerce

  Released under the GNU General Public License

*/

  class aprovafacilvbv {
    var $code, $title, $description, $enabled;

// class constructor
    function aprovafacilvbv() {
      global $order;

      $this->code = 'aprovafacilvbv';
      $this->title = MODULE_PAYMENT_APROVAFACILVBV_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_APROVAFACILVBV_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_PAYMENT_APROVAFACILVBV_SORT_ORDER;
      $this->enabled = ((MODULE_PAYMENT_APROVAFACILVBV_STATUS == 'True') ? true : false);

      if ((int)MODULE_PAYMENT_APROVAFACILVBV_ORDER_STATUS_ID > 0) {
        $this->order_status = MODULE_PAYMENT_APROVAFACILVBV_ORDER_STATUS_ID;
      }

      if (is_object($order)) $this->update_status();

      $this->form_action_url = MODULE_PAYMENT_APROVAFACILVBV_CGI;
      //$this->form_action_target = 'loja';
	  $this->form_action_target = '_self';
    }

// class methods
    function update_status() {
      global $order;

      if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_APROVAFACILVBV_ZONE > 0) ) {
        $check_flag = false;
        $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_APROVAFACILVBV_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
        while ($check = tep_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->billing['zone_id']) {
            $check_flag = true;
            break;
          }
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }

    function javascript_validation() {
      return false;
    }

    function selection() {
      for ($i=1; $i <= MODULE_PAYMENT_APROVAFACILVBV_MAXPARCELAS; $i++) {
        $parcelas[] = array('id' => sprintf('%02d', $i), 'text' => sprintf('%02d', $i));
      }

      $selection = array('id' => $this->code,
                         'module' => $this->title,
                         'fields' => array(array('title' => MODULE_PAYMENT_APROVAFACILVBV_TEXT_CREDIT_CARD_NUMBER,
                                                 'field' => tep_draw_input_field('NumeroCartao', '', 'size="7" maxlength="6"')),
                                           array('title' => MODULE_PAYMENT_APROVAFACILVBV_TEXT_PARCELAS,
                                                 'field' => tep_draw_pull_down_menu('QuantidadeParcelas2', $parcelas))));

      return $selection;
    }

    function pre_confirmation_check() {
      return false;
    }

    function confirmation() {
      $confirmation = array('title' => $this->title . '<br>' . MODULE_PAYMENT_APROVAFACILVBV_CONFIRMATION_TEXT);

      return $confirmation;
    }

    function process_button() {
      global $HTTP_POST_VARS, $order;

      $process_button_string = '</form>' . tep_draw_form('checkout_confirmation2', MODULE_PAYMENT_APROVAFACILVBV_CGI . '/APC', 'post', 'target=_top').
                               tep_draw_hidden_field('ValorDocumento', $order->info['total']) .
                               tep_draw_hidden_field('NumeroCartao', $HTTP_POST_VARS['NumeroCartao']) .
                               tep_draw_hidden_field('NumeroDocumento', tep_session_id()) .
                               tep_draw_hidden_field('QuantidadeParcelas', $HTTP_POST_VARS['QuantidadeParcelas2']);

      return $process_button_string;
    }

    function before_process() {
      global $HTTP_GET_VARS, $order;
      $order->info['cc_number'] = $HTTP_GET_VARS[Transacao];
      $order->info['cc_owner'] = $HTTP_GET_VARS[ResultadoSolicitacaoAprovacao];

      return true;
    }

    function after_process() {
      global $order;


// se o php do seu servidor nao possui a opcao para abertura de URL como arquivo a confirmacao
// devera ser efetuada manualmente atraves da chamada da URL em um navegador ou
// montagem de uma pagina para que o usuario confirme as transacoes aprovadas.
// Caso a confirmacao nao seja efetuada em ate 48 horas a venda e considerada nao realizada e a transacao e desfeita.


      $urlapf = MODULE_PAYMENT_APROVAFACILVBV_CGI . "/CAP?" . 'Transacao=' . $order->info['cc_number'];

      $resultadotransacao = file($urlapf);

      return true;
    }

    function get_error() {
      global $HTTP_GET_VARS;

      $error = array('title' => $HTTP_GET_VARS[ResultadoSolicitacaoAprovacao],
                     'error' => ((isset($HTTP_GET_VARS['error'])) ? stripslashes(urldecode($HTTP_GET_VARS['error'])) : APROVAFACILVBV_ERROR_MESSAGE));

      return $error;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_APROVAFACILVBV_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "set_function, date_added".
                   ") values (".
                   "'Aprovao de Cartes de Crdito - Aprova Fcil', 'MODULE_PAYMENT_APROVAFACILVBV_STATUS', 'True', ".
                   "'Voc deseja aprovar cartes de crdito utilizando o Aprova Fcil?', '6', '1', ".
                   "'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "date_added".
                   ") values (".
                   "'URL Aprova Fcil', 'MODULE_PAYMENT_APROVAFACILVBV_CGI', '" . HTTPS_CATALOG_SERVER . "/cgi-bin/CGIAprovaFacil', ".
                   "'Informar a URL para exeuco do Aprova Fcil em www.cobrebem.com.', '6', '2', ".
                   "now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "set_function, date_added".
                   ") values (".
                   "'Quantidade Mxima Parcelas', 'MODULE_PAYMENT_APROVAFACILVBV_MAXPARCELAS', '1', ".
                   "'Voc deseja efetuar vendas parceladas em at quantas parcelas?', '6', '3', ".
                   "'tep_cfg_select_option(array(\'1\', \'2\', \'3\', \'4\', \'5\', \'6\'), ', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "use_function, set_function, date_added".
                   ") values (".
                   "'Zonas suportadas', 'MODULE_PAYMENT_APROVAFACILVBV_ZONE', '0', ".
                   "'Se uma zona for selecionada, somente este meio de pagamento estar disponvel para esta zona.', '6', '4', ".
                   "'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "use_function, set_function, date_added".
                   ") values (".
                   "'Status dos pedidos', 'MODULE_PAYMENT_APROVAFACILVBV_ORDER_STATUS_ID', '2', ".
                   "'Atualiza o status dos pedidos efetuados por este mdulo de pagamento para este valor.', '6', '5', ".
                   "'tep_get_order_status_name', 'tep_cfg_pull_down_order_statuses(', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "date_added".
                   ") values (".
                   "'Texto Pgina de Confirmao', 'MODULE_PAYMENT_APROVAFACILVBV_CONFIRMATION_TEXT', '', ".
                   "'Informar o texto a ser exibido na pgina de confirmao do pedido.', '6', '6', ".
                   "now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (".
                   "configuration_title, configuration_key, configuration_value, ".
                   "configuration_description, configuration_group_id, sort_order, ".
                   "date_added".
                   ") values (".
                   "'Ordem de exibio', 'MODULE_PAYMENT_APROVAFACILVBV_SORT_ORDER', '0', ".
                   "'Determina a ordem de exibio do meio de pagamento.', '6', '7', ".
                   "now())");
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_PAYMENT_APROVAFACILVBV_STATUS', 'MODULE_PAYMENT_APROVAFACILVBV_CGI', 'MODULE_PAYMENT_APROVAFACILVBV_MAXPARCELAS',
                   'MODULE_PAYMENT_APROVAFACILVBV_ZONE', 'MODULE_PAYMENT_APROVAFACILVBV_ORDER_STATUS_ID', 
                   'MODULE_PAYMENT_APROVAFACILVBV_CONFIRMATION_TEXT', 'MODULE_PAYMENT_APROVAFACILVBV_SORT_ORDER');
    }
  }
?>
