# osCommerce, Open Source E-Commerce Solutions
# http://www.oscommerce.com
#
# Database Backup For PR NetHost
# Copyright (c) 2006 PR NetHost
#
# Database: lojatest_loja
# Database Server: localhost
#
# Backup Date: 13/07/2006 14:28:22

drop table if exists address_book;
create table address_book (
  address_book_id int(11) not null auto_increment,
  customers_id int(11) default '0' not null ,
  entry_gender char(1) not null ,
  entry_company varchar(32) ,
  entry_firstname varchar(32) not null ,
  entry_lastname varchar(32) not null ,
  entry_street_address varchar(64) not null ,
  entry_suburb varchar(32) ,
  entry_postcode varchar(10) not null ,
  entry_city varchar(32) not null ,
  entry_state varchar(32) ,
  entry_country_id int(11) default '0' not null ,
  entry_zone_id int(11) default '0' not null ,
  PRIMARY KEY (address_book_id),
  KEY idx_address_book_customers_id (customers_id)
);

drop table if exists address_format;
create table address_format (
  address_format_id int(11) not null auto_increment,
  address_format varchar(128) not null ,
  address_summary varchar(48) not null ,
  PRIMARY KEY (address_format_id)
);

insert into address_format (address_format_id, address_format, address_summary) values ('1', '$firstname $lastname$cr$streets$cr$city, $postcode$cr$statecomma$country', '$city / $country');
insert into address_format (address_format_id, address_format, address_summary) values ('2', '$firstname $lastname$cr$streets$cr$city, $state $postcode$cr$country', '$city, $state / $country');
insert into address_format (address_format_id, address_format, address_summary) values ('3', '$firstname $lastname$cr$streets$cr$city$cr$postcode - $statecomma$country', '$state / $country');
insert into address_format (address_format_id, address_format, address_summary) values ('4', '$firstname $lastname$cr$streets$cr$city ($postcode)$cr$country', '$postcode / $country');
insert into address_format (address_format_id, address_format, address_summary) values ('5', '$firstname $lastname$cr$streets$cr$postcode $city$cr$country', '$city / $country');
drop table if exists banners;
create table banners (
  banners_id int(11) not null auto_increment,
  banners_title varchar(64) not null ,
  banners_url varchar(255) not null ,
  banners_image varchar(64) not null ,
  banners_group varchar(10) not null ,
  banners_html_text text ,
  expires_impressions int(7) default '0' ,
  expires_date datetime ,
  date_scheduled datetime ,
  date_added datetime default '0000-00-00 00:00:00' not null ,
  date_status_change datetime ,
  status int(1) default '1' not null ,
  PRIMARY KEY (banners_id)
);

insert into banners (banners_id, banners_title, banners_url, banners_image, banners_group, banners_html_text, expires_impressions, expires_date, date_scheduled, date_added, date_status_change, status) values ('2', 'PHPmania', 'http://www.phpmania.org', 'banners/oscommerce.gif', '468x50', '', '0', NULL, NULL, '2004-10-21 07:35:27', NULL, '1');
drop table if exists banners_history;
create table banners_history (
  banners_history_id int(11) not null auto_increment,
  banners_id int(11) default '0' not null ,
  banners_shown int(5) default '0' not null ,
  banners_clicked int(5) default '0' not null ,
  banners_history_date datetime default '0000-00-00 00:00:00' not null ,
  PRIMARY KEY (banners_history_id)
);

insert into banners_history (banners_history_id, banners_id, banners_shown, banners_clicked, banners_history_date) values ('1', '2', '3', '0', '2006-07-13 14:25:09');
drop table if exists categories;
create table categories (
  categories_id int(11) not null auto_increment,
  categories_image varchar(64) ,
  parent_id int(11) default '0' not null ,
  sort_order int(3) ,
  date_added datetime ,
  last_modified datetime ,
  PRIMARY KEY (categories_id),
  KEY idx_categories_parent_id (parent_id)
);

insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('1', 'category_hardware.gif', '0', '1', '2004-10-03 10:13:34', '2004-10-03 10:21:05');
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('2', 'category_software.gif', '0', '2', '2004-10-03 10:13:34', NULL);
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('3', 'category_dvd_movies.gif', '0', '3', '2004-10-03 10:13:34', '2004-10-25 21:08:05');
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('4', 'subcategory_graphic_cards.gif', '1', '0', '2004-10-03 10:13:34', NULL);
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('5', 'subcategory_printers.gif', '1', '0', '2004-10-03 10:13:34', NULL);
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('6', 'subcategory_monitors.gif', '1', '0', '2004-10-03 10:13:34', NULL);
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('7', 'subcategory_speakers.gif', '1', '0', '2004-10-03 10:13:34', NULL);
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('8', 'subcategory_keyboards.gif', '1', '0', '2004-10-03 10:13:34', NULL);
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('9', 'subcategory_mice.gif', '1', '0', '2004-10-03 10:13:34', NULL);
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('10', 'subcategory_action.gif', '3', '0', '2004-10-03 10:13:34', '2004-10-15 19:31:02');
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('11', 'subcategory_science_fiction.gif', '3', '0', '2004-10-03 10:13:34', '2004-10-15 19:32:03');
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('12', 'subcategory_comedy.gif', '3', '0', '2004-10-03 10:13:34', '2004-10-15 19:33:00');
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('13', 'subcategory_cartoons.gif', '3', '0', '2004-10-03 10:13:34', '2004-10-15 19:31:24');
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('15', 'subcategory_drama.gif', '3', '0', '2004-10-03 10:13:34', NULL);
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('16', 'subcategory_memory.gif', '1', '0', '2004-10-03 10:13:34', NULL);
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('17', 'subcategory_cdrom_drives.gif', '1', '0', '2004-10-03 10:13:34', NULL);
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('18', 'subcategory_simulation.gif', '2', '0', '2004-10-03 10:13:34', NULL);
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('19', 'subcategory_action_games.gif', '2', '0', '2004-10-03 10:13:34', NULL);
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) values ('20', 'subcategory_strategy.gif', '2', '0', '2004-10-03 10:13:34', NULL);
drop table if exists categories_description;
create table categories_description (
  categories_id int(11) default '0' not null ,
  language_id int(11) default '1' not null ,
  categories_name varchar(32) not null ,
  PRIMARY KEY (categories_id, language_id),
  KEY idx_categories_name (categories_name)
);

insert into categories_description (categories_id, language_id, categories_name) values ('1', '4', 'Hardware');
insert into categories_description (categories_id, language_id, categories_name) values ('2', '4', 'Software');
insert into categories_description (categories_id, language_id, categories_name) values ('3', '4', 'DVD Filmes');
insert into categories_description (categories_id, language_id, categories_name) values ('4', '4', 'Graphics Cards');
insert into categories_description (categories_id, language_id, categories_name) values ('5', '4', 'Printers');
insert into categories_description (categories_id, language_id, categories_name) values ('6', '4', 'Monitores');
insert into categories_description (categories_id, language_id, categories_name) values ('7', '4', 'Speakers');
insert into categories_description (categories_id, language_id, categories_name) values ('8', '4', 'Keyboards');
insert into categories_description (categories_id, language_id, categories_name) values ('9', '4', 'Mice');
insert into categories_description (categories_id, language_id, categories_name) values ('10', '4', 'Ao');
insert into categories_description (categories_id, language_id, categories_name) values ('11', '4', 'Fico');
insert into categories_description (categories_id, language_id, categories_name) values ('12', '4', 'Comdia');
insert into categories_description (categories_id, language_id, categories_name) values ('13', '4', 'Desenhos');
insert into categories_description (categories_id, language_id, categories_name) values ('15', '4', 'Drama');
insert into categories_description (categories_id, language_id, categories_name) values ('16', '4', 'Memory');
insert into categories_description (categories_id, language_id, categories_name) values ('17', '4', 'CDROM Drives');
insert into categories_description (categories_id, language_id, categories_name) values ('18', '4', 'Simulation');
insert into categories_description (categories_id, language_id, categories_name) values ('19', '4', 'Ao');
insert into categories_description (categories_id, language_id, categories_name) values ('20', '4', 'Strategy');
drop table if exists configuration;
create table configuration (
  configuration_id int(11) not null auto_increment,
  configuration_title varchar(64) not null ,
  configuration_key varchar(64) not null ,
  configuration_value varchar(255) not null ,
  configuration_description varchar(255) not null ,
  configuration_group_id int(11) default '0' not null ,
  sort_order int(5) ,
  last_modified datetime ,
  date_added datetime default '0000-00-00 00:00:00' not null ,
  use_function varchar(255) ,
  set_function varchar(255) ,
  PRIMARY KEY (configuration_id)
);

insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1', 'Nome da Loja', 'STORE_NAME', 'PR NetHost', 'O nome da sua loja', '1', '1', '2006-07-13 14:23:34', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('2', 'Nome do Proprietrio', 'STORE_OWNER', 'PR NetHost', 'Nome do Proprietrio da Loja', '1', '2', '2006-07-13 14:23:53', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3', 'E-Mail do Proprietrio', 'STORE_OWNER_EMAIL_ADDRESS', 'seuemail@mail.com', 'E-mail do proprietrio da loja', '1', '3', '2004-10-03 18:56:35', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('4', 'E-Mail dos pedidos', 'EMAIL_FROM', '<Seu-email@seudominio.com>', 'E-mail usado para o envio dos pedidos', '1', '4', '2006-07-13 14:24:12', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('5', 'Pas', 'STORE_COUNTRY', '30', 'Pas onde a loja est localizada', '1', '6', '2004-10-04 19:07:11', '2004-10-03 10:13:34', 'tep_get_country_name', 'tep_cfg_pull_down_country_list(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('6', 'Estado', 'STORE_ZONE', '68', 'Estado onde a loja est localizada', '1', '7', '2004-10-17 12:50:07', '2004-10-03 10:13:34', 'tep_cfg_get_zone_name', 'tep_cfg_pull_down_zone_list(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('7', 'Ordem dos produtos', 'EXPECTED_PRODUCTS_SORT', 'desc', 'Esta  a ordem usada na caixa de seleo dos produtos', '1', '8', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'asc\', \'desc\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('8', 'Como aparecer a ordem dos produtos', 'EXPECTED_PRODUCTS_FIELD', 'date_expected', 'A ordem dos produtos que so mostrados', '1', '9', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'products_name\', \'date_expected\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('9', 'Trocar a moeda corrente do idioma para padro', 'USE_DEFAULT_LANGUAGE_CURRENCY', 'false', 'Mudar automaticamente para a moeda corrente padro do idioma quando for mudado', '1', '10', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('10', 'Avisar pedidos por e-mail', 'SEND_EXTRA_ORDER_EMAILS_TO', '', 'Enviar aviso para o e-mail da loja quando pedidos forem realizados: Name 1 &lt;email@address1&gt;, Name 2 &lt;email@address2&gt;', '1', '11', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('11', 'Usar Search-Engine URLs Seguros (ainda em desenvolvimento)', 'SEARCH_ENGINE_FRIENDLY_URLS', 'false', 'Usar search-engine URLs seguros para todos links de site', '1', '12', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('12', 'Mostrar produtos comprados', 'DISPLAY_CART', 'true', 'Mostrar todos os produtos depois de feito o pedido', '1', '14', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('13', 'Enviar pgina para um amigo', 'ALLOW_GUEST_TO_TELL_A_FRIEND', 'true', 'Permitir que o visitante envie informaes da loja e produtos para amigo', '1', '15', '2004-10-25 19:09:09', '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('14', 'Usar o mtodo de busca padro', 'ADVANCED_SEARCH_DEFAULT_OPERATOR', 'and', 'Mtodo de busca padro', '1', '17', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'and\', \'or\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('15', 'Endereo e Telefone da loja', 'STORE_NAME_ADDRESS', 'Nome da loja Endereo Telefone', 'Isto  o Nome de Loja, Endereo e Telefona para ser usado em documentos imprimveis e exibidos online', '1', '18', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_textarea(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('16', 'Mostrar Quantidades nas categorias', 'SHOW_COUNTS', 'true', 'Mostra quantos produtos esto em cada categoria', '1', '19', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('17', 'Taxas e Impostos', 'TAX_DECIMAL_PLACES', '0', 'Adicionar o valor da taxa a ser cobrado', '1', '20', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('18', 'Mostrar preos com taxas', 'DISPLAY_PRICE_WITH_TAX', 'false', 'Mostrar preo com taxas(impostos) se tiver?', '1', '21', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('19', 'Primeiro nome', 'ENTRY_FIRST_NAME_MIN_LENGTH', '4', 'Quantidade mnima de letras para o primeiro nome', '2', '1', '2004-10-25 19:09:49', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('20', 'Sobrenome', 'ENTRY_LAST_NAME_MIN_LENGTH', '3', 'Quantidade mnima de letras para o sobrenome', '2', '2', '2004-10-25 19:10:06', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('21', 'Data de Nascimento', 'ENTRY_DOB_MIN_LENGTH', '10', 'Quantidade mnima de letras para a data', '2', '3', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('22', 'Seu E-Mail', 'ENTRY_EMAIL_ADDRESS_MIN_LENGTH', '6', 'Quantidade mnima de letras para o e-mail', '2', '4', '2004-10-25 19:12:23', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('23', 'Endereo', 'ENTRY_STREET_ADDRESS_MIN_LENGTH', '5', 'Quantidade mnima de letras para o endereo', '2', '5', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('24', 'Empresa', 'ENTRY_COMPANY_MIN_LENGTH', '2', 'Quantidade mnima de letras para o nome da Empresa', '2', '6', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('25', 'CEP', 'ENTRY_POSTCODE_MIN_LENGTH', '8', 'Quantidade mnima de letras para o CEP', '2', '7', '2004-10-25 19:11:22', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('26', 'Cidade', 'ENTRY_CITY_MIN_LENGTH', '3', 'Quantidade mnima de letras para a Cidade', '2', '8', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('27', 'Estado', 'ENTRY_STATE_MIN_LENGTH', '2', 'Quantidade mnima de letras para o estado', '2', '9', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('28', 'Nmero do Telefone', 'ENTRY_TELEPHONE_MIN_LENGTH', '5', 'Quantidade mnima de nmeros para o telefone', '2', '10', '2004-10-25 19:13:08', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('29', 'Senha', 'ENTRY_PASSWORD_MIN_LENGTH', '5', 'Quantidade mnima de letras para a senha', '2', '11', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('30', 'Nome do Titular do Carto', 'CC_OWNER_MIN_LENGTH', '3', 'Quantidade mnima de letras do nome do titular do carto', '2', '12', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('31', 'Nmero do carto de Crdito', 'CC_NUMBER_MIN_LENGTH', '10', 'Quantidade mnima de nmeros para o carto de crdito', '2', '13', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('32', 'Comentrios', 'REVIEW_TEXT_MIN_LENGTH', '10', 'Quantidade mnima de letras em um comentrio', '2', '14', '2004-10-26 06:18:39', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('33', 'Mais Vendidos', 'MIN_DISPLAY_BESTSELLERS', '1', 'Nmero mnimo de mais vendidos para exibio', '2', '15', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('34', 'Tambm Compraram', 'MIN_DISPLAY_ALSO_PURCHASED', '1', 'Nmero mnimo de produtos para exibio em \\\'Clientes tambm Compraram\\\' box', '2', '16', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('35', 'Livro de Endereos', 'MAX_ADDRESS_BOOK_ENTRIES', '5', 'Nmero mximo de endereos de entrega que um cliente pode ter', '3', '1', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('36', 'Resultado da Busca', 'MAX_DISPLAY_SEARCH_RESULTS', '20', 'Nmero mximo de produtos a serem listados', '3', '2', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('37', 'Links', 'MAX_DISPLAY_PAGE_LINKS', '5', 'Nmero mximo de links em uma pgina', '3', '3', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('38', 'Ofertas', 'MAX_DISPLAY_SPECIAL_PRODUCTS', '8', 'Mximo nmero de ofertas a serem exibidas', '3', '4', '2006-07-13 14:25:38', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('39', 'Novidades', 'MAX_DISPLAY_NEW_PRODUCTS', '8', 'Mximo nmero de novos produtos a serem exibidos em uma categoria', '3', '5', '2006-07-13 14:26:57', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('40', 'Lanamentos', 'MAX_DISPLAY_UPCOMING_PRODUCTS', '10', 'Nmeros mximo de lanamentos a serem exibidos', '3', '6', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('41', 'Lista de Fabricantes', 'MAX_DISPLAY_MANUFACTURERS_IN_A_LIST', '0', 'Usado no box dos fabricantes; quando o nmero de fabricantes exceder este nmero o menu passar a ser de seleo', '3', '7', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('42', 'Tamanho da Caixa de seleo de fabricantes', 'MAX_MANUFACTURERS_LIST', '1', 'Usado no box dos fabricantes; quando o valor  \\\'1\\\' a drop-down list  utilizada no box dos fabricantes.', '3', '7', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('43', 'Tamanho mximo do nome do Fabricante', 'MAX_DISPLAY_MANUFACTURER_NAME_LEN', '15', 'Usado no box dos fabricantes; mximo nmero de letras do nome do fabricante a ser exibido', '3', '8', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('44', 'Comentrios', 'MAX_DISPLAY_NEW_REVIEWS', '6', 'Nmero mximo de comentrios a serem exibidos', '3', '9', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('45', 'Seleo randmica de comentrios', 'MAX_RANDOM_SELECT_REVIEWS', '10', 'Nmero de comentrios que sero utilizados na seleo', '3', '10', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('46', 'Seleo Randmica de Novidades', 'MAX_RANDOM_SELECT_NEW', '10', 'Nmero de comentrios que sero utilizados na seleo', '3', '11', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('47', 'Seleo Randmica de Ofertas', 'MAX_RANDOM_SELECT_SPECIALS', '10', 'Quantos registros sero utilizados para selecionar ofertas a serem exibidas', '3', '12', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('48', 'Categorias a serem listadas', 'MAX_DISPLAY_CATEGORIES_PER_ROW', '3', 'Nmero de categorias a serem listadas por fila', '3', '13', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('49', 'Lista de Novos Produtos', 'MAX_DISPLAY_PRODUCTS_NEW', '10', 'Nmero mximo de produtos a serem listados na pgina de novos produtos', '3', '14', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('50', 'Mais Vendidos', 'MAX_DISPLAY_BESTSELLERS', '5', 'Mximo nmero de mais vendidos a serem exibidos', '3', '15', '2004-10-10 21:07:24', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('51', 'Tambm compraram', 'MAX_DISPLAY_ALSO_PURCHASED', '6', 'Mximo nmero de indicaes a serem exibidos no box \\\'Clientes tambm compraram\\\' box', '3', '16', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('52', 'Historico do Pedido do Cliente', 'MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX', '6', 'Nmero mximo dos produtos a mostrar na caixa do histrico do pedido do cliente', '3', '17', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('53', 'Histrico do Pedido', 'MAX_DISPLAY_ORDER_HISTORY', '10', 'Mostrar nmero mximo de pedidos na pgina do histrico de pedido', '3', '18', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('54', 'Largura da Imagem Pequena', 'SMALL_IMAGE_WIDTH', '100', 'Em pixels', '4', '1', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('55', 'Altura da Imagem Pequena', 'SMALL_IMAGE_HEIGHT', '80', 'Em pixels', '4', '2', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('56', 'Largura da Imagem do Cabealho', 'HEADING_IMAGE_WIDTH', '57', 'Em pixels', '4', '3', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('57', 'Altura da Imagem do Cabealho', 'HEADING_IMAGE_HEIGHT', '40', 'Em pixels', '4', '4', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('58', 'Largura da Imagem da Subcategoria', 'SUBCATEGORY_IMAGE_WIDTH', '100', 'Em pixels', '4', '5', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('59', 'Altura da Imagem da Subcategoria', 'SUBCATEGORY_IMAGE_HEIGHT', '57', 'Em pixels', '4', '6', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('60', 'Calcular tamanho da Imagem', 'CONFIG_CALCULATE_IMAGE_SIZE', 'true', 'Calcula o tamanho da imagem?', '4', '7', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('61', 'Imagem Obrigatria', 'IMAGE_REQUIRED', 'true', 'Abilitar insero obrigatria de imagens.', '4', '8', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('62', 'Sexo (Masculino/Feminino)', 'ACCOUNT_GENDER', 'true', 'Ativar Sexo no cadastro de clientess', '5', '1', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('63', 'Data de Nascimento', 'ACCOUNT_DOB', 'true', 'Ativar Data de nascimento no cadastro de clientes', '5', '2', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('64', 'Empresa', 'ACCOUNT_COMPANY', 'false', 'Ativar Detalhes da Empresa no cadastro de clientes', '5', '3', '2004-10-15 06:56:52', '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('65', 'Bairro', 'ACCOUNT_SUBURB', 'true', 'Ativar Bairro no cadastro de clientes', '5', '4', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('66', 'Estado', 'ACCOUNT_STATE', 'true', 'Ativar Estado no cadastro de clientes', '5', '5', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('67', 'Mdulos instalados', 'MODULE_PAYMENT_INSTALLED', '', 'Lista os arquivos de mdulos de pagamento separados por um ponto e virgula. Esta listagem  automtica.', '6', '0', '2004-10-26 21:53:51', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('68', 'Installed Modules', 'MODULE_ORDER_TOTAL_INSTALLED', 'ot_subtotal.php;ot_shipping.php;ot_tax.php;ot_total.php', 'List of order_total module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: ot_subtotal.php;ot_tax.php;ot_shipping.php;ot_total.php)', '6', '0', '2004-10-13 07:53:18', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('69', 'Mdulos instalados', 'MODULE_SHIPPING_INSTALLED', '', 'Lista os arquivos de mdulos de frete separados por um ponto e virgula. Esta listagem  automtica.', '6', '0', '2004-10-26 21:55:56', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('84', 'Default Currency', 'DEFAULT_CURRENCY', 'BR', 'Default Currency', '6', '0', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('85', 'Default Language', 'DEFAULT_LANGUAGE', 'br', 'Default Language', '6', '0', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('86', 'Default Order Status For New Orders', 'DEFAULT_ORDERS_STATUS_ID', '1', 'When a new order is created, this order status will be assigned to it.', '6', '0', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('87', 'Display Shipping', 'MODULE_ORDER_TOTAL_SHIPPING_STATUS', 'true', 'Do you want to display the order shipping cost?', '6', '1', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('88', 'Sort Order', 'MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER', '2', 'Sort order of display.', '6', '2', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('89', 'Allow Free Shipping', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING', 'false', 'Do you want to allow free shipping?', '6', '3', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('90', 'Free Shipping For Orders Over', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER', '50', 'Provide free shipping for orders over the set amount.', '6', '4', NULL, '2004-10-03 10:13:34', 'currencies->format', NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('91', 'Provide Free Shipping For Orders Made', 'MODULE_ORDER_TOTAL_SHIPPING_DESTINATION', 'national', 'Provide free shipping for orders sent to the set destination.', '6', '5', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'national\', \'international\', \'both\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('92', 'Display Sub-Total', 'MODULE_ORDER_TOTAL_SUBTOTAL_STATUS', 'true', 'Do you want to display the order sub-total cost?', '6', '1', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('93', 'Sort Order', 'MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER', '1', 'Sort order of display.', '6', '2', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('94', 'Display Tax', 'MODULE_ORDER_TOTAL_TAX_STATUS', 'true', 'Do you want to display the order tax value?', '6', '1', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('95', 'Sort Order', 'MODULE_ORDER_TOTAL_TAX_SORT_ORDER', '3', 'Sort order of display.', '6', '2', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('96', 'Display Total', 'MODULE_ORDER_TOTAL_TOTAL_STATUS', 'true', 'Do you want to display the total order value?', '6', '1', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('97', 'Sort Order', 'MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER', '4', 'Sort order of display.', '6', '2', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('98', 'Cdigo do Pas', 'SHIPPING_ORIGIN_COUNTRY', '30', 'Entre o &quot;ISO 3166&quot; cdigo do pas onde se localiza a sua loja.', '7', '1', NULL, '2004-10-03 10:13:34', 'tep_get_country_name', 'tep_cfg_pull_down_country_list(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('99', 'CEP', 'SHIPPING_ORIGIN_ZIP', '70866120', 'Entre o CEP de sua Loja.', '7', '2', '2004-10-25 19:15:19', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('100', 'Entre o peso mximo do pacote que ir entregar', 'SHIPPING_MAX_WEIGHT', '50', 'Carriers have a max weight limit for a single package. This is a common one for all.', '7', '3', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('101', 'Peso Normal dos Pacotes.', 'SHIPPING_BOX_WEIGHT', '', 'Qual  o peso normal dos pacotes que costuma entregar?', '7', '4', '2004-10-20 07:03:51', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('102', 'Pacotes grandes Incrementar porcentagem.', 'SHIPPING_BOX_PADDING', '0', 'Se for 10% coloque 10', '7', '5', '2004-10-20 07:04:03', '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('103', 'Mostrar Imagem do Produto', 'PRODUCT_LIST_IMAGE', '1', 'Escolha 1 para sim ou 0 para no', '8', '1', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('104', 'Mostrar nome dos Fabricantes', 'PRODUCT_LIST_MANUFACTURER', '0', 'Escolha 1 para sim ou 0 para no', '8', '2', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('105', 'Mostrar modelo dos produtos', 'PRODUCT_LIST_MODEL', '0', 'Escolha 1 para sim ou 0 para no', '8', '3', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('106', 'Mostrar nome dos produtos', 'PRODUCT_LIST_NAME', '2', 'Escolha 1 para sim ou 0 para no', '8', '4', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('107', 'Exibir preos dos produtos', 'PRODUCT_LIST_PRICE', '3', 'Escolha 1 para sim ou 0 para no', '8', '5', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('108', 'Mostrar quantidade dos produtos', 'PRODUCT_LIST_QUANTITY', '0', 'Escolha 1 para sim ou 0 para no', '8', '6', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('109', 'Mostrar peso dos produtos', 'PRODUCT_LIST_WEIGHT', '0', 'Escolha 1 para sim ou 0 para no', '8', '7', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('110', 'Mostrar coluna Compre Agora', 'PRODUCT_LIST_BUY_NOW', '4', 'Escolha 1 para sim ou 0 para no', '8', '8', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('111', 'Exibir filtros categorias/fabricantes', 'PRODUCT_LIST_FILTER', '1', 'Escolha 1 para sim ou 0 para no', '8', '9', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('112', 'Escolha a localizao dos botes Anterior/Prxima', 'PREV_NEXT_BAR_LOCATION', '2', '1-topo, 2-em baixo, 3-nos dois lugares', '8', '10', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('113', 'Checar Estoque', 'STOCK_CHECK', 'true', 'Ativar checagem do estoque', '9', '1', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('114', 'Subtrair do Estoque', 'STOCK_LIMITED', 'true', 'Subtrair produto do estoque quando for realizado um pedido', '9', '2', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('115', 'Permitir ir ao caixa', 'STOCK_ALLOW_CHECKOUT', 'true', 'Permitir cliente ir ao caixa mesmo quando o estoque for insuficiente', '9', '3', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('116', 'Marcar produtos fora de estoque', 'STOCK_MARK_PRODUCT_OUT_OF_STOCK', '***', 'Exibir *** quando o produto no estiver disponvel em estoque', '9', '4', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('117', 'Estoque baixo', 'STOCK_REORDER_LEVEL', '5', 'Defina a quantidade crtica do seu estoque', '9', '5', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('118', 'Analisar o tempo na pgina da loja', 'STORE_PAGE_PARSE_TIME', 'false', 'Armazene o tempo que leva para analisar uma pgina', '10', '1', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('119', 'Destino do log', 'STORE_PAGE_PARSE_TIME_LOG', '/var/log/www/tep/page_parse_time.log', 'O diretrio e nome do arquivo da pgina que analisar o tempo do log', '10', '2', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('120', 'Formato da data do log', 'STORE_PARSE_DATE_TIME_FORMAT', '%d/%m/%Y %H:%M:%S', 'O formato da data', '10', '3', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('121', 'Mostrar a pgina analise tempo', 'DISPLAY_PAGE_PARSE_TIME', 'true', 'Mostrar a pgina analise tempo (Deve estar habilitado)', '10', '4', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('122', 'Armazene as informaes do banco de dados', 'STORE_DB_TRANSACTIONS', 'false', 'Armazene as informaes do banco de dados na pgina analise do tempo do log (PHP4 somente)', '10', '5', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('123', 'Use Cache', 'USE_CACHE', 'false', 'Caractersticas use caching', '11', '1', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('124', 'Diretrio do cache', 'DIR_FS_CACHE', '/tmp/', 'O diretrio onde o arquivos cached sero armazenados', '11', '2', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('125', 'E-Mail mtodo de envio', 'EMAIL_TRANSPORT', 'sendmail', 'Defina se este servidor usa uma conexo de local para sendmail ou usa uma conexo de SMTP via TCP/IP. Os servidores que executam em Windows e MacOS deveram mudar este configurando para SMTP.', '12', '1', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'sendmail\', \'smtp\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('126', 'E-Mail Linefeeds', 'EMAIL_LINEFEED', 'LF', 'Defina a seqncia de caractere costuma-se separar cabealhos do email.', '12', '2', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'LF\', \'CRLF\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('127', 'Use MIME HTML quando enviar Emails', 'EMAIL_USE_HTML', 'false', 'Enviar e-mails em formato HTML', '12', '3', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('128', 'Verifique endereos de E-mail por DNS', 'ENTRY_EMAIL_ADDRESS_CHECK', 'false', 'Verifique endereo de e-mail por um servidor de DNS', '12', '4', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('129', 'Enviar E-mails', 'SEND_EMAILS', 'true', 'Enviar e-mails', '12', '5', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('130', 'Ativar download', 'DOWNLOAD_ENABLED', 'false', 'Ativar as funes de download de produtos.', '13', '1', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('131', 'Redirecionar o download', 'DOWNLOAD_BY_REDIRECT', 'false', 'Use redirecionamento de Browser para download. Desativar em sistemas No Unix.', '13', '2', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('132', 'Expiry demora (dias)', 'DOWNLOAD_MAX_DAYS', '7', 'Configurar nmero de dias antes do link de download expirar. 0 no significa nenhum limite.', '13', '3', NULL, '2004-10-03 10:13:34', NULL, '');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('133', 'Nmero mximo de downloads', 'DOWNLOAD_MAX_COUNT', '5', 'Configurar o nmero mximo de downloads. ( 0 ) significa nenhum download autorizado.', '13', '4', NULL, '2004-10-03 10:13:34', NULL, '');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('134', 'Ativar Compresso GZip', 'GZIP_COMPRESSION', 'false', 'Ativar compresso de HTTP GZip.', '14', '1', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('135', 'Nvel de compresso', 'GZIP_LEVEL', '5', 'Use este nvel de compresso 0-9 (0 = mnimo, 9 = mximo).', '14', '2', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('136', 'Diretrio da sesso', 'SESSION_WRITE_DIRECTORY', '/tmp', 'sesses so arquivo baseado, armazene eles neste diretrio.', '15', '1', NULL, '2004-10-03 10:13:34', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('137', 'Forar uso de Cookies', 'SESSION_FORCE_COOKIE_USE', 'False', 'Fora o uso de cookie nas sesses s quando estiver habilitado.', '15', '2', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('138', 'Checar sesso de SSL ID', 'SESSION_CHECK_SSL_SESSION_ID', 'False', 'Validar o SSL_SESSION_ID em todo pedido de pgina de HTTPS seguro.', '15', '3', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('139', 'Checar agente de usurio', 'SESSION_CHECK_USER_AGENT', 'False', 'Validar o agente de usurio de clientes Browser em todo pedido de pgina.', '15', '4', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('140', 'Checar endereo de IP', 'SESSION_CHECK_IP_ADDRESS', 'False', 'Validar o endereo de IP do cliente em todo pedido de pgina.', '15', '5', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('141', 'Previnir sesses de Spider', 'SESSION_BLOCK_SPIDERS', 'False', 'Previnir de Spider antes de comear uma sesso.', '15', '6', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('142', 'Recriar sesso', 'SESSION_RECREATE', 'False', 'Recreie a sesso para gerar uma nova sesso ID quando os logs do cliente em ou cria uma conta (precisa do PHP >=4.1 ).', '15', '7', NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1175', 'Entrega Correios Sedex', 'MODULE_SHIPPING_ENTREGA_REGIONS_STATUS', 'True', 'Ativar Entrega via sedex?', '6', '0', NULL, '2004-10-19 20:42:06', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('541', 'Sort Order', 'MODULE_SHIPPING_REMESSA_NACIONAL_2_SORT_ORDER', '0', 'Sort order of display.', '6', '0', NULL, '2004-10-10 18:21:36', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('493', 'Sort Order', 'MODULE_SHIPPING_REMESSA_NACIONAL_2_SORT_ORDER', '0', 'Sort order of display.', '6', '0', NULL, '2004-10-10 17:53:52', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('517', 'Sort Order', 'MODULE_SHIPPING_REMESSA_NACIONAL_2_SORT_ORDER', '0', 'Sort order of display.', '6', '0', NULL, '2004-10-10 18:10:55', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('616', 'Sort Order', 'MODULE_SHIPPING_REMESSA_NACIONAL_3_SORT_ORDER', '1', 'Sort order of display.', '6', '0', NULL, '2004-10-12 18:06:53', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('640', 'Sort Order', 'MODULE_SHIPPING_REMESSA_NACIONAL_3_SORT_ORDER', '0', 'Sort order of display.', '6', '0', NULL, '2004-10-12 18:24:39', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('785', 'Zone 2 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_2', 'BR,BH', 'Comma separated list of two character ISO country codes that are part of Zone 2.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('786', 'Zone 2 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_2', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 2 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 2 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('787', 'Zone 2 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_2', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('788', 'Zone 3 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_3', '', 'Comma separated list of two character ISO country codes that are part of Zone 3.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('789', 'Zone 3 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_3', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 3 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 3 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('790', 'Zone 3 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_3', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('791', 'Zone 4 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_4', '', 'Comma separated list of two character ISO country codes that are part of Zone 4.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('792', 'Zone 4 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_4', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 4 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 4 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('793', 'Zone 4 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_4', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('794', 'Zone 5 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_5', '', 'Comma separated list of two character ISO country codes that are part of Zone 5.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('795', 'Zone 5 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_5', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 5 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 5 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('796', 'Zone 5 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_5', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('797', 'Zone 6 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_6', '', 'Comma separated list of two character ISO country codes that are part of Zone 6.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('798', 'Zone 6 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_6', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 6 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 6 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('799', 'Zone 6 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_6', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('800', 'Zone 7 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_7', '', 'Comma separated list of two character ISO country codes that are part of Zone 7.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('801', 'Zone 7 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_7', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 7 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 7 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('802', 'Zone 7 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_7', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('803', 'Zone 8 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_8', '', 'Comma separated list of two character ISO country codes that are part of Zone 8.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('804', 'Zone 8 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_8', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 8 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 8 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('805', 'Zone 8 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_8', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('806', 'Zone 9 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_9', '', 'Comma separated list of two character ISO country codes that are part of Zone 9.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('807', 'Zone 9 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_9', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 9 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 9 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('808', 'Zone 9 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_9', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('809', 'Zone 10 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_10', '', 'Comma separated list of two character ISO country codes that are part of Zone 10.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('810', 'Zone 10 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_10', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 10 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 10 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('811', 'Zone 10 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_10', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('812', 'Zone 11 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_11', '', 'Comma separated list of two character ISO country codes that are part of Zone 11.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('813', 'Zone 11 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_11', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 11 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 11 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('814', 'Zone 11 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_11', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('815', 'Zone 12 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_12', '', 'Comma separated list of two character ISO country codes that are part of Zone 12.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('816', 'Zone 12 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_12', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 12 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 12 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('817', 'Zone 12 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_12', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('818', 'Zone 13 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_13', '', 'Comma separated list of two character ISO country codes that are part of Zone 13.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('819', 'Zone 13 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_13', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 13 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 13 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('820', 'Zone 13 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_13', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('821', 'Zone 14 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_14', '', 'Comma separated list of two character ISO country codes that are part of Zone 14.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('822', 'Zone 14 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_14', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 14 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 14 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('823', 'Zone 14 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_14', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('824', 'Zone 15 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_15', '', 'Comma separated list of two character ISO country codes that are part of Zone 15.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('825', 'Zone 15 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_15', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 15 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 15 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('826', 'Zone 15 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_15', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('827', 'Zone 16 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_16', '', 'Comma separated list of two character ISO country codes that are part of Zone 16.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('828', 'Zone 16 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_16', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 16 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 16 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('829', 'Zone 16 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_16', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('830', 'Zone 17 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_17', '', 'Comma separated list of two character ISO country codes that are part of Zone 17.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('831', 'Zone 17 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_17', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 17 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 17 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('832', 'Zone 17 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_17', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('833', 'Zone 18 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_18', '', 'Comma separated list of two character ISO country codes that are part of Zone 18.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('834', 'Zone 18 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_18', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 18 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 18 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('835', 'Zone 18 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_18', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('836', 'Zone 19 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_19', '', 'Comma separated list of two character ISO country codes that are part of Zone 19.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('837', 'Zone 19 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_19', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 19 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 19 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('838', 'Zone 19 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_19', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('839', 'Zone 20 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_20', '', 'Comma separated list of two character ISO country codes that are part of Zone 20.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('840', 'Zone 20 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_20', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 20 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 20 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('841', 'Zone 20 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_20', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('842', 'Zone 21 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_21', '', 'Comma separated list of two character ISO country codes that are part of Zone 21.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('843', 'Zone 21 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_21', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 21 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 21 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('844', 'Zone 21 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_21', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('845', 'Zone 22 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_22', '', 'Comma separated list of two character ISO country codes that are part of Zone 22.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('846', 'Zone 22 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_22', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 22 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 22 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('847', 'Zone 22 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_22', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('848', 'Zone 23 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_23', '', 'Comma separated list of two character ISO country codes that are part of Zone 23.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('849', 'Zone 23 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_23', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 23 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 23 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('850', 'Zone 23 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_23', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('851', 'Zone 24 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_24', '', 'Comma separated list of two character ISO country codes that are part of Zone 24.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('852', 'Zone 24 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_24', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 24 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 24 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('853', 'Zone 24 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_24', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('854', 'Zone 25 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_25', '', 'Comma separated list of two character ISO country codes that are part of Zone 25.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('855', 'Zone 25 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_25', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 25 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 25 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('856', 'Zone 25 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_25', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('857', 'Zone 26 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_26', '', 'Comma separated list of two character ISO country codes that are part of Zone 26.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('858', 'Zone 26 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_26', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 26 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 26 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('859', 'Zone 26 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_26', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('860', 'Zone 27 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_27', '', 'Comma separated list of two character ISO country codes that are part of Zone 27.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('861', 'Zone 27 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_27', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 27 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 27 destinations.', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('862', 'Zone 27 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_27', '0', 'Handling Fee for this shipping zone', '6', '0', NULL, '2004-10-12 18:39:47', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1153', 'Entrega Correios Sedex', 'MODULE_SHIPPING_ENTREGA_REGIONS_STATUS', 'True', 'Ativar Entrega via sedex?', '6', '0', NULL, '2004-10-19 20:42:01', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1217', 'Entrega Correios Sedex', 'MODULE_SHIPPING_ENTREGA_REGIONS_STATUS', 'True', 'Ativar Entrega via sedex?', '6', '0', NULL, '2004-10-19 20:42:25', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1239', 'Entrega Correios Sedex', 'MODULE_SHIPPING_ENTREGA_REGIONS_STATUS', 'True', 'Ativar Entrega via sedex?', '6', '0', NULL, '2004-10-19 20:44:38', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1283', 'Entrega Correios Sedex', 'MODULE_SHIPPING_ENTREGA_REGIONS_STATUS', 'True', 'Ativar Entrega via sedex?', '6', '0', NULL, '2004-10-19 20:48:25', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1305', 'Entrega Correios Sedex', 'MODULE_SHIPPING_ENTREGA_REGIONS_STATUS', 'True', 'Ativar Entrega via sedex?', '6', '0', NULL, '2004-10-19 20:48:26', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1306', 'Last Database Restore', 'DB_LAST_RESTORE', 'oscommerce.sql', 'Last database restore file', '6', '0', '0000-00-00 00:00:00', '2006-07-13 14:22:54', '', '');
drop table if exists configuration_group;
create table configuration_group (
  configuration_group_id int(11) not null auto_increment,
  configuration_group_title varchar(64) not null ,
  configuration_group_description varchar(255) not null ,
  sort_order int(5) ,
  visible int(1) default '1' ,
  PRIMARY KEY (configuration_group_id)
);

insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('1', 'Minha Loja', 'Informaes gerais sobre a loja', '1', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('2', 'Valores Mnimos', 'Valores mnimos para as funes / dados', '2', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('3', 'Valores Mximos', 'Valores mximos para as funes / dados', '3', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('4', 'Imagens', 'Parmetros das Imagens', '4', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('5', 'Detalhes do Cliente', 'Configurao da conta do cliente', '5', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('6', 'Opes de Mdulos', 'Livre de Configurao', '6', '0');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('7', 'Entrega/Pacotes', 'Opes de entrega da sua loja', '7', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('8', 'Lista do Produto', 'Opes de configurao da lista de produtos', '8', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('9', 'Estoque', 'Configuraes do estoque', '9', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('10', 'Log', 'Log configuraes', '10', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('11', 'Cache', 'Cache opces', '11', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('12', 'E-Mail Opes', 'Opes para o envio dos emails', '12', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('13', 'Download', 'Downloadable products options', '13', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('14', 'GZip Compresso', 'Opes de compresso', '14', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('15', 'Sesses', 'Opes de sesses', '15', '1');
drop table if exists counter;
create table counter (
  startdate char(8) ,
  counter int(12) 
);

insert into counter (startdate, counter) values ('20060713', '3');
drop table if exists counter_history;
create table counter_history (
  month char(8) ,
  counter int(12) 
);

drop table if exists countries;
create table countries (
  countries_id int(11) not null auto_increment,
  countries_name varchar(64) not null ,
  countries_iso_code_2 char(2) not null ,
  countries_iso_code_3 char(3) not null ,
  address_format_id int(11) default '0' not null ,
  PRIMARY KEY (countries_id),
  KEY IDX_COUNTRIES_NAME (countries_name)
);

insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('30', 'Brasil', 'BR', 'BRA', '1');
drop table if exists currencies;
create table currencies (
  currencies_id int(11) not null auto_increment,
  title varchar(32) not null ,
  code char(3) not null ,
  symbol_left varchar(12) ,
  symbol_right varchar(12) ,
  decimal_point char(1) ,
  thousands_point char(1) ,
  decimal_places char(1) ,
  value float(13,8) ,
  last_updated datetime ,
  PRIMARY KEY (currencies_id)
);

insert into currencies (currencies_id, title, code, symbol_left, symbol_right, decimal_point, thousands_point, decimal_places, value, last_updated) values ('3', 'Real', 'BR', 'R$', '', '.', ',', '2', '1.00000000', NULL);
drop table if exists customers;
create table customers (
  customers_id int(11) not null auto_increment,
  customers_gender char(1) not null ,
  customers_firstname varchar(32) not null ,
  customers_lastname varchar(32) not null ,
  customers_dob datetime default '0000-00-00 00:00:00' not null ,
  customers_email_address varchar(96) not null ,
  customers_default_address_id int(11) default '0' not null ,
  customers_telephone varchar(32) not null ,
  customers_fax varchar(32) ,
  customers_password varchar(40) not null ,
  customers_newsletter char(1) ,
  PRIMARY KEY (customers_id)
);

drop table if exists customers_basket;
create table customers_basket (
  customers_basket_id int(11) not null auto_increment,
  customers_id int(11) default '0' not null ,
  products_id tinytext not null ,
  customers_basket_quantity int(2) default '0' not null ,
  final_price decimal(15,4) default '0.0000' not null ,
  customers_basket_date_added varchar(8) ,
  PRIMARY KEY (customers_basket_id)
);

drop table if exists customers_basket_attributes;
create table customers_basket_attributes (
  customers_basket_attributes_id int(11) not null auto_increment,
  customers_id int(11) default '0' not null ,
  products_id tinytext not null ,
  products_options_id int(11) default '0' not null ,
  products_options_value_id int(11) default '0' not null ,
  PRIMARY KEY (customers_basket_attributes_id)
);

drop table if exists customers_info;
create table customers_info (
  customers_info_id int(11) default '0' not null ,
  customers_info_date_of_last_logon datetime ,
  customers_info_number_of_logons int(5) ,
  customers_info_date_account_created datetime ,
  customers_info_date_account_last_modified datetime ,
  global_product_notifications int(1) default '0' ,
  PRIMARY KEY (customers_info_id)
);

drop table if exists geo_zones;
create table geo_zones (
  geo_zone_id int(11) not null auto_increment,
  geo_zone_name varchar(32) not null ,
  geo_zone_description varchar(255) not null ,
  last_modified datetime ,
  date_added datetime default '0000-00-00 00:00:00' not null ,
  PRIMARY KEY (geo_zone_id)
);

drop table if exists languages;
create table languages (
  languages_id int(11) not null auto_increment,
  name varchar(32) not null ,
  code char(2) not null ,
  image varchar(64) ,
  directory varchar(32) ,
  sort_order int(3) ,
  PRIMARY KEY (languages_id),
  KEY IDX_LANGUAGES_NAME (name)
);

insert into languages (languages_id, name, code, image, directory, sort_order) values ('4', 'Portugus', 'br', 'icon.gif', 'portugues', '1');
drop table if exists manufacturers;
create table manufacturers (
  manufacturers_id int(11) not null auto_increment,
  manufacturers_name varchar(32) not null ,
  manufacturers_image varchar(64) ,
  date_added datetime ,
  last_modified datetime ,
  PRIMARY KEY (manufacturers_id),
  KEY IDX_MANUFACTURERS_NAME (manufacturers_name)
);

insert into manufacturers (manufacturers_id, manufacturers_name, manufacturers_image, date_added, last_modified) values ('1', 'Matrox', 'manufacturer_matrox.gif', '2004-10-03 10:13:34', NULL);
insert into manufacturers (manufacturers_id, manufacturers_name, manufacturers_image, date_added, last_modified) values ('2', 'Microsoft', 'manufacturer_microsoft.gif', '2004-10-03 10:13:34', NULL);
insert into manufacturers (manufacturers_id, manufacturers_name, manufacturers_image, date_added, last_modified) values ('3', 'Warner', 'manufacturer_warner.gif', '2004-10-03 10:13:34', NULL);
insert into manufacturers (manufacturers_id, manufacturers_name, manufacturers_image, date_added, last_modified) values ('4', 'Fox', 'manufacturer_fox.gif', '2004-10-03 10:13:34', NULL);
insert into manufacturers (manufacturers_id, manufacturers_name, manufacturers_image, date_added, last_modified) values ('5', 'Logitech', 'manufacturer_logitech.gif', '2004-10-03 10:13:34', NULL);
insert into manufacturers (manufacturers_id, manufacturers_name, manufacturers_image, date_added, last_modified) values ('6', 'Canon', 'manufacturer_canon.gif', '2004-10-03 10:13:34', NULL);
insert into manufacturers (manufacturers_id, manufacturers_name, manufacturers_image, date_added, last_modified) values ('7', 'Sierra', 'manufacturer_sierra.gif', '2004-10-03 10:13:34', NULL);
insert into manufacturers (manufacturers_id, manufacturers_name, manufacturers_image, date_added, last_modified) values ('8', 'GT Interactive', 'manufacturer_gt_interactive.gif', '2004-10-03 10:13:34', NULL);
insert into manufacturers (manufacturers_id, manufacturers_name, manufacturers_image, date_added, last_modified) values ('9', 'Hewlett Packard', 'manufacturer_hewlett_packard.gif', '2004-10-03 10:13:34', NULL);
drop table if exists manufacturers_info;
create table manufacturers_info (
  manufacturers_id int(11) default '0' not null ,
  languages_id int(11) default '0' not null ,
  manufacturers_url varchar(255) not null ,
  url_clicked int(5) default '0' not null ,
  date_last_click datetime ,
  PRIMARY KEY (manufacturers_id, languages_id)
);

insert into manufacturers_info (manufacturers_id, languages_id, manufacturers_url, url_clicked, date_last_click) values ('1', '4', 'http://www.matrox.com', '0', NULL);
insert into manufacturers_info (manufacturers_id, languages_id, manufacturers_url, url_clicked, date_last_click) values ('2', '4', 'http://www.microsoft.com', '0', NULL);
insert into manufacturers_info (manufacturers_id, languages_id, manufacturers_url, url_clicked, date_last_click) values ('3', '4', 'http://www.warner.com', '0', NULL);
insert into manufacturers_info (manufacturers_id, languages_id, manufacturers_url, url_clicked, date_last_click) values ('4', '4', 'http://www.fox.com', '0', NULL);
insert into manufacturers_info (manufacturers_id, languages_id, manufacturers_url, url_clicked, date_last_click) values ('5', '4', 'http://www.logitech.com', '0', NULL);
insert into manufacturers_info (manufacturers_id, languages_id, manufacturers_url, url_clicked, date_last_click) values ('6', '4', 'http://www.canon.com', '0', NULL);
insert into manufacturers_info (manufacturers_id, languages_id, manufacturers_url, url_clicked, date_last_click) values ('7', '4', 'http://www.sierra.com', '0', NULL);
insert into manufacturers_info (manufacturers_id, languages_id, manufacturers_url, url_clicked, date_last_click) values ('8', '4', 'http://www.infogrames.com', '0', NULL);
insert into manufacturers_info (manufacturers_id, languages_id, manufacturers_url, url_clicked, date_last_click) values ('9', '4', 'http://www.hewlettpackard.com', '0', NULL);
drop table if exists newsletters;
create table newsletters (
  newsletters_id int(11) not null auto_increment,
  title varchar(255) not null ,
  content text not null ,
  module varchar(255) not null ,
  date_added datetime default '0000-00-00 00:00:00' not null ,
  date_sent datetime ,
  status int(1) ,
  locked int(1) default '0' ,
  PRIMARY KEY (newsletters_id)
);

drop table if exists orders;
create table orders (
  orders_id int(11) not null auto_increment,
  customers_id int(11) default '0' not null ,
  customers_name varchar(64) not null ,
  customers_company varchar(32) ,
  customers_street_address varchar(64) not null ,
  customers_suburb varchar(32) ,
  customers_city varchar(32) not null ,
  customers_postcode varchar(10) not null ,
  customers_state varchar(32) ,
  customers_country varchar(32) not null ,
  customers_telephone varchar(32) not null ,
  customers_email_address varchar(96) not null ,
  customers_address_format_id int(5) default '0' not null ,
  delivery_name varchar(64) not null ,
  delivery_company varchar(32) ,
  delivery_street_address varchar(64) not null ,
  delivery_suburb varchar(32) ,
  delivery_city varchar(32) not null ,
  delivery_postcode varchar(10) not null ,
  delivery_state varchar(32) ,
  delivery_country varchar(32) not null ,
  delivery_address_format_id int(5) default '0' not null ,
  billing_name varchar(64) not null ,
  billing_company varchar(32) ,
  billing_street_address varchar(64) not null ,
  billing_suburb varchar(32) ,
  billing_city varchar(32) not null ,
  billing_postcode varchar(10) not null ,
  billing_state varchar(32) ,
  billing_country varchar(32) not null ,
  billing_address_format_id int(5) default '0' not null ,
  payment_method varchar(32) not null ,
  cc_type varchar(20) ,
  cc_owner varchar(64) ,
  cc_number varchar(32) ,
  cc_expires varchar(4) ,
  last_modified datetime ,
  date_purchased datetime ,
  orders_status int(5) default '0' not null ,
  orders_date_finished datetime ,
  currency char(3) ,
  currency_value decimal(14,6) ,
  PRIMARY KEY (orders_id)
);

drop table if exists orders_products;
create table orders_products (
  orders_products_id int(11) not null auto_increment,
  orders_id int(11) default '0' not null ,
  products_id int(11) default '0' not null ,
  products_model varchar(12) ,
  products_name varchar(64) not null ,
  products_price decimal(15,4) default '0.0000' not null ,
  final_price decimal(15,4) default '0.0000' not null ,
  products_tax decimal(7,4) default '0.0000' not null ,
  products_quantity int(2) default '0' not null ,
  PRIMARY KEY (orders_products_id)
);

drop table if exists orders_products_attributes;
create table orders_products_attributes (
  orders_products_attributes_id int(11) not null auto_increment,
  orders_id int(11) default '0' not null ,
  orders_products_id int(11) default '0' not null ,
  products_options varchar(32) not null ,
  products_options_values varchar(32) not null ,
  options_values_price decimal(15,4) default '0.0000' not null ,
  price_prefix char(1) not null ,
  PRIMARY KEY (orders_products_attributes_id)
);

drop table if exists orders_products_download;
create table orders_products_download (
  orders_products_download_id int(11) not null auto_increment,
  orders_id int(11) default '0' not null ,
  orders_products_id int(11) default '0' not null ,
  orders_products_filename varchar(255) not null ,
  download_maxdays int(2) default '0' not null ,
  download_count int(2) default '0' not null ,
  PRIMARY KEY (orders_products_download_id)
);

drop table if exists orders_status;
create table orders_status (
  orders_status_id int(11) default '0' not null ,
  language_id int(11) default '1' not null ,
  orders_status_name varchar(32) not null ,
  PRIMARY KEY (orders_status_id, language_id),
  KEY idx_orders_status_name (orders_status_name)
);

insert into orders_status (orders_status_id, language_id, orders_status_name) values ('1', '4', 'Pendente');
insert into orders_status (orders_status_id, language_id, orders_status_name) values ('2', '4', 'Processando');
insert into orders_status (orders_status_id, language_id, orders_status_name) values ('3', '4', 'Enviado');
drop table if exists orders_status_history;
create table orders_status_history (
  orders_status_history_id int(11) not null auto_increment,
  orders_id int(11) default '0' not null ,
  orders_status_id int(5) default '0' not null ,
  date_added datetime default '0000-00-00 00:00:00' not null ,
  customer_notified int(1) default '0' ,
  comments text ,
  PRIMARY KEY (orders_status_history_id)
);

drop table if exists orders_total;
create table orders_total (
  orders_total_id int(10) unsigned not null auto_increment,
  orders_id int(11) default '0' not null ,
  title varchar(255) not null ,
  text varchar(255) not null ,
  value decimal(15,4) default '0.0000' not null ,
  class varchar(32) not null ,
  sort_order int(11) default '0' not null ,
  PRIMARY KEY (orders_total_id),
  KEY idx_orders_total_orders_id (orders_id)
);

drop table if exists products;
create table products (
  products_id int(11) not null auto_increment,
  products_quantity int(4) default '0' not null ,
  products_model varchar(12) ,
  products_image varchar(64) ,
  products_price decimal(15,4) default '0.0000' not null ,
  products_date_added datetime default '0000-00-00 00:00:00' not null ,
  products_last_modified datetime ,
  products_date_available datetime ,
  products_weight decimal(5,2) default '0.00' not null ,
  products_status tinyint(1) default '0' not null ,
  products_tax_class_id int(11) default '0' not null ,
  manufacturers_id int(11) ,
  products_ordered int(11) default '0' not null ,
  PRIMARY KEY (products_id),
  KEY idx_products_date_added (products_date_added)
);

insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('1', '500', 'MG200MMS', 'matrox/mg200mms.gif', '299.9900', '2004-10-03 10:13:34', '2004-10-25 19:43:55', NULL, '1.00', '1', '0', '1', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('2', '500', 'MG400-32MB', 'matrox/mg400-32mb.gif', '499.9900', '2004-10-03 10:13:34', '2004-10-25 19:44:16', NULL, '1.00', '1', '1', '1', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('3', '500', 'MSIMPRO', 'microsoft/msimpro.gif', '49.9900', '2004-10-03 10:13:34', '2004-10-25 19:43:06', NULL, '1.00', '1', '0', '3', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('4', '500', 'DVD-RPMK', 'dvd/replacement_killers.gif', '42.0000', '2004-10-03 10:13:34', '2004-10-25 20:49:11', NULL, '1.00', '1', '0', '3', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('5', '500', 'DVD-BLDRNDC', 'dvd/blade_runner.gif', '35.9900', '2004-10-03 10:13:34', '2004-10-25 21:06:43', NULL, '1.00', '1', '0', '3', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('6', '10500', 'DVD-MATR', 'dvd/the_matrix.gif', '39.9900', '2004-10-03 10:13:34', '2004-10-25 20:47:18', NULL, '1.00', '1', '0', '3', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('7', '500', 'DVD-YGEM', 'dvd/youve_got_mail.gif', '34.9900', '2004-10-03 10:13:34', '2004-10-25 20:56:35', NULL, '7.00', '1', '0', '3', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('8', '500', 'DVD-ABUG', 'dvd/a_bugs_life.gif', '35.9900', '2004-10-03 10:13:34', '2004-10-25 20:57:52', NULL, '1.00', '1', '0', '3', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('9', '500', 'DVD-UNSG', 'dvd/under_siege.gif', '29.9900', '2004-10-03 10:13:34', '2004-10-25 20:51:18', NULL, '1.00', '1', '0', '3', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('10', '500', 'DVD-UNSG2', 'dvd/under_siege2.gif', '29.9900', '2004-10-03 10:13:34', '2004-10-25 20:53:24', NULL, '1.00', '1', '0', '3', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('11', '500', 'DVD-FDBL', 'dvd/fire_down_below.gif', '29.9900', '2004-10-03 10:13:34', '2004-10-25 20:09:14', NULL, '1.00', '1', '0', '3', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('12', '500', 'DVD-DHWV', 'dvd/die_hard_3.gif', '39.9900', '2004-10-03 10:13:34', '2004-10-25 20:06:54', NULL, '1.00', '1', '0', '4', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('13', '500', 'DVD-LTWP', 'dvd/lethal_weapon.gif', '34.9900', '2004-10-03 10:13:34', '2004-10-25 20:38:13', NULL, '1.00', '1', '0', '3', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('14', '500', 'DVD-REDC', 'dvd/red_corner.gif', '32.0000', '2004-10-03 10:13:34', '2004-10-25 21:04:44', NULL, '1.00', '1', '0', '3', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('16', '500', 'DVD-CUFI', 'dvd/courage_under_fire.gif', '38.9900', '2004-10-03 10:13:34', '2004-10-25 21:01:26', NULL, '1.00', '1', '0', '4', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('17', '500', 'DVD-SPEED', 'dvd/speed.gif', '39.9900', '2004-10-03 10:13:34', '2004-10-25 20:41:31', NULL, '7.00', '1', '0', '4', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('18', '500', 'DVD-SPEED2', 'dvd/speed_2.gif', '42.0000', '2004-10-03 10:13:34', '2004-10-25 20:45:00', NULL, '1.00', '1', '1', '4', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('19', '500', 'DVD-TSAB', 'dvd/theres_something_about_mary.gif', '49.9900', '2004-10-03 10:13:34', '2004-10-25 20:55:20', NULL, '1.00', '1', '0', '4', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('20', '500', 'DVD-BELOVED', 'dvd/beloved.gif', '54.9900', '2004-10-03 10:13:34', '2004-10-25 20:59:37', NULL, '1.00', '1', '0', '3', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('21', '500', 'PC-SWAT3', 'sierra/swat_3.gif', '79.9900', '2004-10-03 10:13:34', '2004-10-25 19:55:06', NULL, '1.00', '1', '1', '7', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('22', '500', 'PC-UNTM', 'gt_interactive/unreal_tournament.gif', '89.9900', '2004-10-03 10:13:34', '2004-10-25 19:52:56', NULL, '1.00', '1', '1', '8', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('23', '500', 'PC-TWOF', 'gt_interactive/wheel_of_time.gif', '99.9900', '2004-10-03 10:13:34', '2004-10-25 20:01:58', NULL, '1.00', '1', '0', '3', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('24', '500', 'PC-DISC', 'gt_interactive/disciples.gif', '90.0000', '2004-10-03 10:13:34', '2004-10-25 19:59:54', NULL, '1.00', '1', '0', '3', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('25', '500', 'MSINTKB', 'microsoft/intkeyboardps2.gif', '69.9900', '2004-10-03 10:13:34', '2004-10-25 19:44:55', NULL, '1.00', '1', '0', '2', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('26', '500', 'MSIMEXP', 'microsoft/imexplorer.gif', '64.9500', '2004-10-03 10:13:34', '2004-10-25 19:43:27', NULL, '1.00', '1', '0', '2', '0');
insert into products (products_id, products_quantity, products_model, products_image, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered) values ('27', '500', 'HPLJ1100XI', 'hewlett_packard/lj1100xi.gif', '499.9900', '2004-10-03 10:13:34', '2004-10-25 19:49:59', NULL, '10.00', '1', '0', '9', '0');
drop table if exists products_attributes;
create table products_attributes (
  products_attributes_id int(11) not null auto_increment,
  products_id int(11) default '0' not null ,
  options_id int(11) default '0' not null ,
  options_values_id int(11) default '0' not null ,
  options_values_price decimal(15,4) default '0.0000' not null ,
  price_prefix char(1) not null ,
  PRIMARY KEY (products_attributes_id)
);

insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix) values ('1', '1', '4', '1', '0.0000', '+');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix) values ('2', '1', '4', '2', '50.0000', '+');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix) values ('3', '1', '4', '3', '70.0000', '+');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix) values ('4', '1', '3', '5', '0.0000', '+');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix) values ('5', '1', '3', '6', '100.0000', '+');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix) values ('6', '2', '4', '3', '10.0000', '-');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix) values ('7', '2', '4', '4', '0.0000', '+');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix) values ('8', '2', '3', '6', '0.0000', '+');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix) values ('9', '2', '3', '7', '120.0000', '+');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix) values ('10', '26', '3', '8', '0.0000', '+');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix) values ('11', '26', '3', '9', '6.0000', '+');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix) values ('26', '22', '5', '10', '0.0000', '+');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix) values ('27', '22', '5', '13', '0.0000', '+');
drop table if exists products_attributes_download;
create table products_attributes_download (
  products_attributes_id int(11) default '0' not null ,
  products_attributes_filename varchar(255) not null ,
  products_attributes_maxdays int(2) default '0' ,
  products_attributes_maxcount int(2) default '0' ,
  PRIMARY KEY (products_attributes_id)
);

insert into products_attributes_download (products_attributes_id, products_attributes_filename, products_attributes_maxdays, products_attributes_maxcount) values ('26', 'unreal.zip', '7', '3');
drop table if exists products_description;
create table products_description (
  products_id int(11) not null auto_increment,
  language_id int(11) default '1' not null ,
  products_name varchar(64) not null ,
  products_description text ,
  products_url varchar(255) ,
  products_viewed int(5) default '0' ,
  PRIMARY KEY (products_id, language_id),
  KEY products_name (products_name)
);

insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('1', '4', 'Matrox G200 MMS', 'Agora voc j pode adquirir a poderosa placa Matrox, uma das placas mais 
poderosas do momento, ela possui o sistema VE (Suporta dois monitores 
simultaneamente), e com ela os seus jogos 3D ganharam mais vida e voc tera um 
otimo desempenho em todos os tipos de trababalho com o sistema Dual Display. <br>
<br>
Especificaes :<br>
Modelo: Matrox G200 Quad Multi - Monitor Series ( MMS ) Graphics Controller ( 32 
MB ) <br>
Maior Performance 2D/3D<br>
Alta Qualidade em DVD Playback<br>
Arquitetura Grfica: 256-bit <br>
Memria: 32MB DDR <br>
Chip Set: Millennium G200 <br>
Plug and Play <br>
<br>
Caractersticas Especiais:<br>
-Saida para TV (TV-Out)<br>
-Excelente performance em jogos 3D e 2D<br>
-Sistema VE Dual Edition:<br>
Suporta dois monitores simultaneamente.', 'www.matrox.com/mga/products/g200_mms/home.cfm', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('2', '4', 'Matrox G400 32MB', 'Alta performance Grfica</b> <br>
<br>
Millennium G400 Series -  extremamente diferente com alta performance grfica, 
o chip da Millennium G400 Series tem grande velocidade e alta qualidade das 
imagens, junto com uma inigualvel versatilidade exibindo todas as imagens 3D, 
2D e ainda aplicativos DVD.  a mais poderosa e inovadora ferramenta para PC\'s.<br>
A Millennium G400 Series no muda somente o modo como voc v os seus grficos 
mas, revolucionar o modo como voc v o seu computador. <br>
<br>
<b>Especificaes:</b> </p>
<ul>
  <li>Nova Matrox G400 256-bit DualBus graphics chip </li>
  <li>Alta performance em 3D, 2D e DVD </li>
  <li>Sistema VE Dual Edition: Suporta dois monitores simultaneamente. </li>
  <li>Sada para DVD e TV </li>
  <li>Qualidade de Cor Vibrante com modelo tridimensional </li>
  <li>UltraSharp DAC of up to 360 MHz </li>
  <li>Processador 3D Rendering Array </li>
  <li>Suporte para 16 ou 32 MB de memria</li>
</ul>', 'www.matrox.com/mga/products/mill_g400/home.htm', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('3', '4', 'Microsoft IntelliMouse Pro', 'O Microsoft IntelliMouse  o mais novo membro da famlia de produtos de 
mouse. A nova esfera posicionada no centro entre os dois botes fornece nova 
funcionalidade no Windows 95, 98,ME,XP, Internet Explorer 6.0 e no conjunto de 
produtos do Office 2003. <br>
<br>
Benefcios<br>
Todos os aplicativos do Office 2003 sero compatveis com o novo mouse, 
permitindo ao usurio a transferncia com zoom, rolagem e zoom de dados para o 
mouse. <br>
A rolagem no Windows Explorer pode ser feita com o mouse - barras de rolagem 
nunca mais! <br>
Acesse rapidamente os vnculos ativos na Web (zoom de dados) e retorne  home 
page usando o mouse. Agora, navegar nas pginas Web  to fcil quanto usar o 
Word e o IntelliMouse, rolando com a esfera.</p>', 'www.microsoft.com/hardware/mouse/intellimouse.asp', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('4', '4', 'Assassinos Substitutos', 'Ttulo Original: &quot;The Replacement Killers&quot; <br>
<br>
Cdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>
Idioma: Ingls, Alemo. <br>
Legendas: Ingls, Alemo, Espanhol. <br>
Audio: Dolby Surround 5.1. <br>
Formato da Tela: 16:9 Wide-Screen. <br>
Durao: (aprox) 80 minutes. <br>
Outros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>
<br>
Sinopse:O astro dos filmes de John Woo, Chow Yun-Fat faz sua estria em 
Hollywood tendo ao seu lado Mira Sorvino (vencedora do Oscar de 1995 como Melhor 
Atriz Coadjuvante, em Poderosa Afrodite) em ASSASSINOS SUBSTITUTOS, um frentico 
e explosivo suspense de ao do diretor Antoine Fuqua (do video-clip de Coolio &quot;Gangsta\'s 
Paradise&quot;). <br>
Aps trair Mr. Wei, o impiedoso chefo do crime que o havia contratado para 
vingar a morte do filho, o assassino profissional John Lee (Chow) agora est 
fugindo. Contando com a ajuda da bela falsificadora de documentos Meg Coburn (Sorvino), 
Lee pretende retornar para sua famlia na China, antes que esta seja vitimada 
por causa de sua traio. Mas a armada de Wei de &quot;assassinos substitutos&quot; est 
na sua trilha, e agora ele e Meg so os alvos de um impressionante poder de 
fogo. <br>
Com os dois lados totalmente armados e determinados a lutar at a morte, um 
tiroteio ultra-violento explode quando finalmente os dois grupos se encontram.  
&quot;uma fuso nunca antes vista do estilo com a ao e a aventura dos filmes de 
Hong Kong&quot; (The New York Times) que vai deixar todos sem flego - incluindo 
voc!</p>', 'www.replacement-killers.com', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('5', '4', 'Busca Frentica', 'Ttulo Original: &quot;Frantic&quot; <br>
<br>
Cdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>
Idioma: Ingls, Alemo. <br>
Legendas: Ingls, Alemo, Espanhol. <br>
Audio: Dolby Surround 5.1. <br>
Formato da Tela: 16:9 Wide-Screen. <br>
Durao: (aprox) 115 minutes. <br>
Outros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>
<br>
Sinopse: Harrison Ford  o Dr. Richard Walker, famoso mdico que junto com sua 
esposa Sondra (Betty Buckley), visitam Paris pela segunda vez. <br>
Pela primeira vez, viveram uma lua-de-mel inesquecvel. Agora eles vo viver 
momentos de suspense e terror. Tudo comea quando Sondra desaparece 
misteriosamente do hotel e Walker se v sozinho em uma terra estranha, sem 
pistas e sem ningum. At que surge a linda Michelle (Eammanuelle Seigner) que 
resolve ajud-lo e o leva  aterradora realidade do submundo de uma busca 
incansvel por sua esposa. <br>
Dirigido pelo aclamado Roman Polanski, BUSCA FRENTICA  um thriller de ao e 
suspense de tirar o flego. Prepare-se para muita adrenalina.</p>', 'www.bladerunner.com', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('6', '4', 'Matrix', 'Ttulo Original: \"The Matrix\" <br>
<br>
Cdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>
Idioma: Ingls, Alemo. <br>
Legendas: Ingls, Alemo, Espanhol. <br>
Audio: Dolby Surround 5.1. <br>
Formato da Tela: 16:9 Wide-Screen. <br>
Durao: (aprox) 131 minutes. <br>
Outros: Menu interativo, Seleo de captulos, Making Of. <br><br>
Sinopse: <br><br>
O que vemos: Nosso dia a dia  verdadeiro. <br>
O que  real: O mundo  uma farsa, construdo por uma das mais poderosas 
mquinas com inteligncia artificial para nos controlar. <br>
Proezas de tirar o flego. Efeitos alucinantes. Cenas de arrebentar. Keanu 
Reeves e Laurence Fishburne lutam pela libertao da humanidade em Matrix, um 
suspense ciberntico para ver e rever muitas vezes, escrito e dirigido pelos 
Irmos Wachowski (Ligadas pelo Desejo). Uma surpreendente histria, com efeitos 
visuais alucinantes, marcando uma nova era no cinema. Um filme arrasador.</p>', 'www.thematrix.com', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('7', '4', 'Mensagem para voc', 'Ttulo Original: &quot;You\'ve Got Mail&quot; <br>
<br>
Cdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>
Idioma: Ingls, Alemo, Espanhol. <br>
Legendas: Ingls, Alemo, Espanhol, Francs, Nrdico, Polons. <br>
Audio: Dolby Surround 5.1. <br>
Formato da Tela: 16:9 Wide-Screen. <br>
Durao: (aprox) 115 minutes. <br>
Outros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>
<br>
Sinopse: MENSAGEM PARA VOC confirma todo romance, charme e emoo que as 
pessoas poderiam esperar do reencontro das estrelas Tom Hanks e Meg Ryan e da 
diretora Nora Ephron de Sintonia de Amor. Greg Kinnear, Parker Posey, Jean 
Stapleton e outros coadjuvantes so os ingredientes perfeitos adicionados a este 
romance moderno em que o proprietrio magnata de uma super-loja de livros e a 
dona de uma aconchegante livraria infantil so correspondentes annimos por 
e-mail que se apaixonam perdidamente sem saber que so, na verdade, rivais nos 
negcios</p>', 'www.youvegotmail.com', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('8', '4', 'Vida de Inseto', 'Ttulo Original: &quot;A Bug\'s Life&quot; <br>
<br>
Cdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>
Idioma: Ingls, Alemo. <br>
Legendas: Ingls, Alemo, Espanhol. <br>
Audio: Dolby Surround 5.1. <br>
Formato da Tela: 16:9 Wide-Screen. <br>
Durao: (aprox) 91 minutes. <br>
Outros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>
<br>
Sinopse: Entre numa viagem folha a folha dentro do minsculo mundo dos insetos, 
junto com os mais diferentes, coloridos e divertidos personagens, na animao 
computadorizada Disney/Pixar VIDA DE INSETO. <br>
Flik  uma formiga cheia de idias que, em nome dos &quot;insetos oprimidos de todo o 
mundo&quot;, precisa contratar guerreiros para defender sua colnia de um faminto 
bando de gafanhotos liderado por Hopper. Mas quando descobrem que o exrcito de 
insetos  na verdade um fracassado grupo de atores de um circo de pulgas, o 
cenrio est armado para divertidas confuses... com estes improvveis heris.
<br>
Estrelando um elenco de dubladores sensacionais, VIDA DE INSETO apresenta uma 
nova e surpreendente viso de trabalho de equipe e determinao, que revela 
novos detalhes cada vez que voc assiste.</p>', 'www.abugslife.com', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('9', '4', 'Fora em Alerta', 'Ttulo Original: &quot;Under Siege&quot; <br>
<br>
Cdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>
Idioma: Ingls, Alemo. <br>
Legendas: Ingls, Alemo, Espanhol. <br>
Audio: Dolby Surround 5.1. <br>
Formato da Tela: 16:9 Wide-Screen. <br>
Durao: (aprox) 98 minutes. <br>
Outros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>
<br>
Sinopse: O encouraado USS Missouri prepara-se para a ltima viagem. A Marinha 
organiza uma grande festa. Porm, so surpreendidos com a presena de 
terroristas que pretendem roubar o arsenal de armas nucleares do navio e 
provocar a 3a. Guerra Mundial. Com incrvel percia em artes marciais, est a 
bordo o cozinheiro Casey Ryback (Steven Seagal, de Nico - Acima da Lei), que 
prepara para os terroristas uma receita explosiva. Ele conta com a ajuda da bela 
garota da Playboy Erika Eleniak contra esses bandidos da pesada, que esto sendo 
liderados por um ex-agente da CIA (Tommy Lee Jones, de O Cliente) e um oficial 
que trai a Marinha (Gary Busey, de Mquina Mortfera).</p>', '', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('10', '4', 'Fora em Alerta 2', 'Ttulo Original: &quot;Under Siege 2 - Dark Territory&quot; <br>
<br>
Cdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>
Idioma: Ingls, Alemo. <br>
Legendas: Ingls, Alemo, Espanhol. <br>
Audio: Dolby Surround 5.1. <br>
Formato da Tela: 16:9 Wide-Screen. <br>
Durao: (aprox) 98 minutes. <br>
Outros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>
<br>
Sinopse: O manaco Travis Dane (Eric Bogosian) sequestrou um luxuoso trem de 
passageiros e o transformou em um centro de comando de alta tecnologia, capaz de 
controlar um poderoso satlite americano. Seu plano: destruir a Costa Leste dos 
Estados Unidos. Seu alvo: um reator nuclear, localizado nos subterrneos do 
Pentgono. Seu preo: um bilho de dlares. Seu problema: Casey Ryback (Steven 
Seagal, de A Fora em Alerta) um dos passageiros a bordo do trem. 
Ex-especialista da marinha, Casey  uma arma letal de combate. <br>
Com o trem se dirigindo a um territrio selvagem, onde todos os tipos de 
comunicao externa so naturalmente interrompidos, a vida de trs milhes de 
pessoas depende das habilidade mortais de Ryback, que enfrentar sozinho Travis 
e seus perigosos terroristas</p>', '', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('11', '4', 'Ameaa Subterrnea', 'Ttulo Original: &quot;Fire Down Below&quot; <br>
<br>
Cdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>
Idioma: Ingls, Alemo. <br>
Legendas: Ingls, Alemo, Espanhol. <br>
Audio: Dolby Surround 5.1. <br>
Formato da Tela: 16:9 Wide-Screen. <br>
Durao: (aprox) 104 minutes. <br>
Outros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>
Sinopse: O Agente Federal de proteo ambiental Jack Taggart (Steven Seagal, de 
A Fora em Alerta) est investigando a morte de um colega. Seguindo as pistas 
deixadas pelo agente assassinado, Jack parte em viagem pelas pequenas 
comunidades ruais do Kentucky. Em pouco tempo, ele descobre que toneladas de 
residuos txicos esto sendo despejadas nas antigas minas de carvo da regio. 
Muitos habitantes locais esto ficando doentes, mas os criminosos esto 
protegidos pelo silncio de uma cidade dominada pelo medo. Taggart descobre 
informaes importantes conta o poderoso minerador Orin Hanner (Kris 
Kristofferson, de Rodeio da Vida) e decide enfrent-lo antes que uma catstrofe 
ecolgica destrua completamente a regio.', '', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('12', '4', 'Duro de Matar', 'Cdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>
Idioma: Ingls, Alemo. <br>
Legendas: Ingls, Alemo, Espanhol. <br>
Audio: Dolby Surround 5.1. <br>
Formato da Tela: 16:9 Wide-Screen. <br>
Durao: (aprox) 122 minutes. <br>
Outros: Menu Interativo, Seleo de Captulos, Legendas (Mais idiomas). <br>
<br>
Em Nova York, o terrorista Simon (Jeremy Irons) explode uma bomba dentro de um 
shopping lotado. John Mc Lane (Bruce Willis) corre contra o tempo, desvendando 
charadas propostas pelo vilo. <br>
GRAHAM GREENE BRUCE WILLIS SAMUEL L. JACKSON COLLEEN CAMP LARRY BRYGGMAN SAM 
PHILLIPS JEREMY IRONS', '', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('13', '4', 'Mquina Mortfera', 'Ttulo Original: &quot;Lethal Weapon&quot; <br>
<br>
Cdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>
Idioma: Ingls, Alemo. <br>
Legendas: Ingls, Alemo, Espanhol. <br>
Audio: Dolby Surround 5.1. <br>
Formato da Tela: 16:9 Wide-Screen. <br>
Durao: (aprox) 100 minutes. <br>
Outros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>
<br>
Sinopse:Martin Riggs (Mel Gibson, da famosa srie Mad Max) no  um policial 
comum.  um Mad Max que se tornou manaco, um homem cuja destreza para matar e 
tendncias suicidas o tranformam numa Mquina Mortfera para qualquer um que 
esteja tanto contra como a seu favor. Roger Murtaugh (Danny Glover, de A Cor 
Prpura)  um tranqilo detetive de homicdios, que ama sua famlia, tem uma 
bela casa, e espera uma boa aposentadoria que no quer perder. Imagine o susto 
de Murtaugh quando descobre que seu novo parceiro ser algum que no tenha nada 
a perder: o desvairado e desprezado Martin Riggs.', '', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('14', '4', 'Justia Vermelha', 'Ttulo Original: &quot;Red Corner&quot; <br>
<br>
Cdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>
Idioma: Ingls, Alemo. <br>
Legendas: Ingls, Alemo, Espanhol. <br>
Audio: Dolby Surround 5.1. <br>
Formato da Tela: 16:9 Wide-Screen. <br>
Durao: (aprox) 117 minutes. <br>
Outros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>
<br>
Sinopse: <br>
Na histria, Richard Gere interpreta Jack Moore, um brilhante advogado de um 
grande conglomerado de entretenimento e o melhor negociador que o Ocidente tem 
para oferecer. Ele est na China para fechar o primeiro contrato de comunicao 
de satlites sancionado pelo governo chins mas, aps uma noite com uma mulher 
extica, se v envolvido numa trama que pe sua vida em jogo. Preso por um 
assassinato que no cometeu e abandonado por seus colegas de trabalho 
americanos, Jack precisa encontrar uma sada desse labirinto conhecido como 
sistema judicial chins. Diferente da Amrica, um culpado por ofensa capital na 
China  morto no perodo de uma semana aps a sua sentena e o custo da munio 
 cobrado  sua famlia; um julgamento nesse pas dura, em mdia, menos de 
quatro horas, e o grau de convico beira os 99%. <br>
A nica chance de Jack  sua advogada de defesa, Shen Yuelin (Bai Ling), 
apontada pela corte. Imediatamente, ela entra com uma declarao de culpa 
insistindo ser a nica forma de salvar a vida de seu cliente - &quot;clemncia 
queles que confessam; severidade queles que resistem&quot;. <br>
Ela acredita na inocncia de Jack e, ao se comprometer em salv-lo dentro de um 
sistema imperdovel, est se comprometendo a sacrificar sua vida. Trabalhando 
juntos, apesar das grandes diferenas culturais, os dois comeam a descobrir 
evidncias bizarras do envolvimento de membros do alto escalo do governo.</p>', '', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('16', '4', 'Coragem Sob Fogo', 'Ttulo Original: &quot;Courage Under Fire&quot; <br>
<br>
Cdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>
Idioma: Ingls, Alemo. <br>
Legendas: Ingls, Alemo, Espanhol. <br>
Audio: Dolby Surround 5.1. <br>
Formato da Tela: 16:9 Wide-Screen. <br>
Durao: (aprox) 112 minutes. <br>
Outros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>
<br>
Sinopse: <br>
&quot;Em tempo de guerra, a primeira baixa  sempre a verdade.&quot; <br>
Janeiro de 1991. O mundo est assistindo  Guerra do Golfo dia e noite, milhes 
de pessoas sintonizam a CNN para ver a vida real e o drama da morte nas cidades 
e desertos do Iraque. <br>
Como o Exrcito americano ocupa um lugar de destaque na trama, o Departamento de 
Relaes Pblicas da Casa Branca est trabalhando alm da conta. O que eles 
esto procurando  um heri. O que eles encontram  um escndalo. O que um 
oficial encrencado agora precisa encobrir  a verdade.</p>', '', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('17', '4', 'Velocidade Mxima', 'Ttulo Original: &quot;Speed&quot; <br>
<br>
Cdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>
Idioma: Ingls, Alemo. <br>
Legendas: Ingls, Alemo, Espanhol. <br>
Audio: Dolby Surround 5.1. <br>
Formato da Tela: 16:9 Wide-Screen. <br>
Durao: (aprox) 112 minutes. <br>
Outros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>
<br>
Sinopse: Prepare-se para uma sequncia de emoes vibrantes, cenas de ao de 
tirar o flego e um romance inesperado, num filme que voc vai querer ver muitas 
vezes. Keanu Reeves  Jack Traven, um especialista da equipe SWAT da polcia de 
Los Angeles que  enviado para desarmar uma bomba colocada num nibus por um 
manaco vingativo (Dennis Hopper). Jack e a passageira Sandra Bullock tm que 
manter o nibus a mais de 80 km/h ou a bomba explodir. Uma perseguio cheia de 
suspense, ao e reviravoltas que vai deixar voc com os olhos grudados na tela.</p>', '', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('18', '4', 'Velocidade Mxima 2', 'Ttulo Original: &quot;Speed 2: Cruise Control&quot; <br>
<br>
Cdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>
Idioma: Ingls, Alemo. <br>
Legendas: Ingls, Alemo, Espanhol. <br>
Audio: Dolby Surround 5.1. <br>
Formato da Tela: 16:9 Wide-Screen. <br>
Durao: (aprox) 120 minutes. <br>
Outros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>
<br>
Sinopse:Agarre-se ao seu salva-vidas quando a super sequncia de Velocidade 
Mxima atingir o alto-mar. Sandra Bullock revive o papel que a transformou em 
estrela como Annie Porter, uma jovem mulher esperando divertir-se em frias no 
Caribe ao lado do seu namorado (Jason Patric) a bordo do transatlntico mais 
luxuoso do mundo. Mas sua viagem ao paraso torna-se mortal quando um luntico 
gnio de computadores (Willem Dafoe) assume o controle do navio e o coloca numa 
rota de destruio. Uma viagem explosiva conduzida pelo audacioso diretor Jan De 
Bont (Velocidade Mxima, Twister), VELOCIDADE MXIMA 2 navega nas ondas 
selvagens em velocidade alucinante.</p>', '', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('19', '4', 'Quem vai ficar com Mary?', 'Ttulo Original: &quot;There\'s Something About Mary&quot; <br>
<br>
Cdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>
Idioma: Ingls, Alemo. <br>
Legendas: Ingls, Alemo, Espanhol. <br>
Audio: Dolby Surround 5.1. <br>
Formato da Tela: 16:9 Wide-Screen. <br>
Durao: (aprox) 114 minutes. <br>
Outros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>
<br>
Sinopse: Uma comdia romntica com muitas gozaes sobre a maneira como os 
jovens se apaixonam e as dificuldades de lidar com o amor... <br>
Apaixonado desde os tempos do curso colegial por Mary (Cameron Diaz), o 
trapalho Ted (Ben Stiller) localiza de novo a gata de seus sonhos treza anos 
mais tarde com a ajuda de um investigador particular muito pilantra (Matt Dillon), 
que tambm se apaixona por ela. Para complicar ainda mais as coisas, os dois 
descobrem que qualquer homem que conhea a deslumbrante Mary fica doido para se 
casar com ela. Mais um grande xito da famosa dupla de diretores, os irmos 
Bobby e Peter Farrelly, que j fizeram grande sucesso com Dbi &amp; Lide.</p>', '', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('20', '4', 'Bem Amada', 'Ttulo Original: &quot;Beloved&quot; <br>
<br>
Cdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>
Idioma: Ingls, Alemo. <br>
Legendas: Ingls, Alemo, Espanhol. <br>
Audio: Dolby Surround 5.1. <br>
Formato da Tela: 16:9 Wide-Screen. <br>
Durao: (aprox) 164 minutes. <br>
Outros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>
<br>
Sinopse:<br>
Baseado em um romance da vencedora do prmio Nobel Toni Morrison, Bem Amada (Beloved) 
 um grande afresco histrico da Amrica do Norte escravagista no fim do sculo 
XIX. A popular apresentadora de TV Oprah Winfrey interpreta a protagonista, 
Sethe, uma ex-escrava que tenta levar uma vida normal ao lado da voluntariosa 
filha Denver (Kimberly Elise). Atormentada por segredos inconfessveis de seu 
passado, ela encontra no velho amigo Paul D (Danny Glover) um consolo para seu 
sofrimento interior. Thandie Newton encarna a personagem que d nome ao filme. 
Beloved  uma presena misteriosa, cuja influncia malfica ir desequilibrar a 
existncia de todos  sua volta.</p>', '', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('21', '4', 'SWAT 3: Close Quarters Battle', 'Los Angeles 2005. Representantes de todas as naes do mundo estaro reunidos 
para testemunhar a assinatura do Tratado de Desarmamento Nuclear das Naes 
Unidas. A proteo desses homens contra os ataques implacveis de foras 
terroristas caber  SWAT. O destino de muitas vidas est em suas mos.<br>
<br>
Destaques<br>
<br>
Teste sua coragem em 21 misses intensas - todas em locais reais de Los Angeles. 
A vida de pessoas inocentes e a captura dos terroristas dependem de voc e de 
sua equipe.<br>
<br>
Jogue no modo cooperativo ou de combate mortal contra at cinco jogadores, em 
rede ou via Internet. Personalize tudo, de armas e skins ao nmero e tipos de 
adversrios e refns.<br>
<br>
Coloque  prova sua imaginao. Crie novos nveis ou mude os que j existem. 
Recrie conflitos da vida real e rescreva a histria da cidade. Instale 
modificaes rapidamente usando o MOD Selector.', 'www.swat3.com', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('22', '4', 'Torneio irreal', 'Ttulo Original: &quot;Unreal Tournament&quot; <br>
<br>
O jogo Single player  emoo do comeo ao fim, que vai fazer voc cerrar os 
punhos enquanto os tiros vm de todos os lados! Comande sua equipe de 
guerrilheiros virtuais &quot;bots&quot; contra os mais mortais gladiadores virtuais da 
galxia e torne-se o Grande Mestre do Unreal. Ao Multiplayer de arrepiar a 
espinha. Seja ou no On-line. Arrase com todo mundo, bots ou humanos, em novos 
modos de jogo: Capturar bandeira, Ataque, Dominao e novas variaes de 
Combates Mortais que no requerem acesso  Internet.<br>
<br>
50 Nveis de batalha, verdadeiras obras de arte. Um galeo, tumbas egpcias, 
submarinos, trens de alta velocidade, castelos espaciais e muito mais ! Tudo 
isso pode ser jogado on-line ou no e nos modos para um ou vrios jogadores. 
Esses nveis elevam o padro dos ambientes de ao 3D<br>
<br>
Imagens e sons alm da realidade. Texturas super detalhadas criam mundos 
fantsticos. Suporta as placas 3D de ltima gerao, mas no exige placa 3D.<br>
<br>
Arsenal Detonante, totalmente novo e aperfeioado, uma garantia de que vai rolar 
muito sangue ! Mais de 10 armas - cada uma com dois modos de tiro - a sua 
disposio.<br>
<br>
Tome controle do jogo.Treine no modo novato e use os nveis tutoriais para 
arrasar em combate. Se voc quiser mais velocidade, mais dano, mais intensidade 
e mais tudo... tente o modo Hardcore.', 'www.unrealtournament.net', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('23', '4', 'A Roda do Tempo', 'Ttulo Original: &quot;The Wheel Of Time&quot; <br>
<br>
Das pginas dos best-sellers de Robert Jordan para as telas dos PCs, The Wheel 
of Time conta a histria da busca dos quatro selos mgicos utilizados para 
aprisionar &quot;O Obscuro&quot;, uma entidade das trevas com poder suficiente para 
destruir o mundo. <br>
<br>
Para recuperar esses selos, voc dever se envolver em uma trama de intrigas e 
traies no papel de Elayna Sedai, Guardi das Crnicas da Torre Branca. Em The 
Wheel of Time, voc percorrer 18 nveis de jogo, unidos por belssimas cenas de 
animao que contam esta fascinante histria de aventura pica. A histria que 
se desenrola, pouco a pouco,  medida que ocorre a ao, tendo como objetivo 
recuperar os selos mgicos roubados da Torre Branca por foras malignas. <br>
<br>
Um Fantstico modo de jogo single palyer, que permite viajar por 15 mundos em 
uma jornada para encontrar os selos msticos, com a possibilidade de utilizar 
mais de 40 magias e artefatos de poder inimaginvel, como bolas de fogo, 
relmpagos, disfarces, levitao, etc. <br>
<br>
Visuais espetaculares criados por uma verso aprimorada do poderoso engine do 
Unreal. Chamas iluminam o cenrio e gotas de chuva caem, agitando poas de gua 
com realismo jamais visto. Ambientes belssimos e cenrios monumentais 
inspirados na arte gtica trazem inigualveis detalhes arquitetnicos, realados 
por incrveis efeitos especiais. <br>
&nbsp;', 'www.wheeloftime.com', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('24', '4', 'A Terra Sagrada', 'Ttulo original: &quot;Disciples: Sacred Lands&quot; <br>
<br>
Uma nova era esta nascendo...<br>
<br>
Entre no reino das terras sagradas, onde o nascer da nova era encontra-se nos 
maiores momentos da guerra. Como prev a profecia, quatro raas confrontam-se 
com espadas e feitiaria numa perigosa disputa pelo controle do destino dos seus 
Deuses. Enfrente a busca como o campeo do Imprio, cl das montanhas, legio 
dos malditos, ou multido dos mortos-vivos e teste sua f nas batalhas de fora, 
enfeitiando e atuando com malcia matando demnios, vencendo gigantes e 
combatendo sem misericrdia as foras dos mortos e dos mortos-vivos. Mas a 
segurana da salvao do seu Deus deve envolver o heri dentro de voc.<br>
&nbsp;', '', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('25', '4', 'Microsoft Internet Keyboard PS/2', '<p>Acesso  Internet com um toque e muito mais! O Internet Keyboard possui dez 
teclas de acesso em um design de teclado padro confortvel que tambm traz um 
descanso para mos destacvel. As teclas de acesso permitem navegar na Web ou 
verificar correio eletrnico diretamente de seu teclado. O software IntelliType 
Pro tambm permite personalizar suas teclas de acesso  trabalhe com o Internet 
Keyboard da maneira que preferir! <br>
<br>
Benefcios <br>
Dez teclas de acesso permitem que voc tenha maior controle sobre seu PC - 
Acesse a Internet, seu correio eletrnico e os programas favoritos diretamente 
de seu teclado. <br>
Alta qualidade, alto valor  O Microsoft Internet Keyboard  um teclado de alta 
qualidade, feito para durar e tem garantia de 3 anos pela PHPmania. <br>
Descanso para mos destacvel - O confortvel descanso para mos serve de apoio 
para os antebraos e pode ser removido para aumentar o espao na mesa. <br>
Execute tarefas comuns rapidamente como Recortar, Copiar e Colar com a ajuda dos 
atalhos da tecla Control.</p>', '', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('26', '4', 'Microsoft IntelliMouse Explorer', 'O primeiro avano realmente importante na tecnologia dos mouses desde a 
dcada de 60.<br>
O IntelliMouse com IntelliEye ultrapassou toda a antiga tecnologia mecnica 
usada nos mouses atuais. Este mouse usa um novo sensor ptico que rastreia a 
superfcie abaixo do mouse 1.500 vezes por segundo para registrar com preciso e 
regularidade os mnimos movimentos. Ele funciona em centenas de superfcies (ou 
seja, chega de mouse pad) e permanece \"preciso como novo\" porque no existem 
peas mveis que se desgastam ou retm sujeira. <br>
<br>
Benefcios<br>
<br>
Preciso - O sensor ptico preciso do IntelliEye registra os movimentos sobre 
qualquer tipo de superfcie. O sensor precisa apenas de uma superfcie com um 
pequeno volume de detalhes, o que inclui madeira, plstico ou at o tecido de 
sua cala. <br>
Navegao mais fcil na Internet - Os dois botes do polegar atuam com botes de 
avanar e voltar no seu navegador. <br>
Preciso - Nada de partes mveis, e portanto seu mouse est sempre suave e 
preciso, no sendo necessrio usar um mouse pad. <br>
Acomoda-se muito bem  sua mo - Este mouse foi desenvolvido para dar apoio  
sua mo e seus dedos. As laterais emborrachadas facilitam prender o mouse entre 
os dedos e o deixam mais confortvel de usar, pois ele exige menos esforo para 
segurar. <br>
Garantia - O IntelliMouse Explorer vem com garantia limitada de hardware de 5 
anos pela PHPmania.org.</p>', 'www.microsoft.com/hardware/mouse/explorer.asp', '0');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed) values ('27', '4', 'Hewlett Packard LaserJet 1100Xi', 'A PHPmania est sempre na frente na tecnologia de impresso a laser. A nova 
gerao HP LaserJet 1100, marca outra srie impressionante no ritmo de impresso 
e velocidade, sendo de 8 pginas por minuto. Imprimir em uma resoluo de 600 
dpi, com tecnologia de resoluo avanada (Resolution Enhancement technology - 
REt) HP faz todos os documentos mais profissionais, aumentando a velocidade de 
impresso e a qualidade a laser, resultam apenas no comeo com 2MB de memria.<br>
<br>
Usurios da HP LaserJet 1100xi sero capazes de imprimir pginas cada vez mais 
complexas, a memria  expansvel para at 18MB, facilitando a impresso de 
documentos mais complexos. A HP LaserJet 1100xi suporta as plataformas Windows 
3.1, 3.11, 95, 98, ME, XP. Compatibilidade de rede atravs do HP JetDirect 
External Print Servers.<br>
<br>
HP LaserJet 1100xi tambm pode criar documentos para a Web Era da Trellix Corp. 
(Oferencendo um software que  capaz de criar documentos web).</p>', 'www.pandi.hp.com/pandi-db/prodinfo.main?product=laserjet1100', '0');
drop table if exists products_notifications;
create table products_notifications (
  products_id int(11) default '0' not null ,
  customers_id int(11) default '0' not null ,
  date_added datetime default '0000-00-00 00:00:00' not null ,
  PRIMARY KEY (products_id, customers_id)
);

insert into products_notifications (products_id, customers_id, date_added) values ('0', '3', '2004-10-03 19:00:49');
insert into products_notifications (products_id, customers_id, date_added) values ('2', '3', '2004-10-03 20:31:28');
drop table if exists products_options;
create table products_options (
  products_options_id int(11) default '0' not null ,
  language_id int(11) default '1' not null ,
  products_options_name varchar(32) not null ,
  PRIMARY KEY (products_options_id, language_id)
);

insert into products_options (products_options_id, language_id, products_options_name) values ('1', '4', 'Cor');
insert into products_options (products_options_id, language_id, products_options_name) values ('2', '4', 'Size');
insert into products_options (products_options_id, language_id, products_options_name) values ('3', '4', 'Modelo');
insert into products_options (products_options_id, language_id, products_options_name) values ('4', '4', 'Memoria');
insert into products_options (products_options_id, language_id, products_options_name) values ('5', '4', 'Verso');
drop table if exists products_options_values;
create table products_options_values (
  products_options_values_id int(11) default '0' not null ,
  language_id int(11) default '1' not null ,
  products_options_values_name varchar(64) not null ,
  PRIMARY KEY (products_options_values_id, language_id)
);

insert into products_options_values (products_options_values_id, language_id, products_options_values_name) values ('1', '4', '4 mb');
insert into products_options_values (products_options_values_id, language_id, products_options_values_name) values ('2', '4', '8 mb');
insert into products_options_values (products_options_values_id, language_id, products_options_values_name) values ('3', '4', '16 mb');
insert into products_options_values (products_options_values_id, language_id, products_options_values_name) values ('4', '4', '32 mb');
insert into products_options_values (products_options_values_id, language_id, products_options_values_name) values ('5', '4', 'Value');
insert into products_options_values (products_options_values_id, language_id, products_options_values_name) values ('6', '4', 'Premium');
insert into products_options_values (products_options_values_id, language_id, products_options_values_name) values ('7', '4', 'Deluxe');
insert into products_options_values (products_options_values_id, language_id, products_options_values_name) values ('8', '4', 'PS/2');
insert into products_options_values (products_options_values_id, language_id, products_options_values_name) values ('9', '4', 'USB');
insert into products_options_values (products_options_values_id, language_id, products_options_values_name) values ('10', '4', 'Download: Windows - English');
insert into products_options_values (products_options_values_id, language_id, products_options_values_name) values ('13', '4', 'Box: Windows - English');
drop table if exists products_options_values_to_products_options;
create table products_options_values_to_products_options (
  products_options_values_to_products_options_id int(11) not null auto_increment,
  products_options_id int(11) default '0' not null ,
  products_options_values_id int(11) default '0' not null ,
  PRIMARY KEY (products_options_values_to_products_options_id)
);

insert into products_options_values_to_products_options (products_options_values_to_products_options_id, products_options_id, products_options_values_id) values ('1', '4', '1');
insert into products_options_values_to_products_options (products_options_values_to_products_options_id, products_options_id, products_options_values_id) values ('2', '4', '2');
insert into products_options_values_to_products_options (products_options_values_to_products_options_id, products_options_id, products_options_values_id) values ('3', '4', '3');
insert into products_options_values_to_products_options (products_options_values_to_products_options_id, products_options_id, products_options_values_id) values ('4', '4', '4');
insert into products_options_values_to_products_options (products_options_values_to_products_options_id, products_options_id, products_options_values_id) values ('5', '3', '5');
insert into products_options_values_to_products_options (products_options_values_to_products_options_id, products_options_id, products_options_values_id) values ('6', '3', '6');
insert into products_options_values_to_products_options (products_options_values_to_products_options_id, products_options_id, products_options_values_id) values ('7', '3', '7');
insert into products_options_values_to_products_options (products_options_values_to_products_options_id, products_options_id, products_options_values_id) values ('8', '3', '8');
insert into products_options_values_to_products_options (products_options_values_to_products_options_id, products_options_id, products_options_values_id) values ('9', '3', '9');
insert into products_options_values_to_products_options (products_options_values_to_products_options_id, products_options_id, products_options_values_id) values ('10', '5', '10');
insert into products_options_values_to_products_options (products_options_values_to_products_options_id, products_options_id, products_options_values_id) values ('13', '5', '13');
drop table if exists products_to_categories;
create table products_to_categories (
  products_id int(11) default '0' not null ,
  categories_id int(11) default '0' not null ,
  PRIMARY KEY (products_id, categories_id)
);

insert into products_to_categories (products_id, categories_id) values ('1', '4');
insert into products_to_categories (products_id, categories_id) values ('2', '4');
insert into products_to_categories (products_id, categories_id) values ('3', '9');
insert into products_to_categories (products_id, categories_id) values ('4', '10');
insert into products_to_categories (products_id, categories_id) values ('5', '11');
insert into products_to_categories (products_id, categories_id) values ('6', '10');
insert into products_to_categories (products_id, categories_id) values ('7', '12');
insert into products_to_categories (products_id, categories_id) values ('8', '13');
insert into products_to_categories (products_id, categories_id) values ('9', '10');
insert into products_to_categories (products_id, categories_id) values ('10', '10');
insert into products_to_categories (products_id, categories_id) values ('11', '10');
insert into products_to_categories (products_id, categories_id) values ('12', '10');
insert into products_to_categories (products_id, categories_id) values ('13', '10');
insert into products_to_categories (products_id, categories_id) values ('14', '15');
insert into products_to_categories (products_id, categories_id) values ('16', '15');
insert into products_to_categories (products_id, categories_id) values ('17', '10');
insert into products_to_categories (products_id, categories_id) values ('18', '10');
insert into products_to_categories (products_id, categories_id) values ('19', '12');
insert into products_to_categories (products_id, categories_id) values ('20', '15');
insert into products_to_categories (products_id, categories_id) values ('21', '18');
insert into products_to_categories (products_id, categories_id) values ('22', '19');
insert into products_to_categories (products_id, categories_id) values ('23', '20');
insert into products_to_categories (products_id, categories_id) values ('24', '20');
insert into products_to_categories (products_id, categories_id) values ('25', '8');
insert into products_to_categories (products_id, categories_id) values ('26', '9');
insert into products_to_categories (products_id, categories_id) values ('27', '5');
drop table if exists reviews;
create table reviews (
  reviews_id int(11) not null auto_increment,
  products_id int(11) default '0' not null ,
  customers_id int(11) ,
  customers_name varchar(64) not null ,
  reviews_rating int(1) ,
  date_added datetime ,
  last_modified datetime ,
  reviews_read int(5) default '0' not null ,
  PRIMARY KEY (reviews_id)
);

drop table if exists reviews_description;
create table reviews_description (
  reviews_id int(11) default '0' not null ,
  languages_id int(11) default '0' not null ,
  reviews_text text not null ,
  PRIMARY KEY (reviews_id, languages_id)
);

drop table if exists sessions;
create table sessions (
  sesskey varchar(32) not null ,
  expiry int(11) unsigned default '0' not null ,
  value text not null ,
  PRIMARY KEY (sesskey)
);

insert into sessions (sesskey, expiry, value) values ('2d6d2c9a673c4f7cd259d0da5834c561', '1098840383', 'language|s:9:\"portugues\";languages_id|s:1:\"4\";selected_box|s:5:\"tools\";current_path|s:32:\"/home/phpmania/public_html/loja/\";');
insert into sessions (sesskey, expiry, value) values ('fd71cc2765e92aaeef0b028575ed4512', '1098840403', 'cart|O:12:\"shoppingcart\":5:{s:8:\"contents\";a:1:{i:5;a:1:{s:3:\"qty\";i:1;}}s:5:\"total\";d:30;s:6:\"weight\";d:1;s:6:\"cartID\";s:5:\"90694\";s:12:\"content_type\";s:8:\"physical\";}language|s:9:\"portugues\";languages_id|s:1:\"4\";currency|s:2:\"BR\";navigation|O:17:\"navigationhistory\":2:{s:4:\"path\";a:8:{i:0;a:4:{s:4:\"page\";s:9:\"index.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}i:1;a:4:{s:4:\"page\";s:18:\"create_account.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:18:{s:6:\"action\";s:7:\"process\";s:6:\"gender\";s:1:\"m\";s:9:\"firstname\";s:4:\"beto\";s:8:\"lastname\";s:3:\"bbs\";s:3:\"dob\";s:10:\"21/06/1975\";s:13:\"email_address\";s:17:\"phpmania@mail.com\";s:14:\"street_address\";s:23:\"sqs 310 bloco a casa 20\";s:6:\"suburb\";s:7:\"asa sul\";s:8:\"postcode\";s:8:\"70866160\";s:4:\"city\";s:14:\"belo horizonte\";s:5:\"state\";s:12:\"Minas Gerais\";s:7:\"country\";s:2:\"30\";s:9:\"telephone\";s:5:\"12345\";s:3:\"fax\";s:5:\"12345\";s:8:\"password\";s:5:\"12345\";s:12:\"confirmation\";s:5:\"12345\";s:1:\"x\";s:2:\"66\";s:1:\"y\";s:2:\"13\";}}i:2;a:4:{s:4:\"page\";s:26:\"create_account_success.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}i:3;a:4:{s:4:\"page\";s:16:\"product_info.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:2:{s:11:\"products_id\";s:1:\"5\";s:6:\"action\";s:11:\"add_product\";}s:4:\"post\";a:3:{s:11:\"products_id\";s:1:\"5\";s:1:\"x\";s:2:\"72\";s:1:\"y\";s:1:\"7\";}}i:4;a:4:{s:4:\"page\";s:17:\"shopping_cart.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}i:5;a:4:{s:4:\"page\";s:21:\"checkout_shipping.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:5:{s:6:\"action\";s:7:\"process\";s:8:\"shipping\";s:15:\"regions_regions\";s:8:\"comments\";s:0:\"\";s:1:\"x\";s:2:\"48\";s:1:\"y\";s:2:\"13\";}}i:6;a:4:{s:4:\"page\";s:20:\"checkout_payment.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}i:7;a:4:{s:4:\"page\";s:25:\"checkout_confirmation.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:4:{s:7:\"payment\";s:13:\"transferencia\";s:8:\"comments\";s:0:\"\";s:1:\"x\";s:2:\"79\";s:1:\"y\";s:1:\"6\";}}}s:8:\"snapshot\";a:0:{}}customer_id|i:7;customer_first_name|s:4:\"beto\";customer_default_address_id|i:7;customer_country_id|s:2:\"30\";customer_zone_id|s:2:\"74\";sendto|i:7;cartID|s:5:\"90694\";comments|s:0:\"\";shipping|a:3:{s:2:\"id\";s:15:\"regions_regions\";s:5:\"title\";s:87:\"Entrega Via Sedex (Prazo de entrega dos Correios  de 2 dias teis para Minas Gerais  )\";s:4:\"cost\";d:14;}billto|i:7;payment|s:13:\"transferencia\";');
insert into sessions (sesskey, expiry, value) values ('359830acd142a2f0da9df62ec7a6c797', '1152813128', 'language|s:9:\"portugues\";languages_id|s:1:\"4\";selected_box|s:5:\"tools\";');
insert into sessions (sesskey, expiry, value) values ('9aae3c3b7bdfd3b3f65e2eb59a62fbe3', '1152813073', 'cart|O:12:\"shoppingcart\":5:{s:8:\"contents\";a:0:{}s:5:\"total\";i:0;s:6:\"weight\";i:0;s:6:\"cartID\";N;s:12:\"content_type\";b:0;}language|s:9:\"portugues\";languages_id|s:1:\"4\";currency|s:2:\"BR\";navigation|O:17:\"navigationhistory\":2:{s:4:\"path\";a:1:{i:0;a:4:{s:4:\"page\";s:9:\"index.php\";s:4:\"mode\";s:6:\"NONSSL\";s:3:\"get\";a:0:{}s:4:\"post\";a:0:{}}}s:8:\"snapshot\";a:0:{}}');
drop table if exists specials;
create table specials (
  specials_id int(11) not null auto_increment,
  products_id int(11) default '0' not null ,
  specials_new_products_price decimal(15,4) default '0.0000' not null ,
  specials_date_added datetime ,
  specials_last_modified datetime ,
  expires_date datetime ,
  date_status_change datetime ,
  status int(1) default '1' not null ,
  PRIMARY KEY (specials_id)
);

insert into specials (specials_id, products_id, specials_new_products_price, specials_date_added, specials_last_modified, expires_date, date_status_change, status) values ('1', '3', '39.9900', '2004-10-03 10:13:34', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1');
insert into specials (specials_id, products_id, specials_new_products_price, specials_date_added, specials_last_modified, expires_date, date_status_change, status) values ('2', '5', '30.0000', '2004-10-03 10:13:34', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1');
insert into specials (specials_id, products_id, specials_new_products_price, specials_date_added, specials_last_modified, expires_date, date_status_change, status) values ('3', '6', '30.0000', '2004-10-03 10:13:34', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1');
insert into specials (specials_id, products_id, specials_new_products_price, specials_date_added, specials_last_modified, expires_date, date_status_change, status) values ('4', '16', '29.9900', '2004-10-03 10:13:34', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1');
drop table if exists tax_class;
create table tax_class (
  tax_class_id int(11) not null auto_increment,
  tax_class_title varchar(32) not null ,
  tax_class_description varchar(255) not null ,
  last_modified datetime ,
  date_added datetime default '0000-00-00 00:00:00' not null ,
  PRIMARY KEY (tax_class_id)
);

insert into tax_class (tax_class_id, tax_class_title, tax_class_description, last_modified, date_added) values ('1', 'Taxable Goods', 'The following types of products are included non-food, services, etc', '2004-10-03 10:13:34', '2004-10-03 10:13:34');
drop table if exists tax_rates;
create table tax_rates (
  tax_rates_id int(11) not null auto_increment,
  tax_zone_id int(11) default '0' not null ,
  tax_class_id int(11) default '0' not null ,
  tax_priority int(5) default '1' ,
  tax_rate decimal(7,4) default '0.0000' not null ,
  tax_description varchar(255) not null ,
  last_modified datetime ,
  date_added datetime default '0000-00-00 00:00:00' not null ,
  PRIMARY KEY (tax_rates_id)
);

insert into tax_rates (tax_rates_id, tax_zone_id, tax_class_id, tax_priority, tax_rate, tax_description, last_modified, date_added) values ('1', '0', '1', '0', '0.0000', '', '2004-10-25 19:18:49', '2004-10-03 10:13:34');
drop table if exists whos_online;
create table whos_online (
  customer_id int(11) ,
  full_name varchar(64) not null ,
  session_id varchar(128) not null ,
  ip_address varchar(15) not null ,
  time_entry varchar(14) not null ,
  time_last_click varchar(14) not null ,
  last_page_url varchar(64) not null 
);

insert into whos_online (customer_id, full_name, session_id, ip_address, time_entry, time_last_click, last_page_url) values ('0', 'Guest', '9aae3c3b7bdfd3b3f65e2eb59a62fbe3', '201.11.14.209', '1152811501', '1152811626', '/loja/');
drop table if exists zones;
create table zones (
  zone_id int(11) not null auto_increment,
  zone_country_id int(11) default '0' not null ,
  zone_code varchar(32) not null ,
  zone_name varchar(32) not null ,
  PRIMARY KEY (zone_id)
);

insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('62', '30', 'AC', 'Acre');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('63', '30', 'AL', 'Alagoas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('64', '30', 'AP', 'Amapa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('65', '30', 'AM', 'Amazonas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('66', '30', 'BA', 'Bahia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('67', '30', 'CE', 'Ceara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('68', '30', 'DF', 'Distrito Federal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('69', '30', 'ES', 'Espirito Santo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('70', '30', 'GO', 'Goias');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('71', '30', 'MA', 'Maranhao');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('72', '30', 'MT', 'Mato Grosso');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('73', '30', 'MS', 'Mato Grosso do Sul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('74', '30', 'MG', 'Minas Gerais');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('75', '30', 'PA', 'Para');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('76', '30', 'PB', 'Paraiba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('77', '30', 'PR', 'Parana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('78', '30', 'PE', 'Pernambuco');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('79', '30', 'PI', 'Piaui');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('80', '30', 'RJ', 'Rio de Janeiro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('81', '30', 'RN', 'Rio Grande do Norte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('82', '30', 'RS', 'Rio Grande do Sul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('83', '30', 'RO', 'Rondonia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('84', '30', 'RR', 'Roraima');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('85', '30', 'SC', 'Santa Catarina');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('86', '30', 'SP', 'Sao Paulo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('87', '30', 'SE', 'Sergipe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('88', '30', 'TO', 'Tocantins');
drop table if exists zones_to_geo_zones;
create table zones_to_geo_zones (
  association_id int(11) not null auto_increment,
  zone_country_id int(11) default '0' not null ,
  zone_id int(11) ,
  geo_zone_id int(11) ,
  last_modified datetime ,
  date_added datetime default '0000-00-00 00:00:00' not null ,
  PRIMARY KEY (association_id)
);

