<?php

function saudacao()
{
	$hora = date("H");

	if ($hora>=6 && $hora<12)
		$s = "Bom dia";
	elseif($hora>=12 && $hora<18)
			$s = "Boa tarde";
		else
			$s = "Boa noite";

	return $s;
}

function dataComum($dataSQL, $formato = "d/m/Y")
{
	if (!strlen($dataSQL))
		return "";
	
	$aux = explode("-", $dataSQL);
	return date($formato, mktime(0, 0, 0,$aux[1], $aux[2], $aux[0]));
}

function dataSQL($dataComum)
{
	if (!strlen($dataComum))
		return "";

	$aux = explode("/", $dataComum);
	return $aux[2]."-".$aux[1]."-".$aux[0];
}


function numberToTipo($n)
{
	switch($n)
	{
		case 1: return "evento";
		case 2: return "notcia";
		case 3: return "comunicado";
		default: return "";
	}
}

function trataNomeArquivo($nome)
{
	return strtr($nome, 
		" Ǵ~`",
		"aaaaeeiooouuc_AAAAEEIOOOUUC___oo_321a_");
}


/**
'-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#
' Kit de Integrao Visanet VBV
' Verso: 3.0
' Arquivo: GeraTID.php
' Funo: Contm a funo para gerar o cdigo de identificao (TID) das transaes
'-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#
**/
function GerarTid ($shopid,$pagamento) {

    if(strlen($shopid) != 10) {
        echo "Tamanho do shopid deve ser 10 dgitos";
        exit;
	}
	
	if(is_numeric($shopid) != 1) {
        echo "Shopid deve ser numrico";
        exit;
	}

    if(strlen($pagamento) != 4) {
        echo "Tamanho do cdigo de pagamento deve ser 4 dgitos.";
        exit;
	}

    //Nmero da Maquineta
    $shopid_formatado = substr($shopid, 4, 5);

    //Hora Minuto Segundo e Dcimo de Segundo
    $hhmmssd = date("His").substr(sprintf("%0.1f",microtime()),-1);

    //Obter Data Juliana
    $datajuliana = sprintf("%03d",(date("z")+1));

	//ltimo dgito do ano
    $dig_ano = substr(date("y"), 1, 1);


    return $shopid_formatado.$dig_ano.$datajuliana.$hhmmssd.$pagamento;
  }

  function trataNome($nome)
	{
		return strtr($nome, 
			"Ǵ~`",
		"aaaaeeiooouucAAAAEEIOOOUUC___oo_321a_");
	}

	
function getImageNewSize($pathImagem, $maxWidth, $maxHeight, $cortaNoMeio)
  {
		$imgt=getimagesize($pathImagem);

		$imgtam=explode(" ",$imgt["3"]);
		$width=explode("\"",$imgtam[0]);
		$width=$width[1];
		$height=explode("\"",$imgtam[1]);
		$height=$height[1];

		if($height>=$width)
		{
			if(!$cortaNoMeio)
			{
				$razao = $height/$maxHeight;
				$heightN = $maxHeight;
				$widthN = $width/$razao;
			}
			else
			{
				$razao = $width/$maxWidth;
				$widthN = $maxWidth;
				$heightN = $height/$razao;	
			}
		}
		else
		{
			$razao = $width/$maxWidth;
			$widthN = $maxWidth;
			$heightN = $height/$razao;
		}
		
		if($heightN > $maxHeight)
		{
			$razao = $heightN/$maxHeight;
			$heightN = $maxHeight;
			$widthN = $widthN/$razao;
		}
		elseif($widthN > $maxWidth)
		{
			$razao = $widthN/$maxWidth;
			$widthN = $maxWidth;
			$heightN = $heightN/$razao;
		}
		
		$retorno[0]=ceil($widthN);
		$retorno[1]=ceil($heightN);
		return $retorno;
  }
	
  function cortaImagemNoMeio($file,$max_width,$max_height,$destino, $resizeProporcao=0) {
  	$source_pic = $file;
    list($width, $height, $image_type) = getimagesize($file);

    switch ($image_type)
    {
        case 1: $src = imagecreatefromgif($file); break;
        case 2: $src = imagecreatefromjpeg($file);  break;
        case 3: $src = imagecreatefrompng($file); break;
        default: return '';  break;
    }
			$tn_height = $max_height;
			$tn_width = $max_width;
    $tmp = imagecreatetruecolor($tn_width,$tn_height);
    if(($image_type == 1) OR ($image_type==3))
    {
        imagealphablending($tmp, false);
        imagesavealpha($tmp,true);
        $transparent = imagecolorallocatealpha($tmp, 255, 255, 255, 127);
        imagefilledrectangle($tmp, 0, 0, $tn_width, $tn_height, $transparent);
    }
    imagecopyresampled($tmp,$src,0,0,0,($height/2)-($tn_height/2),$width, $height,$width,$height);
    ob_start();
    switch ($image_type)
    {
        case 1: imagegif($tmp); break;
        case 2: imagejpeg($tmp, NULL, 100);  break; // best quality
        case 3: imagepng($tmp, NULL, 0); break; // no compression
        default: echo ''; break;
    }
    $final_image = ob_get_contents();
    ob_end_clean();
	$fp=fopen($destino,"wb+");
	if($fp)
	{
		fwrite($fp,$final_image);
		fclose($fp);
		return true;
	}
	else
	{
		return false;
	}
  }
  
  function criaImagemPequena($file,$max_width,$max_height,$destino, $resizeProporcao=0, $cortaNoMeio=0) {
    $source_pic = $file;
    list($width, $height, $image_type) = getimagesize($file);
    switch ($image_type)
    {
        case 1: $src = imagecreatefromgif($file); break;
        case 2: $src = imagecreatefromjpeg($file);  break;
        case 3: $src = imagecreatefrompng($file); break;
        default: return '';  break;
    }
    if($resizeProporcao)
    {
    	$imgt = getImageNewSize($file, $max_width, $max_height, $cortaNoMeio);
    	$tn_width=$imgt[0];
		$tn_height=$imgt[1];
    }
    else
    {
		$tn_width=$max_width;
		$tn_height=$max_height;
    }
    $tmp = imagecreatetruecolor($tn_width,$tn_height);
    if(($image_type == 1) OR ($image_type==3))
    {
        imagealphablending($tmp, false);
        imagesavealpha($tmp,true);
        $transparent = imagecolorallocatealpha($tmp, 255, 255, 255, 127);
        imagefilledrectangle($tmp, 0, 0, $tn_width, $tn_height, $transparent);
    }
    imagecopyresampled($tmp,$src,0,0,0,0,$tn_width, $tn_height,$width,$height);
    ob_start();
    switch ($image_type)
    {
        case 1: imagegif($tmp); break;
        case 2: imagejpeg($tmp, NULL, 100);  break; // best quality
        case 3: imagepng($tmp, NULL, 0); break; // no compression
        default: echo ''; break;
    }
    $final_image = ob_get_contents();
    ob_end_clean();
	$fp=fopen($destino,"wb+");
	if($fp)
	{
		fwrite($fp,$final_image);
		fclose($fp);
		if((($height>$width)||($height>$max_height)) && $cortaNoMeio)
		{
			cortaImagemNoMeio($file, $max_width, $max_height, $destino, 1);
		}
		return true;
	}
	else
	{
		return false;
	}
  }

?>
