<?php

/*

  $Id: regions.php, v 1.0 2002/12/15 14:29:56 Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com
  Copyright (c) 2002 osCommerce
  Released under the GNU General Public License

  The Exchange Project - Community Made Shopping!
  http://www.theexchangeproject.org

  http://www.phpmania.org
  PHPmania.org -  2004.Todos os direitos reservados.

*/

  class regions {
    var $code, $title, $description, $enabled, $regions;

// class constructor
    function regions() {
      $this->code = 'regions';
      $this->title = MODULE_SHIPPING_REGIONS_TEXT_TITLE;
      $this->description = MODULE_SHIPPING_REGIONS_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_SHIPPING_REGIONS_SORT_ORDER;
      $this->icon = '';
       $this->enabled = ((MODULE_SHIPPING_REGIONS_STATUS == 'True') ? true : false);
      // CUSTOMIZE THIS SETTING FOR THE NUMBER OF REGIONS NEEDED
      $this->regions = 9;
    }

// class methods
    function quote($method = '') {
      global $order, $shipping_weight, $cart, $total_count;
      
      if (MODULE_SHIPPING_REGIONS_MODE == 'Preo') {
        $order_total_price = $cart->show_total();
      } 
      if (MODULE_SHIPPING_REGIONS_MODE == 'Peso') {
        $order_total_price = $shipping_weight;
      }
      if (MODULE_SHIPPING_REGIONS_MODE == 'Por_item') {
        $order_total_price = $total_count;
      }      

      $dest_state = $order->delivery['state'];
      $dest_country = $order->delivery['country']['title'];
      
      $dest_region = 0;
      $error = false;

      for ($i=1; $i<=$this->regions; $i++) {
        $regions_table = constant('MODULE_SHIPPING_REGIONS' . $i);
        $country_states_or_countries = split("[,]", $regions_table);
        if (in_array($dest_state, $country_states_or_countries)) {
          $dest_region = $i;
          break;
        }
      }
      if ($dest_region == 0) {
              for ($i=1; $i<=$this->regions; $i++) {
                $regions_table = constant('MODULE_SHIPPING_REGIONS' . $i);
                $country_states_or_countries = split("[,]", $regions_table);
                if (in_array($dest_country, $country_states_or_countries)) {
                  $dest_region = $i;
                  break;
                }
              }
      }

      if ($dest_region == 0) {
        $error = true;
      } else {
        $shipping = -1;
        $region_cost = constant('MODULE_SHIPPING_REGIONS_COST' . $i);

        $regions_table = split("[:,]" , $region_cost);

        if ((MODULE_SHIPPING_REGIONS_MODE == 'Preo') || (MODULE_SHIPPING_REGIONS_MODE == 'Peso')) {
                for ($i=0; $i<sizeof($regions_table); $i+=2) {
                  if ($order_total_price <= $regions_table[$i]) {
                    $shipping = $regions_table[$i+1];
                    $shipping_method = MODULE_SHIPPING_REGIONS_TEXT_WAY . ' ' . "$dest_state" . ' ' . MODULE_SHIPPING_REGIONS_TEXT_UNITS;
                    break;
                  }
                }
        }
        if (MODULE_SHIPPING_REGIONS_MODE == 'Por_item') {
                         $shipping = $regions_table[1] * $order_total_price;
                            $shipping_method = MODULE_SHIPPING_REGIONS_ITEM . ' ' . $total_count . ' ' . MODULE_SHIPPING_REGIONS_ITEMS . ' ' . "$dest_state" . ' ' . MODULE_SHIPPING_REGIONS_TEXT_UNITS;
           }        
        
        
        if ($shipping == -1) {
          $shipping_cost = 0;
          $shipping_method = MODULE_SHIPPING_REGIONS_UNDEFINED_RATE;
        } else {
          $shipping_cost = ($shipping + MODULE_SHIPPING_REGIONS_HANDLING + SHIPPING_HANDLING);
        }
      }

      $this->quotes = array('id' => $this->code,
                            'module' => MODULE_SHIPPING_REGIONS_TEXT_TITLE,
                            'methods' => array(array('id' => $this->code,
                                                     'title' => $shipping_method,
                                                     'cost' => $shipping_cost)));

      if (tep_not_null($this->icon)) $this->quotes['icon'] = tep_image($this->icon, $this->title);

      if ($error == true) $this->quotes['error'] = MODULE_SHIPPING_REGIONS_INVALID_ZONE;

      return $this->quotes;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_REGIONS_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Entrega Correios Sedex', 'MODULE_SHIPPING_REGIONS_STATUS', 'True', 'Ativar Entrega via sedex?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Taxa de manipulao', 'MODULE_SHIPPING_REGIONS_HANDLING', '0', 'Taxa de manipulao para este mtodo de transporte.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Modo', 'MODULE_SHIPPING_REGIONS_MODE', 'Peso', ' a tabela de transporte baseado em Peso total ou Quantia Total de pedidos.', '6', '0', 'tep_cfg_select_option(array(\'Peso\', \'Preo\', \'Por_item\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordem de exibio.', 'MODULE_SHIPPING_REGIONS_SORT_ORDER', '0', 'Determina a ordem de exibio do meio de envio.', '6', '0', now())");
      for ($i = 1; $i <= $this->regions; $i++) {
        $default_countries = '';
        if ($i == 1) {
          $default_states_or_countries = 'Parana,Rio de Janeiro';
          $default_prices = '1:15.00,2:15.00,3:15.00,4:15.00,5:15.00,15:15.00,25:15.00,45:15.00,65:15.00,85:15.00';
        }
        if ($i == 2) {
          $default_states_or_countries = 'Minas Gerais,Santa Catarina';
          $default_prices = '1:14.00,2:14.00,3:14.00,4:14.00,5:14.00,15:14.00,25:14.00,45:14.00,65:14.00,85:14.00';
        }
        if ($i == 3) {
          $default_states_or_countries = 'Distrito Federal,Espirito Santo,Mato Grosso do Sul,Rio Grande do Sul';
          $default_prices = '1:18.00,2:18.00,3:18.00,4:18.00,5:18.00,15:18.00,25:18.00,55:18.00,75:18.00,95:18.00';
        }
        if ($i == 4) {
          $default_states_or_countries = 'Bahia,Goias,Mato Grosso,Tocantins';
          $default_prices = '1:22.00,2:22.00,3:22.00,4:22.00,5:22.00,15:22.00,25:22.00,45:22.00,65:22.00,85:22.00';
        }
        if ($i == 5) {
          $default_states_or_countries = 'Alagoas,Sergipe';
          $default_prices = '1:24.00,2:24.00,3:24.00,4:24.00,5:24.00,15:24.00,25:24.00,45:24.00,65:24.00,75:24.00';
        }
        if ($i == 6) {
          $default_states_or_countries = 'Paraiba,Pernambuco,Piaui,Rondonia';
          $default_prices = '1:28.00,2:28.00,3:28.00,4:28.00,5:28.00,15:28.00,25:28.00,45:28.00,65:28.00,85:28.00';
        }
        if ($i == 7) {
          $default_states_or_countries = 'Acre,Amapa,Amazonas,Ceara,Maranhao,Parah,Rio Grande do Norte';
          $default_prices = '1:31.00,2:31.00,3:31.00,4:31.00,5:31.00,15:31.00,25:31.00,45:31.00,65:31.00';
        }
        if ($i == 8) {
          $default_states_or_countries = 'Roraima';
          $default_prices = '1:35.00,2:35.00,3:35.00,4:35.00,5:35.00,15:35.00,25:35.00,45:35.00,55:35.00,85:35.00';
        }
        if ($i == 9) {
          $default_states_or_countries = 'Sao Paulo';
          $default_prices = '1:9.00,2:9.00,3:9.00,4:9.00,5:9.00,15:9.00,25:9.00,35:9.00,55:9.00,85:9.00';
        }
        tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Regio " . $i ." Estados', 'MODULE_SHIPPING_REGIONS" . $i ."', '" . $default_states_or_countries . "', 'Separar por vrgula se tiver mais de um estado', '6', '0', now())");
        tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Regio " . $i ." Tarifas', 'MODULE_SHIPPING_REGIONS_COST" . $i ."', '" . $default_prices . "' , 'Exemplo: 1:5.00,2:5.50,3:6.00,... 1  o peso, 5.00  o valor', '6', '0', now())");
      }
    }

    function remove() {
      $keys = '';
      $keys_array = $this->keys();
      for ($i=0; $i<sizeof($keys_array); $i++) {
        $keys .= "'" . $keys_array[$i] . "',";
      }
      $keys = substr($keys, 0, -1);

      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in (" . $keys . ")");
    }

    function keys() {
      $keys = array('MODULE_SHIPPING_REGIONS_STATUS', 'MODULE_SHIPPING_REGIONS_HANDLING', 'MODULE_SHIPPING_REGIONS_MODE','MODULE_SHIPPING_REGIONS_SORT_ORDER');

      for ($i=1; $i<=$this->regions; $i++) {
        $keys[] = 'MODULE_SHIPPING_REGIONS' . $i;
        $keys[] = 'MODULE_SHIPPING_REGIONS_COST' . $i;
      }

      return $keys;
    }
  }
?>
