-- phpMyAdmin SQL Dump
-- version 2.6.0-pl2
-- http://www.phpmyadmin.net
-- 
-- Host: localhost
-- Generation Time: Oct 17, 2004 at 03:15 PM
-- Server version: 4.0.20
-- PHP Version: 4.3.9
-- 
-- Database: `eletroni_lojateste`
-- 

-- --------------------------------------------------------

DROP TABLE IF EXISTS address_book;
CREATE TABLE address_book (
address_book_id int NOT NULL auto_increment,
customers_id int NOT NULL,
entry_gender char(1) NOT NULL,
entry_company varchar(32),
entry_firstname varchar(32) NOT NULL,
entry_lastname varchar(32) NOT NULL,
entry_street_address varchar(64) NOT NULL,
entry_suburb varchar(32),
entry_postcode varchar(10) NOT NULL,
entry_city varchar(32) NOT NULL,
entry_state varchar(32),
entry_country_id int DEFAULT '0' NOT NULL,
entry_zone_id int DEFAULT '0' NOT NULL,
PRIMARY KEY (address_book_id),
KEY idx_address_book_customers_id (customers_id)
);

DROP TABLE IF EXISTS address_format;
CREATE TABLE address_format (
address_format_id int NOT NULL auto_increment,
address_format varchar(128) NOT NULL,
address_summary varchar(48) NOT NULL,
PRIMARY KEY (address_format_id)
);

DROP TABLE IF EXISTS banners;
CREATE TABLE banners (
banners_id int NOT NULL auto_increment,
banners_title varchar(64) NOT NULL,
banners_url varchar(255) NOT NULL,
banners_image varchar(64) NOT NULL,
banners_group varchar(10) NOT NULL,
banners_html_text text,
expires_impressions int(7) DEFAULT '0',
expires_date datetime DEFAULT NULL,
date_scheduled datetime DEFAULT NULL,
date_added datetime NOT NULL,
date_status_change datetime DEFAULT NULL,
status int(1) DEFAULT '1' NOT NULL,
PRIMARY KEY (banners_id)
);

DROP TABLE IF EXISTS banners_history;
CREATE TABLE banners_history (
banners_history_id int NOT NULL auto_increment,
banners_id int NOT NULL,
banners_shown int(5) NOT NULL DEFAULT '0',
banners_clicked int(5) NOT NULL DEFAULT '0',
banners_history_date datetime NOT NULL,
PRIMARY KEY (banners_history_id)
);

DROP TABLE IF EXISTS categories;
CREATE TABLE categories (
categories_id int NOT NULL auto_increment,
categories_image varchar(64),
parent_id int DEFAULT '0' NOT NULL,
sort_order int(3),
date_added datetime,
last_modified datetime,
PRIMARY KEY (categories_id),
KEY idx_categories_parent_id (parent_id)
);

DROP TABLE IF EXISTS categories_description;
CREATE TABLE categories_description (
categories_id int DEFAULT '0' NOT NULL,
language_id int DEFAULT '1' NOT NULL,
categories_name varchar(32) NOT NULL,
PRIMARY KEY (categories_id, language_id),
KEY idx_categories_name (categories_name)
);

DROP TABLE IF EXISTS configuration;
CREATE TABLE configuration (
configuration_id int NOT NULL auto_increment,
configuration_title varchar(64) NOT NULL,
configuration_key varchar(64) NOT NULL,
configuration_value varchar(255) NOT NULL,
configuration_description varchar(255) NOT NULL,
configuration_group_id int NOT NULL,
sort_order int(5) NULL,
last_modified datetime NULL,
date_added datetime NOT NULL,
use_function varchar(255) NULL,
set_function varchar(255) NULL,
PRIMARY KEY (configuration_id)
);

DROP TABLE IF EXISTS configuration_group;
CREATE TABLE configuration_group (
configuration_group_id int NOT NULL auto_increment,
configuration_group_title varchar(64) NOT NULL,
configuration_group_description varchar(255) NOT NULL,
sort_order int(5) NULL,
visible int(1) DEFAULT '1' NULL,
PRIMARY KEY (configuration_group_id)
);

DROP TABLE IF EXISTS counter;
CREATE TABLE counter (
startdate char(8),
counter int(12)
);

DROP TABLE IF EXISTS counter_history;
CREATE TABLE counter_history (
month char(8),
counter int(12)
);

DROP TABLE IF EXISTS countries;
CREATE TABLE countries (
countries_id int NOT NULL auto_increment,
countries_name varchar(64) NOT NULL,
countries_iso_code_2 char(2) NOT NULL,
countries_iso_code_3 char(3) NOT NULL,
address_format_id int NOT NULL,
PRIMARY KEY (countries_id),
KEY IDX_COUNTRIES_NAME (countries_name)
);

DROP TABLE IF EXISTS currencies;
CREATE TABLE currencies (
currencies_id int NOT NULL auto_increment,
title varchar(32) NOT NULL,
code char(3) NOT NULL,
symbol_left varchar(12),
symbol_right varchar(12),
decimal_point char(1),
thousands_point char(1),
decimal_places char(1),
value float(13,8),
last_updated datetime NULL,
PRIMARY KEY (currencies_id)
);

DROP TABLE IF EXISTS customers;
CREATE TABLE customers (
customers_id int NOT NULL auto_increment,
customers_gender char(1) NOT NULL,
customers_firstname varchar(32) NOT NULL,
customers_lastname varchar(32) NOT NULL,
customers_dob datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
customers_email_address varchar(96) NOT NULL,
customers_default_address_id int NOT NULL,
customers_telephone varchar(32) NOT NULL,
customers_fax varchar(32),
customers_password varchar(40) NOT NULL,
customers_newsletter char(1),
PRIMARY KEY (customers_id)
);

DROP TABLE IF EXISTS customers_basket;
CREATE TABLE customers_basket (
customers_basket_id int NOT NULL auto_increment,
customers_id int NOT NULL,
products_id tinytext NOT NULL,
customers_basket_quantity int(2) NOT NULL,
final_price decimal(15,4) NOT NULL,
customers_basket_date_added char(8),
PRIMARY KEY (customers_basket_id)
);

DROP TABLE IF EXISTS customers_basket_attributes;
CREATE TABLE customers_basket_attributes (
customers_basket_attributes_id int NOT NULL auto_increment,
customers_id int NOT NULL,
products_id tinytext NOT NULL,
products_options_id int NOT NULL,
products_options_value_id int NOT NULL,
PRIMARY KEY (customers_basket_attributes_id)
);

DROP TABLE IF EXISTS customers_info;
CREATE TABLE customers_info (
customers_info_id int NOT NULL,
customers_info_date_of_last_logon datetime,
customers_info_number_of_logons int(5),
customers_info_date_account_created datetime,
customers_info_date_account_last_modified datetime,
global_product_notifications int(1) DEFAULT '0',
PRIMARY KEY (customers_info_id)
);

DROP TABLE IF EXISTS languages;
CREATE TABLE languages (
languages_id int NOT NULL auto_increment,
name varchar(32) NOT NULL,
code char(2) NOT NULL,
image varchar(64),
directory varchar(32),
sort_order int(3),
PRIMARY KEY (languages_id),
KEY IDX_LANGUAGES_NAME (name)
);


DROP TABLE IF EXISTS manufacturers;
CREATE TABLE manufacturers (
manufacturers_id int NOT NULL auto_increment,
manufacturers_name varchar(32) NOT NULL,
manufacturers_image varchar(64),
date_added datetime NULL,
last_modified datetime NULL,
PRIMARY KEY (manufacturers_id),
KEY IDX_MANUFACTURERS_NAME (manufacturers_name)
);

DROP TABLE IF EXISTS manufacturers_info;
CREATE TABLE manufacturers_info (
manufacturers_id int NOT NULL,
languages_id int NOT NULL,
manufacturers_url varchar(255) NOT NULL,
url_clicked int(5) NOT NULL default '0',
date_last_click datetime NULL,
PRIMARY KEY (manufacturers_id, languages_id)
);

DROP TABLE IF EXISTS newsletters;
CREATE TABLE newsletters (
newsletters_id int NOT NULL auto_increment,
title varchar(255) NOT NULL,
content text NOT NULL,
module varchar(255) NOT NULL,
date_added datetime NOT NULL,
date_sent datetime,
status int(1),
locked int(1) DEFAULT '0',
PRIMARY KEY (newsletters_id)
);

DROP TABLE IF EXISTS orders;
CREATE TABLE orders (
orders_id int NOT NULL auto_increment,
customers_id int NOT NULL,
customers_name varchar(64) NOT NULL,
customers_company varchar(32),
customers_street_address varchar(64) NOT NULL,
customers_suburb varchar(32),
customers_city varchar(32) NOT NULL,
customers_postcode varchar(10) NOT NULL,
customers_state varchar(32),
customers_country varchar(32) NOT NULL,
customers_telephone varchar(32) NOT NULL,
customers_email_address varchar(96) NOT NULL,
customers_address_format_id int(5) NOT NULL,
delivery_name varchar(64) NOT NULL,
delivery_company varchar(32),
delivery_street_address varchar(64) NOT NULL,
delivery_suburb varchar(32),
delivery_city varchar(32) NOT NULL,
delivery_postcode varchar(10) NOT NULL,
delivery_state varchar(32),
delivery_country varchar(32) NOT NULL,
delivery_address_format_id int(5) NOT NULL,
billing_name varchar(64) NOT NULL,
billing_company varchar(32),
billing_street_address varchar(64) NOT NULL,
billing_suburb varchar(32),
billing_city varchar(32) NOT NULL,
billing_postcode varchar(10) NOT NULL,
billing_state varchar(32),
billing_country varchar(32) NOT NULL,
billing_address_format_id int(5) NOT NULL,
payment_method varchar(32) NOT NULL,
cc_type varchar(20),
cc_owner varchar(64),
cc_number varchar(32),
cc_expires varchar(4),
last_modified datetime,
date_purchased datetime,
orders_status int(5) NOT NULL,
orders_date_finished datetime,
currency char(3),
currency_value decimal(14,6),
PRIMARY KEY (orders_id)
);

DROP TABLE IF EXISTS orders_products;
CREATE TABLE orders_products (
orders_products_id int NOT NULL auto_increment,
orders_id int NOT NULL,
products_id int NOT NULL,
products_model varchar(12),
products_name varchar(64) NOT NULL,
products_price decimal(15,4) NOT NULL,
final_price decimal(15,4) NOT NULL,
products_tax decimal(7,4) NOT NULL,
products_quantity int(2) NOT NULL,
PRIMARY KEY (orders_products_id)
);

DROP TABLE IF EXISTS orders_status;
CREATE TABLE orders_status (
orders_status_id int DEFAULT '0' NOT NULL,
language_id int DEFAULT '1' NOT NULL,
orders_status_name varchar(32) NOT NULL,
PRIMARY KEY (orders_status_id, language_id),
KEY idx_orders_status_name (orders_status_name)
);

DROP TABLE IF EXISTS orders_status_history;
CREATE TABLE orders_status_history (
orders_status_history_id int NOT NULL auto_increment,
orders_id int NOT NULL,
orders_status_id int(5) NOT NULL,
date_added datetime NOT NULL,
customer_notified int(1) DEFAULT '0',
comments text,
PRIMARY KEY (orders_status_history_id)
);

DROP TABLE IF EXISTS orders_products_attributes;
CREATE TABLE orders_products_attributes (
orders_products_attributes_id int NOT NULL auto_increment,
orders_id int NOT NULL,
orders_products_id int NOT NULL,
products_options varchar(32) NOT NULL,
products_options_values varchar(32) NOT NULL,
options_values_price decimal(15,4) NOT NULL,
price_prefix char(1) NOT NULL,
PRIMARY KEY (orders_products_attributes_id)
);

DROP TABLE IF EXISTS orders_products_download;
CREATE TABLE orders_products_download (
orders_products_download_id int NOT NULL auto_increment,
orders_id int NOT NULL default '0',
orders_products_id int NOT NULL default '0',
orders_products_filename varchar(255) NOT NULL default '',
download_maxdays int(2) NOT NULL default '0',
download_count int(2) NOT NULL default '0',
PRIMARY KEY (orders_products_download_id)
);

DROP TABLE IF EXISTS orders_total;
CREATE TABLE orders_total (
orders_total_id int unsigned NOT NULL auto_increment,
orders_id int NOT NULL,
title varchar(255) NOT NULL,
text varchar(255) NOT NULL,
value decimal(15,4) NOT NULL,
class varchar(32) NOT NULL,
sort_order int NOT NULL,
PRIMARY KEY (orders_total_id),
KEY idx_orders_total_orders_id (orders_id)
);

DROP TABLE IF EXISTS products;
CREATE TABLE products (
products_id int NOT NULL auto_increment,
products_quantity int(4) NOT NULL,
products_model varchar(12),
products_image varchar(64),
products_price decimal(15,4) NOT NULL,
products_date_added datetime NOT NULL,
products_last_modified datetime,
products_date_available datetime,
products_weight decimal(5,2) NOT NULL,
products_status tinyint(1) NOT NULL,
products_tax_class_id int NOT NULL,
manufacturers_id int NULL,
products_ordered int NOT NULL default '0',
PRIMARY KEY (products_id),
KEY idx_products_date_added (products_date_added)
);

DROP TABLE IF EXISTS products_attributes;
CREATE TABLE products_attributes (
products_attributes_id int NOT NULL auto_increment,
products_id int NOT NULL,
options_id int NOT NULL,
options_values_id int NOT NULL,
options_values_price decimal(15,4) NOT NULL,
price_prefix char(1) NOT NULL,
PRIMARY KEY (products_attributes_id)
);

DROP TABLE IF EXISTS products_attributes_download;
CREATE TABLE products_attributes_download (
products_attributes_id int NOT NULL,
products_attributes_filename varchar(255) NOT NULL default '',
products_attributes_maxdays int(2) default '0',
products_attributes_maxcount int(2) default '0',
PRIMARY KEY (products_attributes_id)
);

DROP TABLE IF EXISTS products_description;
CREATE TABLE products_description (
products_id int NOT NULL auto_increment,
language_id int NOT NULL default '1',
products_name varchar(64) NOT NULL default '',
products_description text,
products_url varchar(255) default NULL,
products_viewed int(5) default '0',
PRIMARY KEY (products_id,language_id),
KEY products_name (products_name)
);

DROP TABLE IF EXISTS products_notifications;
CREATE TABLE products_notifications (
products_id int NOT NULL,
customers_id int NOT NULL,
date_added datetime NOT NULL,
PRIMARY KEY (products_id, customers_id)
);

DROP TABLE IF EXISTS products_options;
CREATE TABLE products_options (
products_options_id int NOT NULL default '0',
language_id int NOT NULL default '1',
products_options_name varchar(32) NOT NULL default '',
PRIMARY KEY (products_options_id,language_id)
);

DROP TABLE IF EXISTS products_options_values;
CREATE TABLE products_options_values (
products_options_values_id int NOT NULL default '0',
language_id int NOT NULL default '1',
products_options_values_name varchar(64) NOT NULL default '',
PRIMARY KEY (products_options_values_id,language_id)
);

DROP TABLE IF EXISTS products_options_values_to_products_options;
CREATE TABLE products_options_values_to_products_options (
products_options_values_to_products_options_id int NOT NULL auto_increment,
products_options_id int NOT NULL,
products_options_values_id int NOT NULL,
PRIMARY KEY (products_options_values_to_products_options_id)
);

DROP TABLE IF EXISTS products_to_categories;
CREATE TABLE products_to_categories (
products_id int NOT NULL,
categories_id int NOT NULL,
PRIMARY KEY (products_id,categories_id)
);

DROP TABLE IF EXISTS reviews;
CREATE TABLE reviews (
reviews_id int NOT NULL auto_increment,
products_id int NOT NULL,
customers_id int,
customers_name varchar(64) NOT NULL,
reviews_rating int(1),
date_added datetime,
last_modified datetime,
reviews_read int(5) NOT NULL default '0',
PRIMARY KEY (reviews_id)
);

DROP TABLE IF EXISTS reviews_description;
CREATE TABLE reviews_description (
reviews_id int NOT NULL,
languages_id int NOT NULL,
reviews_text text NOT NULL,
PRIMARY KEY (reviews_id, languages_id)
);

DROP TABLE IF EXISTS sessions;
CREATE TABLE sessions (
sesskey varchar(32) NOT NULL,
expiry int(11) unsigned NOT NULL,
value text NOT NULL,
PRIMARY KEY (sesskey)
);

DROP TABLE IF EXISTS specials;
CREATE TABLE specials (
specials_id int NOT NULL auto_increment,
products_id int NOT NULL,
specials_new_products_price decimal(15,4) NOT NULL,
specials_date_added datetime,
specials_last_modified datetime,
expires_date datetime,
date_status_change datetime,
status int(1) NOT NULL DEFAULT '1',
PRIMARY KEY (specials_id)
);

DROP TABLE IF EXISTS tax_class;
CREATE TABLE tax_class (
tax_class_id int NOT NULL auto_increment,
tax_class_title varchar(32) NOT NULL,
tax_class_description varchar(255) NOT NULL,
last_modified datetime NULL,
date_added datetime NOT NULL,
PRIMARY KEY (tax_class_id)
);

DROP TABLE IF EXISTS tax_rates;
CREATE TABLE tax_rates (
tax_rates_id int NOT NULL auto_increment,
tax_zone_id int NOT NULL,
tax_class_id int NOT NULL,
tax_priority int(5) DEFAULT 1,
tax_rate decimal(7,4) NOT NULL,
tax_description varchar(255) NOT NULL,
last_modified datetime NULL,
date_added datetime NOT NULL,
PRIMARY KEY (tax_rates_id)
);

DROP TABLE IF EXISTS geo_zones;
CREATE TABLE geo_zones (
geo_zone_id int NOT NULL auto_increment,
geo_zone_name varchar(32) NOT NULL,
geo_zone_description varchar(255) NOT NULL,
last_modified datetime NULL,
date_added datetime NOT NULL,
PRIMARY KEY (geo_zone_id)
);

DROP TABLE IF EXISTS whos_online;
CREATE TABLE whos_online (
customer_id int,
full_name varchar(64) NOT NULL,
session_id varchar(128) NOT NULL,
ip_address varchar(15) NOT NULL,
time_entry varchar(14) NOT NULL,
time_last_click varchar(14) NOT NULL,
last_page_url varchar(64) NOT NULL
);

DROP TABLE IF EXISTS zones;
CREATE TABLE zones (
zone_id int NOT NULL auto_increment,
zone_country_id int NOT NULL,
zone_code varchar(32) NOT NULL,
zone_name varchar(32) NOT NULL,
PRIMARY KEY (zone_id)
);

DROP TABLE IF EXISTS zones_to_geo_zones;
CREATE TABLE zones_to_geo_zones (
association_id int NOT NULL auto_increment,
zone_country_id int NOT NULL,
zone_id int NULL,
geo_zone_id int NULL,
last_modified datetime NULL,
date_added datetime NOT NULL,
PRIMARY KEY (association_id)
);


INSERT INTO address_format VALUES (1, '$firstname $lastname$cr$streets$cr$city, $postcode$cr$statecomma$country', '$city / $country');
INSERT INTO address_format VALUES (2, '$firstname $lastname$cr$streets$cr$city, $state $postcode$cr$country', '$city, $state / $country');
INSERT INTO address_format VALUES (3, '$firstname $lastname$cr$streets$cr$city$cr$postcode - $statecomma$country', '$state / $country');
INSERT INTO address_format VALUES (4, '$firstname $lastname$cr$streets$cr$city ($postcode)$cr$country', '$postcode / $country');
INSERT INTO address_format VALUES (5, '$firstname $lastname$cr$streets$cr$postcode $city$cr$country', '$city / $country');
INSERT INTO banners VALUES (2, 'PHPmania', 'http://www.phpmania.org', 'banners/oscommerce.gif', '468x50', '', 0, NULL, NULL, '2004-10-21 07:35:27', NULL, 1);
INSERT INTO categories VALUES (1, 'category_hardware.gif', 0, 1, '2004-10-03 10:13:34', '2004-10-03 10:21:05');
INSERT INTO categories VALUES (2, 'category_software.gif', 0, 2, '2004-10-03 10:13:34', NULL);
INSERT INTO categories VALUES (3, 'category_dvd_movies.gif', 0, 3, '2004-10-03 10:13:34', '2004-10-25 21:08:05');
INSERT INTO categories VALUES (4, 'subcategory_graphic_cards.gif', 1, 0, '2004-10-03 10:13:34', NULL);
INSERT INTO categories VALUES (5, 'subcategory_printers.gif', 1, 0, '2004-10-03 10:13:34', NULL);
INSERT INTO categories VALUES (6, 'subcategory_monitors.gif', 1, 0, '2004-10-03 10:13:34', NULL);
INSERT INTO categories VALUES (7, 'subcategory_speakers.gif', 1, 0, '2004-10-03 10:13:34', NULL);
INSERT INTO categories VALUES (8, 'subcategory_keyboards.gif', 1, 0, '2004-10-03 10:13:34', NULL);
INSERT INTO categories VALUES (9, 'subcategory_mice.gif', 1, 0, '2004-10-03 10:13:34', NULL);
INSERT INTO categories VALUES (10, 'subcategory_action.gif', 3, 0, '2004-10-03 10:13:34', '2004-10-15 19:31:02');
INSERT INTO categories VALUES (11, 'subcategory_science_fiction.gif', 3, 0, '2004-10-03 10:13:34', '2004-10-15 19:32:03');
INSERT INTO categories VALUES (12, 'subcategory_comedy.gif', 3, 0, '2004-10-03 10:13:34', '2004-10-15 19:33:00');
INSERT INTO categories VALUES (13, 'subcategory_cartoons.gif', 3, 0, '2004-10-03 10:13:34', '2004-10-15 19:31:24');
INSERT INTO categories VALUES (15, 'subcategory_drama.gif', 3, 0, '2004-10-03 10:13:34', NULL);
INSERT INTO categories VALUES (16, 'subcategory_memory.gif', 1, 0, '2004-10-03 10:13:34', NULL);
INSERT INTO categories VALUES (17, 'subcategory_cdrom_drives.gif', 1, 0, '2004-10-03 10:13:34', NULL);
INSERT INTO categories VALUES (18, 'subcategory_simulation.gif', 2, 0, '2004-10-03 10:13:34', NULL);
INSERT INTO categories VALUES (19, 'subcategory_action_games.gif', 2, 0, '2004-10-03 10:13:34', NULL);
INSERT INTO categories VALUES (20, 'subcategory_strategy.gif', 2, 0, '2004-10-03 10:13:34', NULL);
INSERT INTO categories_description VALUES (1, 4, 'Hardware');
INSERT INTO categories_description VALUES (2, 4, 'Software');
INSERT INTO categories_description VALUES (3, 4, 'DVD Filmes');
INSERT INTO categories_description VALUES (4, 4, 'Graphics Cards');
INSERT INTO categories_description VALUES (5, 4, 'Printers');
INSERT INTO categories_description VALUES (6, 4, 'Monitores');
INSERT INTO categories_description VALUES (7, 4, 'Speakers');
INSERT INTO categories_description VALUES (8, 4, 'Keyboards');
INSERT INTO categories_description VALUES (9, 4, 'Mice');
INSERT INTO categories_description VALUES (10, 4, 'Ao');
INSERT INTO categories_description VALUES (11, 4, 'Fico');
INSERT INTO categories_description VALUES (12, 4, 'Comdia');
INSERT INTO categories_description VALUES (13, 4, 'Desenhos');
INSERT INTO categories_description VALUES (15, 4, 'Drama');
INSERT INTO categories_description VALUES (16, 4, 'Memory');
INSERT INTO categories_description VALUES (17, 4, 'CDROM Drives');
INSERT INTO categories_description VALUES (18, 4, 'Simulation');
INSERT INTO categories_description VALUES (19, 4, 'Ao');
INSERT INTO categories_description VALUES (20, 4, 'Strategy');
INSERT INTO configuration VALUES (1, 'Nome da Loja', 'STORE_NAME', 'PHPmania osCommerce2.2ms2', 'O nome da sua loja', 1, 1, '2004-10-04 19:51:47', '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (2, 'Nome do Proprietrio', 'STORE_OWNER', 'PHPmania', 'Nome do Proprietrio da Loja', 1, 2, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (3, 'E-Mail do Proprietrio', 'STORE_OWNER_EMAIL_ADDRESS', 'seuemail@mail.com', 'E-mail do proprietrio da loja', 1, 3, '2004-10-03 18:56:35', '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (4, 'E-Mail dos pedidos', 'EMAIL_FROM', 'Phpmania <Seu-email@seudominio.com>', 'E-mail usado para o envio dos pedidos', 1, 4, '2004-10-03 18:56:04', '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (5, 'Pas', 'STORE_COUNTRY', '30', 'Pas onde a loja est localizada', 1, 6, '2004-10-04 19:07:11', '2004-10-03 10:13:34', 'tep_get_country_name', 'tep_cfg_pull_down_country_list(');
INSERT INTO configuration VALUES (6, 'Estado', 'STORE_ZONE', '68', 'Estado onde a loja est localizada', 1, 7, '2004-10-17 12:50:07', '2004-10-03 10:13:34', 'tep_cfg_get_zone_name', 'tep_cfg_pull_down_zone_list(');
INSERT INTO configuration VALUES (7, 'Ordem dos produtos', 'EXPECTED_PRODUCTS_SORT', 'desc', 'Esta  a ordem usada na caixa de seleo dos produtos', 1, 8, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''asc'', ''desc''),');
INSERT INTO configuration VALUES (8, 'Como aparecer a ordem dos produtos', 'EXPECTED_PRODUCTS_FIELD', 'date_expected', 'A ordem dos produtos que so mostrados', 1, 9, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''products_name'', ''date_expected''),');
INSERT INTO configuration VALUES (9, 'Trocar a moeda corrente do idioma para padro', 'USE_DEFAULT_LANGUAGE_CURRENCY', 'false', 'Mudar automaticamente para a moeda corrente padro do idioma quando for mudado', 1, 10, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (10, 'Avisar pedidos por e-mail', 'SEND_EXTRA_ORDER_EMAILS_TO', '', 'Enviar aviso para o e-mail da loja quando pedidos forem realizados: Name 1 &lt;email@address1&gt;, Name 2 &lt;email@address2&gt;', 1, 11, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (11, 'Usar Search-Engine URLs Seguros (ainda em desenvolvimento)', 'SEARCH_ENGINE_FRIENDLY_URLS', 'false', 'Usar search-engine URLs seguros para todos links de site', 1, 12, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (12, 'Mostrar produtos comprados', 'DISPLAY_CART', 'true', 'Mostrar todos os produtos depois de feito o pedido', 1, 14, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (13, 'Enviar pgina para um amigo', 'ALLOW_GUEST_TO_TELL_A_FRIEND', 'true', 'Permitir que o visitante envie informaes da loja e produtos para amigo', 1, 15, '2004-10-25 19:09:09', '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (14, 'Usar o mtodo de busca padro', 'ADVANCED_SEARCH_DEFAULT_OPERATOR', 'and', 'Mtodo de busca padro', 1, 17, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''and'', ''or''),');
INSERT INTO configuration VALUES (15, 'Endereo e Telefone da loja', 'STORE_NAME_ADDRESS', 'Nome da loja Endereo Telefone', 'Isto  o Nome de Loja, Endereo e Telefona para ser usado em documentos imprimveis e exibidos online', 1, 18, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_textarea(');
INSERT INTO configuration VALUES (16, 'Mostrar Quantidades nas categorias', 'SHOW_COUNTS', 'true', 'Mostra quantos produtos esto em cada categoria', 1, 19, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (17, 'Taxas e Impostos', 'TAX_DECIMAL_PLACES', '0', 'Adicionar o valor da taxa a ser cobrado', 1, 20, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (18, 'Mostrar preos com taxas', 'DISPLAY_PRICE_WITH_TAX', 'false', 'Mostrar preo com taxas(impostos) se tiver?', 1, 21, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (19, 'Primeiro nome', 'ENTRY_FIRST_NAME_MIN_LENGTH', '4', 'Quantidade mnima de letras para o primeiro nome', 2, 1, '2004-10-25 19:09:49', '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (20, 'Sobrenome', 'ENTRY_LAST_NAME_MIN_LENGTH', '3', 'Quantidade mnima de letras para o sobrenome', 2, 2, '2004-10-25 19:10:06', '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (21, 'Data de Nascimento', 'ENTRY_DOB_MIN_LENGTH', '10', 'Quantidade mnima de letras para a data', 2, 3, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (22, 'Seu E-Mail', 'ENTRY_EMAIL_ADDRESS_MIN_LENGTH', '6', 'Quantidade mnima de letras para o e-mail', 2, 4, '2004-10-25 19:12:23', '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (23, 'Endereo', 'ENTRY_STREET_ADDRESS_MIN_LENGTH', '5', 'Quantidade mnima de letras para o endereo', 2, 5, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (24, 'Empresa', 'ENTRY_COMPANY_MIN_LENGTH', '2', 'Quantidade mnima de letras para o nome da Empresa', 2, 6, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (25, 'CEP', 'ENTRY_POSTCODE_MIN_LENGTH', '8', 'Quantidade mnima de letras para o CEP', 2, 7, '2004-10-25 19:11:22', '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (26, 'Cidade', 'ENTRY_CITY_MIN_LENGTH', '3', 'Quantidade mnima de letras para a Cidade', 2, 8, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (27, 'Estado', 'ENTRY_STATE_MIN_LENGTH', '2', 'Quantidade mnima de letras para o estado', 2, 9, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (28, 'Nmero do Telefone', 'ENTRY_TELEPHONE_MIN_LENGTH', '5', 'Quantidade mnima de nmeros para o telefone', 2, 10, '2004-10-25 19:13:08', '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (29, 'Senha', 'ENTRY_PASSWORD_MIN_LENGTH', '5', 'Quantidade mnima de letras para a senha', 2, 11, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (30, 'Nome do Titular do Carto', 'CC_OWNER_MIN_LENGTH', '3', 'Quantidade mnima de letras do nome do titular do carto', 2, 12, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (31, 'Nmero do carto de Crdito', 'CC_NUMBER_MIN_LENGTH', '10', 'Quantidade mnima de nmeros para o carto de crdito', 2, 13, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (32, 'Comentrios', 'REVIEW_TEXT_MIN_LENGTH', '10', 'Quantidade mnima de letras em um comentrio', 2, 14, '2004-10-26 06:18:39', '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (33, 'Mais Vendidos', 'MIN_DISPLAY_BESTSELLERS', '1', 'Nmero mnimo de mais vendidos para exibio', 2, 15, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (34, 'Tambm Compraram', 'MIN_DISPLAY_ALSO_PURCHASED', '1', 'Nmero mnimo de produtos para exibio em \\''Clientes tambm Compraram\\'' box', 2, 16, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (35, 'Livro de Endereos', 'MAX_ADDRESS_BOOK_ENTRIES', '5', 'Nmero mximo de endereos de entrega que um cliente pode ter', 3, 1, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (36, 'Resultado da Busca', 'MAX_DISPLAY_SEARCH_RESULTS', '20', 'Nmero mximo de produtos a serem listados', 3, 2, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (37, 'Links', 'MAX_DISPLAY_PAGE_LINKS', '5', 'Nmero mximo de links em uma pgina', 3, 3, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (38, 'Ofertas', 'MAX_DISPLAY_SPECIAL_PRODUCTS', '9', 'Mximo nmero de ofertas a serem exibidas', 3, 4, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (39, 'Novidades', 'MAX_DISPLAY_NEW_PRODUCTS', '9', 'Mximo nmero de novos produtos a serem exibidos em uma categoria', 3, 5, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (40, 'Lanamentos', 'MAX_DISPLAY_UPCOMING_PRODUCTS', '10', 'Nmeros mximo de lanamentos a serem exibidos', 3, 6, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (41, 'Lista de Fabricantes', 'MAX_DISPLAY_MANUFACTURERS_IN_A_LIST', '0', 'Usado no box dos fabricantes; quando o nmero de fabricantes exceder este nmero o menu passar a ser de seleo', 3, 7, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (42, 'Tamanho da Caixa de seleo de fabricantes', 'MAX_MANUFACTURERS_LIST', '1', 'Usado no box dos fabricantes; quando o valor  \\''1\\'' a drop-down list  utilizada no box dos fabricantes.', 3, 7, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (43, 'Tamanho mximo do nome do Fabricante', 'MAX_DISPLAY_MANUFACTURER_NAME_LEN', '15', 'Usado no box dos fabricantes; mximo nmero de letras do nome do fabricante a ser exibido', 3, 8, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (44, 'Comentrios', 'MAX_DISPLAY_NEW_REVIEWS', '6', 'Nmero mximo de comentrios a serem exibidos', 3, 9, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (45, 'Seleo randmica de comentrios', 'MAX_RANDOM_SELECT_REVIEWS', '10', 'Nmero de comentrios que sero utilizados na seleo', 3, 10, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (46, 'Seleo Randmica de Novidades', 'MAX_RANDOM_SELECT_NEW', '10', 'Nmero de comentrios que sero utilizados na seleo', 3, 11, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (47, 'Seleo Randmica de Ofertas', 'MAX_RANDOM_SELECT_SPECIALS', '10', 'Quantos registros sero utilizados para selecionar ofertas a serem exibidas', 3, 12, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (48, 'Categorias a serem listadas', 'MAX_DISPLAY_CATEGORIES_PER_ROW', '3', 'Nmero de categorias a serem listadas por fila', 3, 13, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (49, 'Lista de Novos Produtos', 'MAX_DISPLAY_PRODUCTS_NEW', '10', 'Nmero mximo de produtos a serem listados na pgina de novos produtos', 3, 14, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (50, 'Mais Vendidos', 'MAX_DISPLAY_BESTSELLERS', '5', 'Mximo nmero de mais vendidos a serem exibidos', 3, 15, '2004-10-10 21:07:24', '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (51, 'Tambm compraram', 'MAX_DISPLAY_ALSO_PURCHASED', '6', 'Mximo nmero de indicaes a serem exibidos no box \\''Clientes tambm compraram\\'' box', 3, 16, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (52, 'Historico do Pedido do Cliente', 'MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX', '6', 'Nmero mximo dos produtos a mostrar na caixa do histrico do pedido do cliente', 3, 17, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (53, 'Histrico do Pedido', 'MAX_DISPLAY_ORDER_HISTORY', '10', 'Mostrar nmero mximo de pedidos na pgina do histrico de pedido', 3, 18, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (54, 'Largura da Imagem Pequena', 'SMALL_IMAGE_WIDTH', '100', 'Em pixels', 4, 1, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (55, 'Altura da Imagem Pequena', 'SMALL_IMAGE_HEIGHT', '80', 'Em pixels', 4, 2, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (56, 'Largura da Imagem do Cabealho', 'HEADING_IMAGE_WIDTH', '57', 'Em pixels', 4, 3, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (57, 'Altura da Imagem do Cabealho', 'HEADING_IMAGE_HEIGHT', '40', 'Em pixels', 4, 4, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (58, 'Largura da Imagem da Subcategoria', 'SUBCATEGORY_IMAGE_WIDTH', '100', 'Em pixels', 4, 5, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (59, 'Altura da Imagem da Subcategoria', 'SUBCATEGORY_IMAGE_HEIGHT', '57', 'Em pixels', 4, 6, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (60, 'Calcular tamanho da Imagem', 'CONFIG_CALCULATE_IMAGE_SIZE', 'true', 'Calcula o tamanho da imagem?', 4, 7, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (61, 'Imagem Obrigatria', 'IMAGE_REQUIRED', 'true', 'Abilitar insero obrigatria de imagens.', 4, 8, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (62, 'Sexo (Masculino/Feminino)', 'ACCOUNT_GENDER', 'true', 'Ativar Sexo no cadastro de clientess', 5, 1, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (63, 'Data de Nascimento', 'ACCOUNT_DOB', 'true', 'Ativar Data de nascimento no cadastro de clientes', 5, 2, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (64, 'Empresa', 'ACCOUNT_COMPANY', 'false', 'Ativar Detalhes da Empresa no cadastro de clientes', 5, 3, '2004-10-15 06:56:52', '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (65, 'Bairro', 'ACCOUNT_SUBURB', 'true', 'Ativar Bairro no cadastro de clientes', 5, 4, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (66, 'Estado', 'ACCOUNT_STATE', 'true', 'Ativar Estado no cadastro de clientes', 5, 5, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (67, 'Mdulos instalados', 'MODULE_PAYMENT_INSTALLED', '', 'Lista os arquivos de mdulos de pagamento separados por um ponto e virgula. Esta listagem  automtica.', 6, 0, '2004-10-26 21:53:51', '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (68, 'Installed Modules', 'MODULE_ORDER_TOTAL_INSTALLED', 'ot_subtotal.php;ot_shipping.php;ot_tax.php;ot_total.php', 'List of order_total module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: ot_subtotal.php;ot_tax.php;ot_shipping.php;ot_total.php)', 6, 0, '2004-10-13 07:53:18', '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (69, 'Mdulos instalados', 'MODULE_SHIPPING_INSTALLED', '', 'Lista os arquivos de mdulos de frete separados por um ponto e virgula. Esta listagem  automtica.', 6, 0, '2004-10-26 21:55:56', '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (84, 'Default Currency', 'DEFAULT_CURRENCY', 'BR', 'Default Currency', 6, 0, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (85, 'Default Language', 'DEFAULT_LANGUAGE', 'br', 'Default Language', 6, 0, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (86, 'Default Order Status For New Orders', 'DEFAULT_ORDERS_STATUS_ID', '1', 'When a new order is created, this order status will be assigned to it.', 6, 0, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (87, 'Display Shipping', 'MODULE_ORDER_TOTAL_SHIPPING_STATUS', 'true', 'Do you want to display the order shipping cost?', 6, 1, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (88, 'Sort Order', 'MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER', '2', 'Sort order of display.', 6, 2, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (89, 'Allow Free Shipping', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING', 'false', 'Do you want to allow free shipping?', 6, 3, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (90, 'Free Shipping For Orders Over', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER', '50', 'Provide free shipping for orders over the set amount.', 6, 4, NULL, '2004-10-03 10:13:34', 'currencies->format', NULL);
INSERT INTO configuration VALUES (91, 'Provide Free Shipping For Orders Made', 'MODULE_ORDER_TOTAL_SHIPPING_DESTINATION', 'national', 'Provide free shipping for orders sent to the set destination.', 6, 5, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''national'', ''international'', ''both''),');
INSERT INTO configuration VALUES (92, 'Display Sub-Total', 'MODULE_ORDER_TOTAL_SUBTOTAL_STATUS', 'true', 'Do you want to display the order sub-total cost?', 6, 1, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (93, 'Sort Order', 'MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER', '1', 'Sort order of display.', 6, 2, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (94, 'Display Tax', 'MODULE_ORDER_TOTAL_TAX_STATUS', 'true', 'Do you want to display the order tax value?', 6, 1, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (95, 'Sort Order', 'MODULE_ORDER_TOTAL_TAX_SORT_ORDER', '3', 'Sort order of display.', 6, 2, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (96, 'Display Total', 'MODULE_ORDER_TOTAL_TOTAL_STATUS', 'true', 'Do you want to display the total order value?', 6, 1, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (97, 'Sort Order', 'MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER', '4', 'Sort order of display.', 6, 2, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (98, 'Cdigo do Pas', 'SHIPPING_ORIGIN_COUNTRY', '30', 'Entre o &quot;ISO 3166&quot; cdigo do pas onde se localiza a sua loja.', 7, 1, NULL, '2004-10-03 10:13:34', 'tep_get_country_name', 'tep_cfg_pull_down_country_list(');
INSERT INTO configuration VALUES (99, 'CEP', 'SHIPPING_ORIGIN_ZIP', '70866120', 'Entre o CEP de sua Loja.', 7, 2, '2004-10-25 19:15:19', '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (100, 'Entre o peso mximo do pacote que ir entregar', 'SHIPPING_MAX_WEIGHT', '50', 'Carriers have a max weight limit for a single package. This is a common one for all.', 7, 3, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (101, 'Peso Normal dos Pacotes.', 'SHIPPING_BOX_WEIGHT', '', 'Qual  o peso normal dos pacotes que costuma entregar?', 7, 4, '2004-10-20 07:03:51', '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (102, 'Pacotes grandes Incrementar porcentagem.', 'SHIPPING_BOX_PADDING', '0', 'Se for 10% coloque 10', 7, 5, '2004-10-20 07:04:03', '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (103, 'Mostrar Imagem do Produto', 'PRODUCT_LIST_IMAGE', '1', 'Escolha 1 para sim ou 0 para no', 8, 1, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (104, 'Mostrar nome dos Fabricantes', 'PRODUCT_LIST_MANUFACTURER', '0', 'Escolha 1 para sim ou 0 para no', 8, 2, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (105, 'Mostrar modelo dos produtos', 'PRODUCT_LIST_MODEL', '0', 'Escolha 1 para sim ou 0 para no', 8, 3, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (106, 'Mostrar nome dos produtos', 'PRODUCT_LIST_NAME', '2', 'Escolha 1 para sim ou 0 para no', 8, 4, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (107, 'Exibir preos dos produtos', 'PRODUCT_LIST_PRICE', '3', 'Escolha 1 para sim ou 0 para no', 8, 5, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (108, 'Mostrar quantidade dos produtos', 'PRODUCT_LIST_QUANTITY', '0', 'Escolha 1 para sim ou 0 para no', 8, 6, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (109, 'Mostrar peso dos produtos', 'PRODUCT_LIST_WEIGHT', '0', 'Escolha 1 para sim ou 0 para no', 8, 7, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (110, 'Mostrar coluna Compre Agora', 'PRODUCT_LIST_BUY_NOW', '4', 'Escolha 1 para sim ou 0 para no', 8, 8, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (111, 'Exibir filtros categorias/fabricantes', 'PRODUCT_LIST_FILTER', '1', 'Escolha 1 para sim ou 0 para no', 8, 9, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (112, 'Escolha a localizao dos botes Anterior/Prxima', 'PREV_NEXT_BAR_LOCATION', '2', '1-topo, 2-em baixo, 3-nos dois lugares', 8, 10, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (113, 'Checar Estoque', 'STOCK_CHECK', 'true', 'Ativar checagem do estoque', 9, 1, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (114, 'Subtrair do Estoque', 'STOCK_LIMITED', 'true', 'Subtrair produto do estoque quando for realizado um pedido', 9, 2, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (115, 'Permitir ir ao caixa', 'STOCK_ALLOW_CHECKOUT', 'true', 'Permitir cliente ir ao caixa mesmo quando o estoque for insuficiente', 9, 3, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (116, 'Marcar produtos fora de estoque', 'STOCK_MARK_PRODUCT_OUT_OF_STOCK', '***', 'Exibir *** quando o produto no estiver disponvel em estoque', 9, 4, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (117, 'Estoque baixo', 'STOCK_REORDER_LEVEL', '5', 'Defina a quantidade crtica do seu estoque', 9, 5, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (118, 'Analisar o tempo na pgina da loja', 'STORE_PAGE_PARSE_TIME', 'false', 'Armazene o tempo que leva para analisar uma pgina', 10, 1, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (119, 'Destino do log', 'STORE_PAGE_PARSE_TIME_LOG', '/var/log/www/tep/page_parse_time.log', 'O diretrio e nome do arquivo da pgina que analisar o tempo do log', 10, 2, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (120, 'Formato da data do log', 'STORE_PARSE_DATE_TIME_FORMAT', '%d/%m/%Y %H:%M:%S', 'O formato da data', 10, 3, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (121, 'Mostrar a pgina analise tempo', 'DISPLAY_PAGE_PARSE_TIME', 'true', 'Mostrar a pgina analise tempo (Deve estar habilitado)', 10, 4, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (122, 'Armazene as informaes do banco de dados', 'STORE_DB_TRANSACTIONS', 'false', 'Armazene as informaes do banco de dados na pgina analise do tempo do log (PHP4 somente)', 10, 5, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (123, 'Use Cache', 'USE_CACHE', 'false', 'Caractersticas use caching', 11, 1, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (124, 'Diretrio do cache', 'DIR_FS_CACHE', '/tmp/', 'O diretrio onde o arquivos cached sero armazenados', 11, 2, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (125, 'E-Mail mtodo de envio', 'EMAIL_TRANSPORT', 'sendmail', 'Defina se este servidor usa uma conexo de local para sendmail ou usa uma conexo de SMTP via TCP/IP. Os servidores que executam em Windows e MacOS deveram mudar este configurando para SMTP.', 12, 1, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''sendmail'', ''smtp''),');
INSERT INTO configuration VALUES (126, 'E-Mail Linefeeds', 'EMAIL_LINEFEED', 'LF', 'Defina a seqncia de caractere costuma-se separar cabealhos do email.', 12, 2, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''LF'', ''CRLF''),');
INSERT INTO configuration VALUES (127, 'Use MIME HTML quando enviar Emails', 'EMAIL_USE_HTML', 'false', 'Enviar e-mails em formato HTML', 12, 3, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (128, 'Verifique endereos de E-mail por DNS', 'ENTRY_EMAIL_ADDRESS_CHECK', 'false', 'Verifique endereo de e-mail por um servidor de DNS', 12, 4, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (129, 'Enviar E-mails', 'SEND_EMAILS', 'true', 'Enviar e-mails', 12, 5, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (130, 'Ativar download', 'DOWNLOAD_ENABLED', 'false', 'Ativar as funes de download de produtos.', 13, 1, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (131, 'Redirecionar o download', 'DOWNLOAD_BY_REDIRECT', 'false', 'Use redirecionamento de Browser para download. Desativar em sistemas No Unix.', 13, 2, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (132, 'Expiry demora (dias)', 'DOWNLOAD_MAX_DAYS', '7', 'Configurar nmero de dias antes do link de download expirar. 0 no significa nenhum limite.', 13, 3, NULL, '2004-10-03 10:13:34', NULL, '');
INSERT INTO configuration VALUES (133, 'Nmero mximo de downloads', 'DOWNLOAD_MAX_COUNT', '5', 'Configurar o nmero mximo de downloads. ( 0 ) significa nenhum download autorizado.', 13, 4, NULL, '2004-10-03 10:13:34', NULL, '');
INSERT INTO configuration VALUES (134, 'Ativar Compresso GZip', 'GZIP_COMPRESSION', 'false', 'Ativar compresso de HTTP GZip.', 14, 1, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO configuration VALUES (135, 'Nvel de compresso', 'GZIP_LEVEL', '5', 'Use este nvel de compresso 0-9 (0 = mnimo, 9 = mximo).', 14, 2, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (136, 'Diretrio da sesso', 'SESSION_WRITE_DIRECTORY', '/tmp', 'sesses so arquivo baseado, armazene eles neste diretrio.', 15, 1, NULL, '2004-10-03 10:13:34', NULL, NULL);
INSERT INTO configuration VALUES (137, 'Forar uso de Cookies', 'SESSION_FORCE_COOKIE_USE', 'False', 'Fora o uso de cookie nas sesses s quando estiver habilitado.', 15, 2, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''True'', ''False''),');
INSERT INTO configuration VALUES (138, 'Checar sesso de SSL ID', 'SESSION_CHECK_SSL_SESSION_ID', 'False', 'Validar o SSL_SESSION_ID em todo pedido de pgina de HTTPS seguro.', 15, 3, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''True'', ''False''),');
INSERT INTO configuration VALUES (139, 'Checar agente de usurio', 'SESSION_CHECK_USER_AGENT', 'False', 'Validar o agente de usurio de clientes Browser em todo pedido de pgina.', 15, 4, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''True'', ''False''),');
INSERT INTO configuration VALUES (140, 'Checar endereo de IP', 'SESSION_CHECK_IP_ADDRESS', 'False', 'Validar o endereo de IP do cliente em todo pedido de pgina.', 15, 5, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''True'', ''False''),');
INSERT INTO configuration VALUES (141, 'Previnir sesses de Spider', 'SESSION_BLOCK_SPIDERS', 'False', 'Previnir de Spider antes de comear uma sesso.', 15, 6, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''True'', ''False''),');
INSERT INTO configuration VALUES (142, 'Recriar sesso', 'SESSION_RECREATE', 'False', 'Recreie a sesso para gerar uma nova sesso ID quando os logs do cliente em ou cria uma conta (precisa do PHP >=4.1 ).', 15, 7, NULL, '2004-10-03 10:13:34', NULL, 'tep_cfg_select_option(array(''True'', ''False''),');
INSERT INTO configuration VALUES (1175, 'Entrega Correios Sedex', 'MODULE_SHIPPING_ENTREGA_REGIONS_STATUS', 'True', 'Ativar Entrega via sedex?', 6, 0, NULL, '2004-10-19 20:42:06', NULL, 'tep_cfg_select_option(array(''True'', ''False''),');
INSERT INTO configuration VALUES (541, 'Sort Order', 'MODULE_SHIPPING_REMESSA_NACIONAL_2_SORT_ORDER', '0', 'Sort order of display.', 6, 0, NULL, '2004-10-10 18:21:36', NULL, NULL);
INSERT INTO configuration VALUES (493, 'Sort Order', 'MODULE_SHIPPING_REMESSA_NACIONAL_2_SORT_ORDER', '0', 'Sort order of display.', 6, 0, NULL, '2004-10-10 17:53:52', NULL, NULL);
INSERT INTO configuration VALUES (517, 'Sort Order', 'MODULE_SHIPPING_REMESSA_NACIONAL_2_SORT_ORDER', '0', 'Sort order of display.', 6, 0, NULL, '2004-10-10 18:10:55', NULL, NULL);
INSERT INTO configuration VALUES (616, 'Sort Order', 'MODULE_SHIPPING_REMESSA_NACIONAL_3_SORT_ORDER', '1', 'Sort order of display.', 6, 0, NULL, '2004-10-12 18:06:53', NULL, NULL);
INSERT INTO configuration VALUES (640, 'Sort Order', 'MODULE_SHIPPING_REMESSA_NACIONAL_3_SORT_ORDER', '0', 'Sort order of display.', 6, 0, NULL, '2004-10-12 18:24:39', NULL, NULL);
INSERT INTO configuration VALUES (785, 'Zone 2 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_2', 'BR,BH', 'Comma separated list of two character ISO country codes that are part of Zone 2.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (786, 'Zone 2 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_2', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 2 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 2 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (787, 'Zone 2 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_2', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (788, 'Zone 3 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_3', '', 'Comma separated list of two character ISO country codes that are part of Zone 3.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (789, 'Zone 3 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_3', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 3 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 3 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (790, 'Zone 3 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_3', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (791, 'Zone 4 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_4', '', 'Comma separated list of two character ISO country codes that are part of Zone 4.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (792, 'Zone 4 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_4', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 4 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 4 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (793, 'Zone 4 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_4', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (794, 'Zone 5 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_5', '', 'Comma separated list of two character ISO country codes that are part of Zone 5.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (795, 'Zone 5 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_5', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 5 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 5 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (796, 'Zone 5 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_5', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (797, 'Zone 6 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_6', '', 'Comma separated list of two character ISO country codes that are part of Zone 6.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (798, 'Zone 6 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_6', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 6 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 6 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (799, 'Zone 6 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_6', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (800, 'Zone 7 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_7', '', 'Comma separated list of two character ISO country codes that are part of Zone 7.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (801, 'Zone 7 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_7', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 7 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 7 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (802, 'Zone 7 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_7', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (803, 'Zone 8 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_8', '', 'Comma separated list of two character ISO country codes that are part of Zone 8.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (804, 'Zone 8 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_8', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 8 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 8 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (805, 'Zone 8 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_8', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (806, 'Zone 9 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_9', '', 'Comma separated list of two character ISO country codes that are part of Zone 9.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (807, 'Zone 9 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_9', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 9 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 9 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (808, 'Zone 9 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_9', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (809, 'Zone 10 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_10', '', 'Comma separated list of two character ISO country codes that are part of Zone 10.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (810, 'Zone 10 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_10', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 10 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 10 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (811, 'Zone 10 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_10', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (812, 'Zone 11 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_11', '', 'Comma separated list of two character ISO country codes that are part of Zone 11.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (813, 'Zone 11 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_11', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 11 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 11 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (814, 'Zone 11 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_11', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (815, 'Zone 12 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_12', '', 'Comma separated list of two character ISO country codes that are part of Zone 12.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (816, 'Zone 12 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_12', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 12 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 12 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (817, 'Zone 12 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_12', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (818, 'Zone 13 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_13', '', 'Comma separated list of two character ISO country codes that are part of Zone 13.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (819, 'Zone 13 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_13', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 13 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 13 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (820, 'Zone 13 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_13', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (821, 'Zone 14 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_14', '', 'Comma separated list of two character ISO country codes that are part of Zone 14.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (822, 'Zone 14 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_14', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 14 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 14 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (823, 'Zone 14 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_14', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (824, 'Zone 15 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_15', '', 'Comma separated list of two character ISO country codes that are part of Zone 15.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (825, 'Zone 15 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_15', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 15 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 15 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (826, 'Zone 15 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_15', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (827, 'Zone 16 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_16', '', 'Comma separated list of two character ISO country codes that are part of Zone 16.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (828, 'Zone 16 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_16', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 16 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 16 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (829, 'Zone 16 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_16', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (830, 'Zone 17 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_17', '', 'Comma separated list of two character ISO country codes that are part of Zone 17.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (831, 'Zone 17 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_17', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 17 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 17 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (832, 'Zone 17 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_17', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (833, 'Zone 18 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_18', '', 'Comma separated list of two character ISO country codes that are part of Zone 18.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (834, 'Zone 18 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_18', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 18 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 18 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (835, 'Zone 18 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_18', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (836, 'Zone 19 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_19', '', 'Comma separated list of two character ISO country codes that are part of Zone 19.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (837, 'Zone 19 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_19', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 19 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 19 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (838, 'Zone 19 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_19', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (839, 'Zone 20 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_20', '', 'Comma separated list of two character ISO country codes that are part of Zone 20.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (840, 'Zone 20 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_20', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 20 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 20 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (841, 'Zone 20 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_20', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (842, 'Zone 21 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_21', '', 'Comma separated list of two character ISO country codes that are part of Zone 21.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (843, 'Zone 21 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_21', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 21 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 21 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (844, 'Zone 21 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_21', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (845, 'Zone 22 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_22', '', 'Comma separated list of two character ISO country codes that are part of Zone 22.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (846, 'Zone 22 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_22', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 22 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 22 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (847, 'Zone 22 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_22', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (848, 'Zone 23 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_23', '', 'Comma separated list of two character ISO country codes that are part of Zone 23.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (849, 'Zone 23 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_23', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 23 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 23 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (850, 'Zone 23 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_23', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (851, 'Zone 24 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_24', '', 'Comma separated list of two character ISO country codes that are part of Zone 24.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (852, 'Zone 24 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_24', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 24 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 24 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (853, 'Zone 24 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_24', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (854, 'Zone 25 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_25', '', 'Comma separated list of two character ISO country codes that are part of Zone 25.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (855, 'Zone 25 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_25', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 25 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 25 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (856, 'Zone 25 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_25', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (857, 'Zone 26 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_26', '', 'Comma separated list of two character ISO country codes that are part of Zone 26.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (858, 'Zone 26 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_26', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 26 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 26 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (859, 'Zone 26 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_26', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (860, 'Zone 27 Countries', 'MODULE_SHIPPING_ZONES_COUNTRIES_27', '', 'Comma separated list of two character ISO country codes that are part of Zone 27.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (861, 'Zone 27 Shipping Table', 'MODULE_SHIPPING_ZONES_COST_27', '3:8.50,7:10.50,99:20.00', 'Shipping rates to Zone 27 destinations based on a group of maximum order weights. Example: 3:8.50,7:10.50,... Weights less than or equal to 3 would cost 8.50 for Zone 27 destinations.', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (862, 'Zone 27 Handling Fee', 'MODULE_SHIPPING_ZONES_HANDLING_27', '0', 'Handling Fee for this shipping zone', 6, 0, NULL, '2004-10-12 18:39:47', NULL, NULL);
INSERT INTO configuration VALUES (1153, 'Entrega Correios Sedex', 'MODULE_SHIPPING_ENTREGA_REGIONS_STATUS', 'True', 'Ativar Entrega via sedex?', 6, 0, NULL, '2004-10-19 20:42:01', NULL, 'tep_cfg_select_option(array(''True'', ''False''),');
INSERT INTO configuration VALUES (1217, 'Entrega Correios Sedex', 'MODULE_SHIPPING_ENTREGA_REGIONS_STATUS', 'True', 'Ativar Entrega via sedex?', 6, 0, NULL, '2004-10-19 20:42:25', NULL, 'tep_cfg_select_option(array(''True'', ''False''),');
INSERT INTO configuration VALUES (1239, 'Entrega Correios Sedex', 'MODULE_SHIPPING_ENTREGA_REGIONS_STATUS', 'True', 'Ativar Entrega via sedex?', 6, 0, NULL, '2004-10-19 20:44:38', NULL, 'tep_cfg_select_option(array(''True'', ''False''),');
INSERT INTO configuration VALUES (1283, 'Entrega Correios Sedex', 'MODULE_SHIPPING_ENTREGA_REGIONS_STATUS', 'True', 'Ativar Entrega via sedex?', 6, 0, NULL, '2004-10-19 20:48:25', NULL, 'tep_cfg_select_option(array(''True'', ''False''),');
INSERT INTO configuration VALUES (1305, 'Entrega Correios Sedex', 'MODULE_SHIPPING_ENTREGA_REGIONS_STATUS', 'True', 'Ativar Entrega via sedex?', 6, 0, NULL, '2004-10-19 20:48:26', NULL, 'tep_cfg_select_option(array(''True'', ''False''),');
INSERT INTO configuration_group VALUES (1, 'Minha Loja', 'Informaes gerais sobre a loja', 1, 1);
INSERT INTO configuration_group VALUES (2, 'Valores Mnimos', 'Valores mnimos para as funes / dados', 2, 1);
INSERT INTO configuration_group VALUES (3, 'Valores Mximos', 'Valores mximos para as funes / dados', 3, 1);
INSERT INTO configuration_group VALUES (4, 'Imagens', 'Parmetros das Imagens', 4, 1);
INSERT INTO configuration_group VALUES (5, 'Detalhes do Cliente', 'Configurao da conta do cliente', 5, 1);
INSERT INTO configuration_group VALUES (6, 'Opes de Mdulos', 'Livre de Configurao', 6, 0);
INSERT INTO configuration_group VALUES (7, 'Entrega/Pacotes', 'Opes de entrega da sua loja', 7, 1);
INSERT INTO configuration_group VALUES (8, 'Lista do Produto', 'Opes de configurao da lista de produtos', 8, 1);
INSERT INTO configuration_group VALUES (9, 'Estoque', 'Configuraes do estoque', 9, 1);
INSERT INTO configuration_group VALUES (10, 'Log', 'Log configuraes', 10, 1);
INSERT INTO configuration_group VALUES (11, 'Cache', 'Cache opces', 11, 1);
INSERT INTO configuration_group VALUES (12, 'E-Mail Opes', 'Opes para o envio dos emails', 12, 1);
INSERT INTO configuration_group VALUES (13, 'Download', 'Downloadable products options', 13, 1);
INSERT INTO configuration_group VALUES (14, 'GZip Compresso', 'Opes de compresso', 14, 1);
INSERT INTO configuration_group VALUES (15, 'Sesses', 'Opes de sesses', 15, 1);
INSERT INTO countries VALUES (30, 'Brasil', 'BR', 'BRA', 1);
INSERT INTO currencies VALUES (3, 'Real', 'BR', 'R$', '', '.', ',', '2', 1.00000000, NULL);
INSERT INTO languages VALUES (4, 'Portugus', 'br', 'icon.gif', 'portugues', 1);
INSERT INTO manufacturers VALUES (1, 'Matrox', 'manufacturer_matrox.gif', '2004-10-03 10:13:34', NULL);
INSERT INTO manufacturers VALUES (2, 'Microsoft', 'manufacturer_microsoft.gif', '2004-10-03 10:13:34', NULL);
INSERT INTO manufacturers VALUES (3, 'Warner', 'manufacturer_warner.gif', '2004-10-03 10:13:34', NULL);
INSERT INTO manufacturers VALUES (4, 'Fox', 'manufacturer_fox.gif', '2004-10-03 10:13:34', NULL);
INSERT INTO manufacturers VALUES (5, 'Logitech', 'manufacturer_logitech.gif', '2004-10-03 10:13:34', NULL);
INSERT INTO manufacturers VALUES (6, 'Canon', 'manufacturer_canon.gif', '2004-10-03 10:13:34', NULL);
INSERT INTO manufacturers VALUES (7, 'Sierra', 'manufacturer_sierra.gif', '2004-10-03 10:13:34', NULL);
INSERT INTO manufacturers VALUES (8, 'GT Interactive', 'manufacturer_gt_interactive.gif', '2004-10-03 10:13:34', NULL);
INSERT INTO manufacturers VALUES (9, 'Hewlett Packard', 'manufacturer_hewlett_packard.gif', '2004-10-03 10:13:34', NULL);
INSERT INTO manufacturers_info VALUES (1, 4, 'http://www.matrox.com', 0, NULL);
INSERT INTO manufacturers_info VALUES (2, 4, 'http://www.microsoft.com', 0, NULL);
INSERT INTO manufacturers_info VALUES (3, 4, 'http://www.warner.com', 0, NULL);
INSERT INTO manufacturers_info VALUES (4, 4, 'http://www.fox.com', 0, NULL);
INSERT INTO manufacturers_info VALUES (5, 4, 'http://www.logitech.com', 0, NULL);
INSERT INTO manufacturers_info VALUES (6, 4, 'http://www.canon.com', 0, NULL);
INSERT INTO manufacturers_info VALUES (7, 4, 'http://www.sierra.com', 0, NULL);
INSERT INTO manufacturers_info VALUES (8, 4, 'http://www.infogrames.com', 0, NULL);
INSERT INTO manufacturers_info VALUES (9, 4, 'http://www.hewlettpackard.com', 0, NULL);
INSERT INTO orders_status VALUES (1, 4, 'Pendente');
INSERT INTO orders_status VALUES (2, 4, 'Processando');
INSERT INTO orders_status VALUES (3, 4, 'Enviado');
INSERT INTO products VALUES (1, 500, 'MG200MMS', 'matrox/mg200mms.gif', 299.9900, '2004-10-03 10:13:34', '2004-10-25 19:43:55', NULL, 1.00, 1, 0, 1, 0);
INSERT INTO products VALUES (2, 500, 'MG400-32MB', 'matrox/mg400-32mb.gif', 499.9900, '2004-10-03 10:13:34', '2004-10-25 19:44:16', NULL, 1.00, 1, 1, 1, 0);
INSERT INTO products VALUES (3, 500, 'MSIMPRO', 'microsoft/msimpro.gif', 49.9900, '2004-10-03 10:13:34', '2004-10-25 19:43:06', NULL, 1.00, 1, 0, 3, 0);
INSERT INTO products VALUES (4, 500, 'DVD-RPMK', 'dvd/replacement_killers.gif', 42.0000, '2004-10-03 10:13:34', '2004-10-25 20:49:11', NULL, 1.00, 1, 0, 3, 0);
INSERT INTO products VALUES (5, 500, 'DVD-BLDRNDC', 'dvd/blade_runner.gif', 35.9900, '2004-10-03 10:13:34', '2004-10-25 21:06:43', NULL, 1.00, 1, 0, 3, 0);
INSERT INTO products VALUES (6, 10500, 'DVD-MATR', 'dvd/the_matrix.gif', 39.9900, '2004-10-03 10:13:34', '2004-10-25 20:47:18', NULL, 1.00, 1, 0, 3, 0);
INSERT INTO products VALUES (7, 500, 'DVD-YGEM', 'dvd/youve_got_mail.gif', 34.9900, '2004-10-03 10:13:34', '2004-10-25 20:56:35', NULL, 7.00, 1, 0, 3, 0);
INSERT INTO products VALUES (8, 500, 'DVD-ABUG', 'dvd/a_bugs_life.gif', 35.9900, '2004-10-03 10:13:34', '2004-10-25 20:57:52', NULL, 1.00, 1, 0, 3, 0);
INSERT INTO products VALUES (9, 500, 'DVD-UNSG', 'dvd/under_siege.gif', 29.9900, '2004-10-03 10:13:34', '2004-10-25 20:51:18', NULL, 1.00, 1, 0, 3, 0);
INSERT INTO products VALUES (10, 500, 'DVD-UNSG2', 'dvd/under_siege2.gif', 29.9900, '2004-10-03 10:13:34', '2004-10-25 20:53:24', NULL, 1.00, 1, 0, 3, 0);
INSERT INTO products VALUES (11, 500, 'DVD-FDBL', 'dvd/fire_down_below.gif', 29.9900, '2004-10-03 10:13:34', '2004-10-25 20:09:14', NULL, 1.00, 1, 0, 3, 0);
INSERT INTO products VALUES (12, 500, 'DVD-DHWV', 'dvd/die_hard_3.gif', 39.9900, '2004-10-03 10:13:34', '2004-10-25 20:06:54', NULL, 1.00, 1, 0, 4, 0);
INSERT INTO products VALUES (13, 500, 'DVD-LTWP', 'dvd/lethal_weapon.gif', 34.9900, '2004-10-03 10:13:34', '2004-10-25 20:38:13', NULL, 1.00, 1, 0, 3, 0);
INSERT INTO products VALUES (14, 500, 'DVD-REDC', 'dvd/red_corner.gif', 32.0000, '2004-10-03 10:13:34', '2004-10-25 21:04:44', NULL, 1.00, 1, 0, 3, 0);
INSERT INTO products VALUES (16, 500, 'DVD-CUFI', 'dvd/courage_under_fire.gif', 38.9900, '2004-10-03 10:13:34', '2004-10-25 21:01:26', NULL, 1.00, 1, 0, 4, 0);
INSERT INTO products VALUES (17, 500, 'DVD-SPEED', 'dvd/speed.gif', 39.9900, '2004-10-03 10:13:34', '2004-10-25 20:41:31', NULL, 7.00, 1, 0, 4, 0);
INSERT INTO products VALUES (18, 500, 'DVD-SPEED2', 'dvd/speed_2.gif', 42.0000, '2004-10-03 10:13:34', '2004-10-25 20:45:00', NULL, 1.00, 1, 1, 4, 0);
INSERT INTO products VALUES (19, 500, 'DVD-TSAB', 'dvd/theres_something_about_mary.gif', 49.9900, '2004-10-03 10:13:34', '2004-10-25 20:55:20', NULL, 1.00, 1, 0, 4, 0);
INSERT INTO products VALUES (20, 500, 'DVD-BELOVED', 'dvd/beloved.gif', 54.9900, '2004-10-03 10:13:34', '2004-10-25 20:59:37', NULL, 1.00, 1, 0, 3, 0);
INSERT INTO products VALUES (21, 500, 'PC-SWAT3', 'sierra/swat_3.gif', 79.9900, '2004-10-03 10:13:34', '2004-10-25 19:55:06', NULL, 1.00, 1, 1, 7, 0);
INSERT INTO products VALUES (22, 500, 'PC-UNTM', 'gt_interactive/unreal_tournament.gif', 89.9900, '2004-10-03 10:13:34', '2004-10-25 19:52:56', NULL, 1.00, 1, 1, 8, 0);
INSERT INTO products VALUES (23, 500, 'PC-TWOF', 'gt_interactive/wheel_of_time.gif', 99.9900, '2004-10-03 10:13:34', '2004-10-25 20:01:58', NULL, 1.00, 1, 0, 3, 0);
INSERT INTO products VALUES (24, 500, 'PC-DISC', 'gt_interactive/disciples.gif', 90.0000, '2004-10-03 10:13:34', '2004-10-25 19:59:54', NULL, 1.00, 1, 0, 3, 0);
INSERT INTO products VALUES (25, 500, 'MSINTKB', 'microsoft/intkeyboardps2.gif', 69.9900, '2004-10-03 10:13:34', '2004-10-25 19:44:55', NULL, 1.00, 1, 0, 2, 0);
INSERT INTO products VALUES (26, 500, 'MSIMEXP', 'microsoft/imexplorer.gif', 64.9500, '2004-10-03 10:13:34', '2004-10-25 19:43:27', NULL, 1.00, 1, 0, 2, 0);
INSERT INTO products VALUES (27, 500, 'HPLJ1100XI', 'hewlett_packard/lj1100xi.gif', 499.9900, '2004-10-03 10:13:34', '2004-10-25 19:49:59', NULL, 10.00, 1, 0, 9, 0);
INSERT INTO products_attributes VALUES (1, 1, 4, 1, 0.0000, '+');
INSERT INTO products_attributes VALUES (2, 1, 4, 2, 50.0000, '+');
INSERT INTO products_attributes VALUES (3, 1, 4, 3, 70.0000, '+');
INSERT INTO products_attributes VALUES (4, 1, 3, 5, 0.0000, '+');
INSERT INTO products_attributes VALUES (5, 1, 3, 6, 100.0000, '+');
INSERT INTO products_attributes VALUES (6, 2, 4, 3, 10.0000, '-');
INSERT INTO products_attributes VALUES (7, 2, 4, 4, 0.0000, '+');
INSERT INTO products_attributes VALUES (8, 2, 3, 6, 0.0000, '+');
INSERT INTO products_attributes VALUES (9, 2, 3, 7, 120.0000, '+');
INSERT INTO products_attributes VALUES (10, 26, 3, 8, 0.0000, '+');
INSERT INTO products_attributes VALUES (11, 26, 3, 9, 6.0000, '+');
INSERT INTO products_attributes VALUES (26, 22, 5, 10, 0.0000, '+');
INSERT INTO products_attributes VALUES (27, 22, 5, 13, 0.0000, '+');
INSERT INTO products_attributes_download VALUES (26, 'unreal.zip', 7, 3);
INSERT INTO products_description VALUES (1, 4, 'Matrox G200 MMS', 'Agora voc j pode adquirir a poderosa placa Matrox, uma das placas mais \r\npoderosas do momento, ela possui o sistema VE (Suporta dois monitores \r\nsimultaneamente), e com ela os seus jogos 3D ganharam mais vida e voc tera um \r\notimo desempenho em todos os tipos de trababalho com o sistema Dual Display. <br>\r\n<br>\r\nEspecificaes :<br>\r\nModelo: Matrox G200 Quad Multi - Monitor Series ( MMS ) Graphics Controller ( 32 \r\nMB ) <br>\r\nMaior Performance 2D/3D<br>\r\nAlta Qualidade em DVD Playback<br>\r\nArquitetura Grfica: 256-bit <br>\r\nMemria: 32MB DDR <br>\r\nChip Set: Millennium G200 <br>\r\nPlug and Play <br>\r\n<br>\r\nCaractersticas Especiais:<br>\r\n-Saida para TV (TV-Out)<br>\r\n-Excelente performance em jogos 3D e 2D<br>\r\n-Sistema VE Dual Edition:<br>\r\nSuporta dois monitores simultaneamente.', 'www.matrox.com/mga/products/g200_mms/home.cfm', 0);
INSERT INTO products_description VALUES (2, 4, 'Matrox G400 32MB', 'Alta performance Grfica</b> <br>\r\n<br>\r\nMillennium G400 Series -  extremamente diferente com alta performance grfica, \r\no chip da Millennium G400 Series tem grande velocidade e alta qualidade das \r\nimagens, junto com uma inigualvel versatilidade exibindo todas as imagens 3D, \r\n2D e ainda aplicativos DVD.  a mais poderosa e inovadora ferramenta para PC''s.<br>\r\nA Millennium G400 Series no muda somente o modo como voc v os seus grficos \r\nmas, revolucionar o modo como voc v o seu computador. <br>\r\n<br>\r\n<b>Especificaes:</b> </p>\r\n<ul>\r\n  <li>Nova Matrox G400 256-bit DualBus graphics chip </li>\r\n  <li>Alta performance em 3D, 2D e DVD </li>\r\n  <li>Sistema VE Dual Edition: Suporta dois monitores simultaneamente. </li>\r\n  <li>Sada para DVD e TV </li>\r\n  <li>Qualidade de Cor Vibrante com modelo tridimensional </li>\r\n  <li>UltraSharp DAC of up to 360 MHz </li>\r\n  <li>Processador 3D Rendering Array </li>\r\n  <li>Suporte para 16 ou 32 MB de memria</li>\r\n</ul>', 'www.matrox.com/mga/products/mill_g400/home.htm', 0);
INSERT INTO products_description VALUES (3, 4, 'Microsoft IntelliMouse Pro', 'O Microsoft IntelliMouse  o mais novo membro da famlia de produtos de \r\nmouse. A nova esfera posicionada no centro entre os dois botes fornece nova \r\nfuncionalidade no Windows 95, 98,ME,XP, Internet Explorer 6.0 e no conjunto de \r\nprodutos do Office 2003. <br>\r\n<br>\r\nBenefcios<br>\r\nTodos os aplicativos do Office 2003 sero compatveis com o novo mouse, \r\npermitindo ao usurio a transferncia com zoom, rolagem e zoom de dados para o \r\nmouse. <br>\r\nA rolagem no Windows Explorer pode ser feita com o mouse - barras de rolagem \r\nnunca mais! <br>\r\nAcesse rapidamente os vnculos ativos na Web (zoom de dados) e retorne  home \r\npage usando o mouse. Agora, navegar nas pginas Web  to fcil quanto usar o \r\nWord e o IntelliMouse, rolando com a esfera.</p>', 'www.microsoft.com/hardware/mouse/intellimouse.asp', 0);
INSERT INTO products_description VALUES (4, 4, 'Assassinos Substitutos', 'Ttulo Original: &quot;The Replacement Killers&quot; <br>\r\n<br>\r\nCdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>\r\nIdioma: Ingls, Alemo. <br>\r\nLegendas: Ingls, Alemo, Espanhol. <br>\r\nAudio: Dolby Surround 5.1. <br>\r\nFormato da Tela: 16:9 Wide-Screen. <br>\r\nDurao: (aprox) 80 minutes. <br>\r\nOutros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>\r\n<br>\r\nSinopse:O astro dos filmes de John Woo, Chow Yun-Fat faz sua estria em \r\nHollywood tendo ao seu lado Mira Sorvino (vencedora do Oscar de 1995 como Melhor \r\nAtriz Coadjuvante, em Poderosa Afrodite) em ASSASSINOS SUBSTITUTOS, um frentico \r\ne explosivo suspense de ao do diretor Antoine Fuqua (do video-clip de Coolio &quot;Gangsta''s \r\nParadise&quot;). <br>\r\nAps trair Mr. Wei, o impiedoso chefo do crime que o havia contratado para \r\nvingar a morte do filho, o assassino profissional John Lee (Chow) agora est \r\nfugindo. Contando com a ajuda da bela falsificadora de documentos Meg Coburn (Sorvino), \r\nLee pretende retornar para sua famlia na China, antes que esta seja vitimada \r\npor causa de sua traio. Mas a armada de Wei de &quot;assassinos substitutos&quot; est \r\nna sua trilha, e agora ele e Meg so os alvos de um impressionante poder de \r\nfogo. <br>\r\nCom os dois lados totalmente armados e determinados a lutar at a morte, um \r\ntiroteio ultra-violento explode quando finalmente os dois grupos se encontram.  \r\n&quot;uma fuso nunca antes vista do estilo com a ao e a aventura dos filmes de \r\nHong Kong&quot; (The New York Times) que vai deixar todos sem flego - incluindo \r\nvoc!</p>', 'www.replacement-killers.com', 0);
INSERT INTO products_description VALUES (5, 4, 'Busca Frentica', 'Ttulo Original: &quot;Frantic&quot; <br>\r\n<br>\r\nCdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>\r\nIdioma: Ingls, Alemo. <br>\r\nLegendas: Ingls, Alemo, Espanhol. <br>\r\nAudio: Dolby Surround 5.1. <br>\r\nFormato da Tela: 16:9 Wide-Screen. <br>\r\nDurao: (aprox) 115 minutes. <br>\r\nOutros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>\r\n<br>\r\nSinopse: Harrison Ford  o Dr. Richard Walker, famoso mdico que junto com sua \r\nesposa Sondra (Betty Buckley), visitam Paris pela segunda vez. <br>\r\nPela primeira vez, viveram uma lua-de-mel inesquecvel. Agora eles vo viver \r\nmomentos de suspense e terror. Tudo comea quando Sondra desaparece \r\nmisteriosamente do hotel e Walker se v sozinho em uma terra estranha, sem \r\npistas e sem ningum. At que surge a linda Michelle (Eammanuelle Seigner) que \r\nresolve ajud-lo e o leva  aterradora realidade do submundo de uma busca \r\nincansvel por sua esposa. <br>\r\nDirigido pelo aclamado Roman Polanski, BUSCA FRENTICA  um thriller de ao e \r\nsuspense de tirar o flego. Prepare-se para muita adrenalina.</p>', 'www.bladerunner.com', 0);
INSERT INTO products_description VALUES (6, 4, 'Matrix', 'Ttulo Original: "The Matrix" <br>\r\n<br>\r\nCdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>\r\nIdioma: Ingls, Alemo. <br>\r\nLegendas: Ingls, Alemo, Espanhol. <br>\r\nAudio: Dolby Surround 5.1. <br>\r\nFormato da Tela: 16:9 Wide-Screen. <br>\r\nDurao: (aprox) 131 minutes. <br>\r\nOutros: Menu interativo, Seleo de captulos, Making Of. <br><br>\r\nSinopse: <br><br>\r\nO que vemos: Nosso dia a dia  verdadeiro. <br>\r\nO que  real: O mundo  uma farsa, construdo por uma das mais poderosas \r\nmquinas com inteligncia artificial para nos controlar. <br>\r\nProezas de tirar o flego. Efeitos alucinantes. Cenas de arrebentar. Keanu \r\nReeves e Laurence Fishburne lutam pela libertao da humanidade em Matrix, um \r\nsuspense ciberntico para ver e rever muitas vezes, escrito e dirigido pelos \r\nIrmos Wachowski (Ligadas pelo Desejo). Uma surpreendente histria, com efeitos \r\nvisuais alucinantes, marcando uma nova era no cinema. Um filme arrasador.</p>', 'www.thematrix.com', 0);
INSERT INTO products_description VALUES (7, 4, 'Mensagem para voc', 'Ttulo Original: &quot;You''ve Got Mail&quot; <br>\r\n<br>\r\nCdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>\r\nIdioma: Ingls, Alemo, Espanhol. <br>\r\nLegendas: Ingls, Alemo, Espanhol, Francs, Nrdico, Polons. <br>\r\nAudio: Dolby Surround 5.1. <br>\r\nFormato da Tela: 16:9 Wide-Screen. <br>\r\nDurao: (aprox) 115 minutes. <br>\r\nOutros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>\r\n<br>\r\nSinopse: MENSAGEM PARA VOC confirma todo romance, charme e emoo que as \r\npessoas poderiam esperar do reencontro das estrelas Tom Hanks e Meg Ryan e da \r\ndiretora Nora Ephron de Sintonia de Amor. Greg Kinnear, Parker Posey, Jean \r\nStapleton e outros coadjuvantes so os ingredientes perfeitos adicionados a este \r\nromance moderno em que o proprietrio magnata de uma super-loja de livros e a \r\ndona de uma aconchegante livraria infantil so correspondentes annimos por \r\ne-mail que se apaixonam perdidamente sem saber que so, na verdade, rivais nos \r\nnegcios</p>', 'www.youvegotmail.com', 0);
INSERT INTO products_description VALUES (8, 4, 'Vida de Inseto', 'Ttulo Original: &quot;A Bug''s Life&quot; <br>\r\n<br>\r\nCdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>\r\nIdioma: Ingls, Alemo. <br>\r\nLegendas: Ingls, Alemo, Espanhol. <br>\r\nAudio: Dolby Surround 5.1. <br>\r\nFormato da Tela: 16:9 Wide-Screen. <br>\r\nDurao: (aprox) 91 minutes. <br>\r\nOutros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>\r\n<br>\r\nSinopse: Entre numa viagem folha a folha dentro do minsculo mundo dos insetos, \r\njunto com os mais diferentes, coloridos e divertidos personagens, na animao \r\ncomputadorizada Disney/Pixar VIDA DE INSETO. <br>\r\nFlik  uma formiga cheia de idias que, em nome dos &quot;insetos oprimidos de todo o \r\nmundo&quot;, precisa contratar guerreiros para defender sua colnia de um faminto \r\nbando de gafanhotos liderado por Hopper. Mas quando descobrem que o exrcito de \r\ninsetos  na verdade um fracassado grupo de atores de um circo de pulgas, o \r\ncenrio est armado para divertidas confuses... com estes improvveis heris.\r\n<br>\r\nEstrelando um elenco de dubladores sensacionais, VIDA DE INSETO apresenta uma \r\nnova e surpreendente viso de trabalho de equipe e determinao, que revela \r\nnovos detalhes cada vez que voc assiste.</p>', 'www.abugslife.com', 0);
INSERT INTO products_description VALUES (9, 4, 'Fora em Alerta', 'Ttulo Original: &quot;Under Siege&quot; <br>\r\n<br>\r\nCdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>\r\nIdioma: Ingls, Alemo. <br>\r\nLegendas: Ingls, Alemo, Espanhol. <br>\r\nAudio: Dolby Surround 5.1. <br>\r\nFormato da Tela: 16:9 Wide-Screen. <br>\r\nDurao: (aprox) 98 minutes. <br>\r\nOutros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>\r\n<br>\r\nSinopse: O encouraado USS Missouri prepara-se para a ltima viagem. A Marinha \r\norganiza uma grande festa. Porm, so surpreendidos com a presena de \r\nterroristas que pretendem roubar o arsenal de armas nucleares do navio e \r\nprovocar a 3a. Guerra Mundial. Com incrvel percia em artes marciais, est a \r\nbordo o cozinheiro Casey Ryback (Steven Seagal, de Nico - Acima da Lei), que \r\nprepara para os terroristas uma receita explosiva. Ele conta com a ajuda da bela \r\ngarota da Playboy Erika Eleniak contra esses bandidos da pesada, que esto sendo \r\nliderados por um ex-agente da CIA (Tommy Lee Jones, de O Cliente) e um oficial \r\nque trai a Marinha (Gary Busey, de Mquina Mortfera).</p>', '', 0);
INSERT INTO products_description VALUES (10, 4, 'Fora em Alerta 2', 'Ttulo Original: &quot;Under Siege 2 - Dark Territory&quot; <br>\r\n<br>\r\nCdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>\r\nIdioma: Ingls, Alemo. <br>\r\nLegendas: Ingls, Alemo, Espanhol. <br>\r\nAudio: Dolby Surround 5.1. <br>\r\nFormato da Tela: 16:9 Wide-Screen. <br>\r\nDurao: (aprox) 98 minutes. <br>\r\nOutros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>\r\n<br>\r\nSinopse: O manaco Travis Dane (Eric Bogosian) sequestrou um luxuoso trem de \r\npassageiros e o transformou em um centro de comando de alta tecnologia, capaz de \r\ncontrolar um poderoso satlite americano. Seu plano: destruir a Costa Leste dos \r\nEstados Unidos. Seu alvo: um reator nuclear, localizado nos subterrneos do \r\nPentgono. Seu preo: um bilho de dlares. Seu problema: Casey Ryback (Steven \r\nSeagal, de A Fora em Alerta) um dos passageiros a bordo do trem. \r\nEx-especialista da marinha, Casey  uma arma letal de combate. <br>\r\nCom o trem se dirigindo a um territrio selvagem, onde todos os tipos de \r\ncomunicao externa so naturalmente interrompidos, a vida de trs milhes de \r\npessoas depende das habilidade mortais de Ryback, que enfrentar sozinho Travis \r\ne seus perigosos terroristas</p>', '', 0);
INSERT INTO products_description VALUES (11, 4, 'Ameaa Subterrnea', 'Ttulo Original: &quot;Fire Down Below&quot; <br>\r\n<br>\r\nCdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>\r\nIdioma: Ingls, Alemo. <br>\r\nLegendas: Ingls, Alemo, Espanhol. <br>\r\nAudio: Dolby Surround 5.1. <br>\r\nFormato da Tela: 16:9 Wide-Screen. <br>\r\nDurao: (aprox) 104 minutes. <br>\r\nOutros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>\r\nSinopse: O Agente Federal de proteo ambiental Jack Taggart (Steven Seagal, de \r\nA Fora em Alerta) est investigando a morte de um colega. Seguindo as pistas \r\ndeixadas pelo agente assassinado, Jack parte em viagem pelas pequenas \r\ncomunidades ruais do Kentucky. Em pouco tempo, ele descobre que toneladas de \r\nresiduos txicos esto sendo despejadas nas antigas minas de carvo da regio. \r\nMuitos habitantes locais esto ficando doentes, mas os criminosos esto \r\nprotegidos pelo silncio de uma cidade dominada pelo medo. Taggart descobre \r\ninformaes importantes conta o poderoso minerador Orin Hanner (Kris \r\nKristofferson, de Rodeio da Vida) e decide enfrent-lo antes que uma catstrofe \r\necolgica destrua completamente a regio.', '', 0);
INSERT INTO products_description VALUES (12, 4, 'Duro de Matar', 'Cdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>\r\nIdioma: Ingls, Alemo. <br>\r\nLegendas: Ingls, Alemo, Espanhol. <br>\r\nAudio: Dolby Surround 5.1. <br>\r\nFormato da Tela: 16:9 Wide-Screen. <br>\r\nDurao: (aprox) 122 minutes. <br>\r\nOutros: Menu Interativo, Seleo de Captulos, Legendas (Mais idiomas). <br>\r\n<br>\r\nEm Nova York, o terrorista Simon (Jeremy Irons) explode uma bomba dentro de um \r\nshopping lotado. John Mc Lane (Bruce Willis) corre contra o tempo, desvendando \r\ncharadas propostas pelo vilo. <br>\r\nGRAHAM GREENE BRUCE WILLIS SAMUEL L. JACKSON COLLEEN CAMP LARRY BRYGGMAN SAM \r\nPHILLIPS JEREMY IRONS', '', 0);
INSERT INTO products_description VALUES (13, 4, 'Mquina Mortfera', 'Ttulo Original: &quot;Lethal Weapon&quot; <br>\r\n<br>\r\nCdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>\r\nIdioma: Ingls, Alemo. <br>\r\nLegendas: Ingls, Alemo, Espanhol. <br>\r\nAudio: Dolby Surround 5.1. <br>\r\nFormato da Tela: 16:9 Wide-Screen. <br>\r\nDurao: (aprox) 100 minutes. <br>\r\nOutros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>\r\n<br>\r\nSinopse:Martin Riggs (Mel Gibson, da famosa srie Mad Max) no  um policial \r\ncomum.  um Mad Max que se tornou manaco, um homem cuja destreza para matar e \r\ntendncias suicidas o tranformam numa Mquina Mortfera para qualquer um que \r\nesteja tanto contra como a seu favor. Roger Murtaugh (Danny Glover, de A Cor \r\nPrpura)  um tranqilo detetive de homicdios, que ama sua famlia, tem uma \r\nbela casa, e espera uma boa aposentadoria que no quer perder. Imagine o susto \r\nde Murtaugh quando descobre que seu novo parceiro ser algum que no tenha nada \r\na perder: o desvairado e desprezado Martin Riggs.', '', 0);
INSERT INTO products_description VALUES (14, 4, 'Justia Vermelha', 'Ttulo Original: &quot;Red Corner&quot; <br>\r\n<br>\r\nCdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>\r\nIdioma: Ingls, Alemo. <br>\r\nLegendas: Ingls, Alemo, Espanhol. <br>\r\nAudio: Dolby Surround 5.1. <br>\r\nFormato da Tela: 16:9 Wide-Screen. <br>\r\nDurao: (aprox) 117 minutes. <br>\r\nOutros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>\r\n<br>\r\nSinopse: <br>\r\nNa histria, Richard Gere interpreta Jack Moore, um brilhante advogado de um \r\ngrande conglomerado de entretenimento e o melhor negociador que o Ocidente tem \r\npara oferecer. Ele est na China para fechar o primeiro contrato de comunicao \r\nde satlites sancionado pelo governo chins mas, aps uma noite com uma mulher \r\nextica, se v envolvido numa trama que pe sua vida em jogo. Preso por um \r\nassassinato que no cometeu e abandonado por seus colegas de trabalho \r\namericanos, Jack precisa encontrar uma sada desse labirinto conhecido como \r\nsistema judicial chins. Diferente da Amrica, um culpado por ofensa capital na \r\nChina  morto no perodo de uma semana aps a sua sentena e o custo da munio \r\n cobrado  sua famlia; um julgamento nesse pas dura, em mdia, menos de \r\nquatro horas, e o grau de convico beira os 99%. <br>\r\nA nica chance de Jack  sua advogada de defesa, Shen Yuelin (Bai Ling), \r\napontada pela corte. Imediatamente, ela entra com uma declarao de culpa \r\ninsistindo ser a nica forma de salvar a vida de seu cliente - &quot;clemncia \r\nqueles que confessam; severidade queles que resistem&quot;. <br>\r\nEla acredita na inocncia de Jack e, ao se comprometer em salv-lo dentro de um \r\nsistema imperdovel, est se comprometendo a sacrificar sua vida. Trabalhando \r\njuntos, apesar das grandes diferenas culturais, os dois comeam a descobrir \r\nevidncias bizarras do envolvimento de membros do alto escalo do governo.</p>', '', 0);
INSERT INTO products_description VALUES (16, 4, 'Coragem Sob Fogo', 'Ttulo Original: &quot;Courage Under Fire&quot; <br>\r\n<br>\r\nCdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>\r\nIdioma: Ingls, Alemo. <br>\r\nLegendas: Ingls, Alemo, Espanhol. <br>\r\nAudio: Dolby Surround 5.1. <br>\r\nFormato da Tela: 16:9 Wide-Screen. <br>\r\nDurao: (aprox) 112 minutes. <br>\r\nOutros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>\r\n<br>\r\nSinopse: <br>\r\n&quot;Em tempo de guerra, a primeira baixa  sempre a verdade.&quot; <br>\r\nJaneiro de 1991. O mundo est assistindo  Guerra do Golfo dia e noite, milhes \r\nde pessoas sintonizam a CNN para ver a vida real e o drama da morte nas cidades \r\ne desertos do Iraque. <br>\r\nComo o Exrcito americano ocupa um lugar de destaque na trama, o Departamento de \r\nRelaes Pblicas da Casa Branca est trabalhando alm da conta. O que eles \r\nesto procurando  um heri. O que eles encontram  um escndalo. O que um \r\noficial encrencado agora precisa encobrir  a verdade.</p>', '', 0);
INSERT INTO products_description VALUES (17, 4, 'Velocidade Mxima', 'Ttulo Original: &quot;Speed&quot; <br>\r\n<br>\r\nCdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>\r\nIdioma: Ingls, Alemo. <br>\r\nLegendas: Ingls, Alemo, Espanhol. <br>\r\nAudio: Dolby Surround 5.1. <br>\r\nFormato da Tela: 16:9 Wide-Screen. <br>\r\nDurao: (aprox) 112 minutes. <br>\r\nOutros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>\r\n<br>\r\nSinopse: Prepare-se para uma sequncia de emoes vibrantes, cenas de ao de \r\ntirar o flego e um romance inesperado, num filme que voc vai querer ver muitas \r\nvezes. Keanu Reeves  Jack Traven, um especialista da equipe SWAT da polcia de \r\nLos Angeles que  enviado para desarmar uma bomba colocada num nibus por um \r\nmanaco vingativo (Dennis Hopper). Jack e a passageira Sandra Bullock tm que \r\nmanter o nibus a mais de 80 km/h ou a bomba explodir. Uma perseguio cheia de \r\nsuspense, ao e reviravoltas que vai deixar voc com os olhos grudados na tela.</p>', '', 0);
INSERT INTO products_description VALUES (18, 4, 'Velocidade Mxima 2', 'Ttulo Original: &quot;Speed 2: Cruise Control&quot; <br>\r\n<br>\r\nCdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>\r\nIdioma: Ingls, Alemo. <br>\r\nLegendas: Ingls, Alemo, Espanhol. <br>\r\nAudio: Dolby Surround 5.1. <br>\r\nFormato da Tela: 16:9 Wide-Screen. <br>\r\nDurao: (aprox) 120 minutes. <br>\r\nOutros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>\r\n<br>\r\nSinopse:Agarre-se ao seu salva-vidas quando a super sequncia de Velocidade \r\nMxima atingir o alto-mar. Sandra Bullock revive o papel que a transformou em \r\nestrela como Annie Porter, uma jovem mulher esperando divertir-se em frias no \r\nCaribe ao lado do seu namorado (Jason Patric) a bordo do transatlntico mais \r\nluxuoso do mundo. Mas sua viagem ao paraso torna-se mortal quando um luntico \r\ngnio de computadores (Willem Dafoe) assume o controle do navio e o coloca numa \r\nrota de destruio. Uma viagem explosiva conduzida pelo audacioso diretor Jan De \r\nBont (Velocidade Mxima, Twister), VELOCIDADE MXIMA 2 navega nas ondas \r\nselvagens em velocidade alucinante.</p>', '', 0);
INSERT INTO products_description VALUES (19, 4, 'Quem vai ficar com Mary?', 'Ttulo Original: &quot;There''s Something About Mary&quot; <br>\r\n<br>\r\nCdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>\r\nIdioma: Ingls, Alemo. <br>\r\nLegendas: Ingls, Alemo, Espanhol. <br>\r\nAudio: Dolby Surround 5.1. <br>\r\nFormato da Tela: 16:9 Wide-Screen. <br>\r\nDurao: (aprox) 114 minutes. <br>\r\nOutros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>\r\n<br>\r\nSinopse: Uma comdia romntica com muitas gozaes sobre a maneira como os \r\njovens se apaixonam e as dificuldades de lidar com o amor... <br>\r\nApaixonado desde os tempos do curso colegial por Mary (Cameron Diaz), o \r\ntrapalho Ted (Ben Stiller) localiza de novo a gata de seus sonhos treza anos \r\nmais tarde com a ajuda de um investigador particular muito pilantra (Matt Dillon), \r\nque tambm se apaixona por ela. Para complicar ainda mais as coisas, os dois \r\ndescobrem que qualquer homem que conhea a deslumbrante Mary fica doido para se \r\ncasar com ela. Mais um grande xito da famosa dupla de diretores, os irmos \r\nBobby e Peter Farrelly, que j fizeram grande sucesso com Dbi &amp; Lide.</p>', '', 0);
INSERT INTO products_description VALUES (20, 4, 'Bem Amada', 'Ttulo Original: &quot;Beloved&quot; <br>\r\n<br>\r\nCdigo Regional: 2 (Japo, Europa, Oriente Mdio, frica do Sul). <br>\r\nIdioma: Ingls, Alemo. <br>\r\nLegendas: Ingls, Alemo, Espanhol. <br>\r\nAudio: Dolby Surround 5.1. <br>\r\nFormato da Tela: 16:9 Wide-Screen. <br>\r\nDurao: (aprox) 164 minutes. <br>\r\nOutros: Menu interativo, Seleo de captulos, Legendas (mais idiomas). <br>\r\n<br>\r\nSinopse:<br>\r\nBaseado em um romance da vencedora do prmio Nobel Toni Morrison, Bem Amada (Beloved) \r\n um grande afresco histrico da Amrica do Norte escravagista no fim do sculo \r\nXIX. A popular apresentadora de TV Oprah Winfrey interpreta a protagonista, \r\nSethe, uma ex-escrava que tenta levar uma vida normal ao lado da voluntariosa \r\nfilha Denver (Kimberly Elise). Atormentada por segredos inconfessveis de seu \r\npassado, ela encontra no velho amigo Paul D (Danny Glover) um consolo para seu \r\nsofrimento interior. Thandie Newton encarna a personagem que d nome ao filme. \r\nBeloved  uma presena misteriosa, cuja influncia malfica ir desequilibrar a \r\nexistncia de todos  sua volta.</p>', '', 0);
INSERT INTO products_description VALUES (21, 4, 'SWAT 3: Close Quarters Battle', 'Los Angeles 2005. Representantes de todas as naes do mundo estaro reunidos \r\npara testemunhar a assinatura do Tratado de Desarmamento Nuclear das Naes \r\nUnidas. A proteo desses homens contra os ataques implacveis de foras \r\nterroristas caber  SWAT. O destino de muitas vidas est em suas mos.<br>\r\n<br>\r\nDestaques<br>\r\n<br>\r\nTeste sua coragem em 21 misses intensas - todas em locais reais de Los Angeles. \r\nA vida de pessoas inocentes e a captura dos terroristas dependem de voc e de \r\nsua equipe.<br>\r\n<br>\r\nJogue no modo cooperativo ou de combate mortal contra at cinco jogadores, em \r\nrede ou via Internet. Personalize tudo, de armas e skins ao nmero e tipos de \r\nadversrios e refns.<br>\r\n<br>\r\nColoque  prova sua imaginao. Crie novos nveis ou mude os que j existem. \r\nRecrie conflitos da vida real e rescreva a histria da cidade. Instale \r\nmodificaes rapidamente usando o MOD Selector.', 'www.swat3.com', 0);
INSERT INTO products_description VALUES (22, 4, 'Torneio irreal', 'Ttulo Original: &quot;Unreal Tournament&quot; <br>\r\n<br>\r\nO jogo Single player  emoo do comeo ao fim, que vai fazer voc cerrar os \r\npunhos enquanto os tiros vm de todos os lados! Comande sua equipe de \r\nguerrilheiros virtuais &quot;bots&quot; contra os mais mortais gladiadores virtuais da \r\ngalxia e torne-se o Grande Mestre do Unreal. Ao Multiplayer de arrepiar a \r\nespinha. Seja ou no On-line. Arrase com todo mundo, bots ou humanos, em novos \r\nmodos de jogo: Capturar bandeira, Ataque, Dominao e novas variaes de \r\nCombates Mortais que no requerem acesso  Internet.<br>\r\n<br>\r\n50 Nveis de batalha, verdadeiras obras de arte. Um galeo, tumbas egpcias, \r\nsubmarinos, trens de alta velocidade, castelos espaciais e muito mais ! Tudo \r\nisso pode ser jogado on-line ou no e nos modos para um ou vrios jogadores. \r\nEsses nveis elevam o padro dos ambientes de ao 3D<br>\r\n<br>\r\nImagens e sons alm da realidade. Texturas super detalhadas criam mundos \r\nfantsticos. Suporta as placas 3D de ltima gerao, mas no exige placa 3D.<br>\r\n<br>\r\nArsenal Detonante, totalmente novo e aperfeioado, uma garantia de que vai rolar \r\nmuito sangue ! Mais de 10 armas - cada uma com dois modos de tiro - a sua \r\ndisposio.<br>\r\n<br>\r\nTome controle do jogo.Treine no modo novato e use os nveis tutoriais para \r\narrasar em combate. Se voc quiser mais velocidade, mais dano, mais intensidade \r\ne mais tudo... tente o modo Hardcore.', 'www.unrealtournament.net', 0);
INSERT INTO products_description VALUES (23, 4, 'A Roda do Tempo', 'Ttulo Original: &quot;The Wheel Of Time&quot; <br>\r\n<br>\r\nDas pginas dos best-sellers de Robert Jordan para as telas dos PCs, The Wheel \r\nof Time conta a histria da busca dos quatro selos mgicos utilizados para \r\naprisionar &quot;O Obscuro&quot;, uma entidade das trevas com poder suficiente para \r\ndestruir o mundo. <br>\r\n<br>\r\nPara recuperar esses selos, voc dever se envolver em uma trama de intrigas e \r\ntraies no papel de Elayna Sedai, Guardi das Crnicas da Torre Branca. Em The \r\nWheel of Time, voc percorrer 18 nveis de jogo, unidos por belssimas cenas de \r\nanimao que contam esta fascinante histria de aventura pica. A histria que \r\nse desenrola, pouco a pouco,  medida que ocorre a ao, tendo como objetivo \r\nrecuperar os selos mgicos roubados da Torre Branca por foras malignas. <br>\r\n<br>\r\nUm Fantstico modo de jogo single palyer, que permite viajar por 15 mundos em \r\numa jornada para encontrar os selos msticos, com a possibilidade de utilizar \r\nmais de 40 magias e artefatos de poder inimaginvel, como bolas de fogo, \r\nrelmpagos, disfarces, levitao, etc. <br>\r\n<br>\r\nVisuais espetaculares criados por uma verso aprimorada do poderoso engine do \r\nUnreal. Chamas iluminam o cenrio e gotas de chuva caem, agitando poas de gua \r\ncom realismo jamais visto. Ambientes belssimos e cenrios monumentais \r\ninspirados na arte gtica trazem inigualveis detalhes arquitetnicos, realados \r\npor incrveis efeitos especiais. <br>\r\n&nbsp;', 'www.wheeloftime.com', 0);
INSERT INTO products_description VALUES (24, 4, 'A Terra Sagrada', 'Ttulo original: &quot;Disciples: Sacred Lands&quot; <br>\r\n<br>\r\nUma nova era esta nascendo...<br>\r\n<br>\r\nEntre no reino das terras sagradas, onde o nascer da nova era encontra-se nos \r\nmaiores momentos da guerra. Como prev a profecia, quatro raas confrontam-se \r\ncom espadas e feitiaria numa perigosa disputa pelo controle do destino dos seus \r\nDeuses. Enfrente a busca como o campeo do Imprio, cl das montanhas, legio \r\ndos malditos, ou multido dos mortos-vivos e teste sua f nas batalhas de fora, \r\nenfeitiando e atuando com malcia matando demnios, vencendo gigantes e \r\ncombatendo sem misericrdia as foras dos mortos e dos mortos-vivos. Mas a \r\nsegurana da salvao do seu Deus deve envolver o heri dentro de voc.<br>\r\n&nbsp;', '', 0);
INSERT INTO products_description VALUES (25, 4, 'Microsoft Internet Keyboard PS/2', '<p>Acesso  Internet com um toque e muito mais! O Internet Keyboard possui dez \r\nteclas de acesso em um design de teclado padro confortvel que tambm traz um \r\ndescanso para mos destacvel. As teclas de acesso permitem navegar na Web ou \r\nverificar correio eletrnico diretamente de seu teclado. O software IntelliType \r\nPro tambm permite personalizar suas teclas de acesso  trabalhe com o Internet \r\nKeyboard da maneira que preferir! <br>\r\n<br>\r\nBenefcios <br>\r\nDez teclas de acesso permitem que voc tenha maior controle sobre seu PC - \r\nAcesse a Internet, seu correio eletrnico e os programas favoritos diretamente \r\nde seu teclado. <br>\r\nAlta qualidade, alto valor  O Microsoft Internet Keyboard  um teclado de alta \r\nqualidade, feito para durar e tem garantia de 3 anos pela PHPmania. <br>\r\nDescanso para mos destacvel - O confortvel descanso para mos serve de apoio \r\npara os antebraos e pode ser removido para aumentar o espao na mesa. <br>\r\nExecute tarefas comuns rapidamente como Recortar, Copiar e Colar com a ajuda dos \r\natalhos da tecla Control.</p>', '', 0);
INSERT INTO products_description VALUES (26, 4, 'Microsoft IntelliMouse Explorer', 'O primeiro avano realmente importante na tecnologia dos mouses desde a \r\ndcada de 60.<br>\r\nO IntelliMouse com IntelliEye ultrapassou toda a antiga tecnologia mecnica \r\nusada nos mouses atuais. Este mouse usa um novo sensor ptico que rastreia a \r\nsuperfcie abaixo do mouse 1.500 vezes por segundo para registrar com preciso e \r\nregularidade os mnimos movimentos. Ele funciona em centenas de superfcies (ou \r\nseja, chega de mouse pad) e permanece "preciso como novo" porque no existem \r\npeas mveis que se desgastam ou retm sujeira. <br>\r\n<br>\r\nBenefcios<br>\r\n<br>\r\nPreciso - O sensor ptico preciso do IntelliEye registra os movimentos sobre \r\nqualquer tipo de superfcie. O sensor precisa apenas de uma superfcie com um \r\npequeno volume de detalhes, o que inclui madeira, plstico ou at o tecido de \r\nsua cala. <br>\r\nNavegao mais fcil na Internet - Os dois botes do polegar atuam com botes de \r\navanar e voltar no seu navegador. <br>\r\nPreciso - Nada de partes mveis, e portanto seu mouse est sempre suave e \r\npreciso, no sendo necessrio usar um mouse pad. <br>\r\nAcomoda-se muito bem  sua mo - Este mouse foi desenvolvido para dar apoio  \r\nsua mo e seus dedos. As laterais emborrachadas facilitam prender o mouse entre \r\nos dedos e o deixam mais confortvel de usar, pois ele exige menos esforo para \r\nsegurar. <br>\r\nGarantia - O IntelliMouse Explorer vem com garantia limitada de hardware de 5 \r\nanos pela PHPmania.org.</p>', 'www.microsoft.com/hardware/mouse/explorer.asp', 0);
INSERT INTO products_description VALUES (27, 4, 'Hewlett Packard LaserJet 1100Xi', 'A PHPmania est sempre na frente na tecnologia de impresso a laser. A nova \r\ngerao HP LaserJet 1100, marca outra srie impressionante no ritmo de impresso \r\ne velocidade, sendo de 8 pginas por minuto. Imprimir em uma resoluo de 600 \r\ndpi, com tecnologia de resoluo avanada (Resolution Enhancement technology - \r\nREt) HP faz todos os documentos mais profissionais, aumentando a velocidade de \r\nimpresso e a qualidade a laser, resultam apenas no comeo com 2MB de memria.<br>\r\n<br>\r\nUsurios da HP LaserJet 1100xi sero capazes de imprimir pginas cada vez mais \r\ncomplexas, a memria  expansvel para at 18MB, facilitando a impresso de \r\ndocumentos mais complexos. A HP LaserJet 1100xi suporta as plataformas Windows \r\n3.1, 3.11, 95, 98, ME, XP. Compatibilidade de rede atravs do HP JetDirect \r\nExternal Print Servers.<br>\r\n<br>\r\nHP LaserJet 1100xi tambm pode criar documentos para a Web Era da Trellix Corp. \r\n(Oferencendo um software que  capaz de criar documentos web).</p>', 'www.pandi.hp.com/pandi-db/prodinfo.main?product=laserjet1100', 0);

INSERT INTO products_notifications VALUES (0, 3, '2004-10-03 19:00:49');
INSERT INTO products_notifications VALUES (2, 3, '2004-10-03 20:31:28');
INSERT INTO products_options VALUES (1, 4, 'Cor');
INSERT INTO products_options VALUES (2, 4, 'Size');
INSERT INTO products_options VALUES (3, 4, 'Modelo');
INSERT INTO products_options VALUES (4, 4, 'Memoria');
INSERT INTO products_options VALUES (5, 4, 'Verso');
INSERT INTO products_options_values VALUES (1, 4, '4 mb');
INSERT INTO products_options_values VALUES (2, 4, '8 mb');
INSERT INTO products_options_values VALUES (3, 4, '16 mb');
INSERT INTO products_options_values VALUES (4, 4, '32 mb');
INSERT INTO products_options_values VALUES (5, 4, 'Value');
INSERT INTO products_options_values VALUES (6, 4, 'Premium');
INSERT INTO products_options_values VALUES (7, 4, 'Deluxe');
INSERT INTO products_options_values VALUES (8, 4, 'PS/2');
INSERT INTO products_options_values VALUES (9, 4, 'USB');
INSERT INTO products_options_values VALUES (10, 4, 'Download: Windows - English');
INSERT INTO products_options_values VALUES (13, 4, 'Box: Windows - English');
INSERT INTO products_options_values_to_products_options VALUES (1, 4, 1);
INSERT INTO products_options_values_to_products_options VALUES (2, 4, 2);
INSERT INTO products_options_values_to_products_options VALUES (3, 4, 3);
INSERT INTO products_options_values_to_products_options VALUES (4, 4, 4);
INSERT INTO products_options_values_to_products_options VALUES (5, 3, 5);
INSERT INTO products_options_values_to_products_options VALUES (6, 3, 6);
INSERT INTO products_options_values_to_products_options VALUES (7, 3, 7);
INSERT INTO products_options_values_to_products_options VALUES (8, 3, 8);
INSERT INTO products_options_values_to_products_options VALUES (9, 3, 9);
INSERT INTO products_options_values_to_products_options VALUES (10, 5, 10);
INSERT INTO products_options_values_to_products_options VALUES (13, 5, 13);
INSERT INTO products_to_categories VALUES (1, 4);
INSERT INTO products_to_categories VALUES (2, 4);
INSERT INTO products_to_categories VALUES (3, 9);
INSERT INTO products_to_categories VALUES (4, 10);
INSERT INTO products_to_categories VALUES (5, 11);
INSERT INTO products_to_categories VALUES (6, 10);
INSERT INTO products_to_categories VALUES (7, 12);
INSERT INTO products_to_categories VALUES (8, 13);
INSERT INTO products_to_categories VALUES (9, 10);
INSERT INTO products_to_categories VALUES (10, 10);
INSERT INTO products_to_categories VALUES (11, 10);
INSERT INTO products_to_categories VALUES (12, 10);
INSERT INTO products_to_categories VALUES (13, 10);
INSERT INTO products_to_categories VALUES (14, 15);
INSERT INTO products_to_categories VALUES (16, 15);
INSERT INTO products_to_categories VALUES (17, 10);
INSERT INTO products_to_categories VALUES (18, 10);
INSERT INTO products_to_categories VALUES (19, 12);
INSERT INTO products_to_categories VALUES (20, 15);
INSERT INTO products_to_categories VALUES (21, 18);
INSERT INTO products_to_categories VALUES (22, 19);
INSERT INTO products_to_categories VALUES (23, 20);
INSERT INTO products_to_categories VALUES (24, 20);
INSERT INTO products_to_categories VALUES (25, 8);
INSERT INTO products_to_categories VALUES (26, 9);
INSERT INTO products_to_categories VALUES (27, 5);
INSERT INTO sessions VALUES ('2d6d2c9a673c4f7cd259d0da5834c561', 1098840383, 'language|s:9:"portugues";languages_id|s:1:"4";selected_box|s:5:"tools";current_path|s:32:"/home/phpmania/public_html/loja/";');
INSERT INTO sessions VALUES ('fd71cc2765e92aaeef0b028575ed4512', 1098840403, 'cart|O:12:"shoppingcart":5:{s:8:"contents";a:1:{i:5;a:1:{s:3:"qty";i:1;}}s:5:"total";d:30;s:6:"weight";d:1;s:6:"cartID";s:5:"90694";s:12:"content_type";s:8:"physical";}language|s:9:"portugues";languages_id|s:1:"4";currency|s:2:"BR";navigation|O:17:"navigationhistory":2:{s:4:"path";a:8:{i:0;a:4:{s:4:"page";s:9:"index.php";s:4:"mode";s:6:"NONSSL";s:3:"get";a:0:{}s:4:"post";a:0:{}}i:1;a:4:{s:4:"page";s:18:"create_account.php";s:4:"mode";s:6:"NONSSL";s:3:"get";a:0:{}s:4:"post";a:18:{s:6:"action";s:7:"process";s:6:"gender";s:1:"m";s:9:"firstname";s:4:"beto";s:8:"lastname";s:3:"bbs";s:3:"dob";s:10:"21/06/1975";s:13:"email_address";s:17:"phpmania@mail.com";s:14:"street_address";s:23:"sqs 310 bloco a casa 20";s:6:"suburb";s:7:"asa sul";s:8:"postcode";s:8:"70866160";s:4:"city";s:14:"belo horizonte";s:5:"state";s:12:"Minas Gerais";s:7:"country";s:2:"30";s:9:"telephone";s:5:"12345";s:3:"fax";s:5:"12345";s:8:"password";s:5:"12345";s:12:"confirmation";s:5:"12345";s:1:"x";s:2:"66";s:1:"y";s:2:"13";}}i:2;a:4:{s:4:"page";s:26:"create_account_success.php";s:4:"mode";s:6:"NONSSL";s:3:"get";a:0:{}s:4:"post";a:0:{}}i:3;a:4:{s:4:"page";s:16:"product_info.php";s:4:"mode";s:6:"NONSSL";s:3:"get";a:2:{s:11:"products_id";s:1:"5";s:6:"action";s:11:"add_product";}s:4:"post";a:3:{s:11:"products_id";s:1:"5";s:1:"x";s:2:"72";s:1:"y";s:1:"7";}}i:4;a:4:{s:4:"page";s:17:"shopping_cart.php";s:4:"mode";s:6:"NONSSL";s:3:"get";a:0:{}s:4:"post";a:0:{}}i:5;a:4:{s:4:"page";s:21:"checkout_shipping.php";s:4:"mode";s:6:"NONSSL";s:3:"get";a:0:{}s:4:"post";a:5:{s:6:"action";s:7:"process";s:8:"shipping";s:15:"regions_regions";s:8:"comments";s:0:"";s:1:"x";s:2:"48";s:1:"y";s:2:"13";}}i:6;a:4:{s:4:"page";s:20:"checkout_payment.php";s:4:"mode";s:6:"NONSSL";s:3:"get";a:0:{}s:4:"post";a:0:{}}i:7;a:4:{s:4:"page";s:25:"checkout_confirmation.php";s:4:"mode";s:6:"NONSSL";s:3:"get";a:0:{}s:4:"post";a:4:{s:7:"payment";s:13:"transferencia";s:8:"comments";s:0:"";s:1:"x";s:2:"79";s:1:"y";s:1:"6";}}}s:8:"snapshot";a:0:{}}customer_id|i:7;customer_first_name|s:4:"beto";customer_default_address_id|i:7;customer_country_id|s:2:"30";customer_zone_id|s:2:"74";sendto|i:7;cartID|s:5:"90694";comments|s:0:"";shipping|a:3:{s:2:"id";s:15:"regions_regions";s:5:"title";s:87:"Entrega Via Sedex (Prazo de entrega dos Correios  de 2 dias teis para Minas Gerais  )";s:4:"cost";d:14;}billto|i:7;payment|s:13:"transferencia";');
INSERT INTO specials VALUES (1, 3, 39.9900, '2004-10-03 10:13:34', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);
INSERT INTO specials VALUES (2, 5, 30.0000, '2004-10-03 10:13:34', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);
INSERT INTO specials VALUES (3, 6, 30.0000, '2004-10-03 10:13:34', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);
INSERT INTO specials VALUES (4, 16, 29.9900, '2004-10-03 10:13:34', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);
INSERT INTO tax_class VALUES (1, 'Taxable Goods', 'The following types of products are included non-food, services, etc', '2004-10-03 10:13:34', '2004-10-03 10:13:34');
INSERT INTO tax_rates VALUES (1, 0, 1, 0, 0.0000, '', '2004-10-25 19:18:49', '2004-10-03 10:13:34');
INSERT INTO whos_online VALUES (7, '', 'fd71cc2765e92aaeef0b028575ed4512', '200.140.15.223', '1098838962', '1098838962', '/loja/checkout_confirmation.php');
INSERT INTO zones VALUES (62, 30, 'AC', 'Acre');
INSERT INTO zones VALUES (63, 30, 'AL', 'Alagoas');
INSERT INTO zones VALUES (64, 30, 'AP', 'Amapa');
INSERT INTO zones VALUES (65, 30, 'AM', 'Amazonas');
INSERT INTO zones VALUES (66, 30, 'BA', 'Bahia');
INSERT INTO zones VALUES (67, 30, 'CE', 'Ceara');
INSERT INTO zones VALUES (68, 30, 'DF', 'Distrito Federal');
INSERT INTO zones VALUES (69, 30, 'ES', 'Espirito Santo');
INSERT INTO zones VALUES (70, 30, 'GO', 'Goias');
INSERT INTO zones VALUES (71, 30, 'MA', 'Maranhao');
INSERT INTO zones VALUES (72, 30, 'MT', 'Mato Grosso');
INSERT INTO zones VALUES (73, 30, 'MS', 'Mato Grosso do Sul');
INSERT INTO zones VALUES (74, 30, 'MG', 'Minas Gerais');
INSERT INTO zones VALUES (75, 30, 'PA', 'Para');
INSERT INTO zones VALUES (76, 30, 'PB', 'Paraiba');
INSERT INTO zones VALUES (77, 30, 'PR', 'Parana');
INSERT INTO zones VALUES (78, 30, 'PE', 'Pernambuco');
INSERT INTO zones VALUES (79, 30, 'PI', 'Piaui');
INSERT INTO zones VALUES (80, 30, 'RJ', 'Rio de Janeiro');
INSERT INTO zones VALUES (81, 30, 'RN', 'Rio Grande do Norte');
INSERT INTO zones VALUES (82, 30, 'RS', 'Rio Grande do Sul');
INSERT INTO zones VALUES (83, 30, 'RO', 'Rondonia');
INSERT INTO zones VALUES (84, 30, 'RR', 'Roraima');
INSERT INTO zones VALUES (85, 30, 'SC', 'Santa Catarina');
INSERT INTO zones VALUES (86, 30, 'SP', 'Sao Paulo');
INSERT INTO zones VALUES (87, 30, 'SE', 'Sergipe');
INSERT INTO zones VALUES (88, 30, 'TO', 'Tocantins');





