<?php
require_once("includes/application_top.php");
require_once(DIR_WS_CLASSES . 'order.php');
$order = new order;

$query_order = tep_db_query("select customers_name, customers_email_address, orders_id from " . TABLE_ORDERS . " order by orders_id desc limit 1");
$order_array = tep_db_fetch_array($query_order);

require_once("WSMicroPayment.php");
// Inicia a classe WSMicroPayment
$WSMicroPayment = new WSMicroPayment();

// Cria o cabealho SOAP
$xmlObj = $WSMicroPayment->add_node("","soap-env:Envelope");
$WSMicroPayment->add_attributes($xmlObj, array("xmlns:soap-env" => "http://schemas.xmlsoap.org/soap/envelope/") );
$xmlObj = $WSMicroPayment->add_node($xmlObj,"soap-env:Body");

// Cria  o elemento m:F2bMicropagamento
$xmlObjF2bMicropagamento = $WSMicroPayment->add_node($xmlObj,"m:F2bMicropagamento");
$WSMicroPayment->add_attributes($xmlObjF2bMicropagamento, array("xmlns:m" => "http://www.f2b.com.br/soap/wsmicropayment.xsd") );

// Cria o elemento mensagem
$xmlObj = $WSMicroPayment->add_node($xmlObjF2bMicropagamento,"mensagem");
$WSMicroPayment->add_attributes($xmlObj, array("data" => date("Y-m-d"),
                                          "numero" => date("His")));

// Cria o elemento sacador
$xmlObj = $WSMicroPayment->add_node($xmlObjF2bMicropagamento,"sacador");

$WSMicroPayment->add_attributes($xmlObj, array("conta" => MODULE_PAYMENT_MICROPAGAMENTOF2B_ID,
                                          "senha" => MODULE_PAYMENT_MICROPAGAMENTOF2B_PASSWORD));
$WSMicroPayment->add_content($xmlObj,MODULE_PAYMENT_MICROPAGAMENTOF2B_SACADOR);

// Cria o elemento micropagamento
$xmlObjF2bMicropagamento = $WSMicroPayment->add_node($xmlObjF2bMicropagamento,"micropagamento");
$WSMicroPayment->add_attributes($xmlObjF2bMicropagamento, array("valor" => $order->info['total']));

// Cria o elemento pedido
$xmlObj = $WSMicroPayment->add_node($xmlObjF2bMicropagamento,"pedido");
$WSMicroPayment->add_content($xmlObj,$order_array['orders_id']+1);

// Cria o elemento ip_autenticacao
$xmlObj = $WSMicroPayment->add_node($xmlObjF2bMicropagamento,"ip_autenticacao");
$WSMicroPayment->add_content($xmlObj, $REMOTE_ADDR);

// Cria o elemento url_retorno
$xmlObj = $WSMicroPayment->add_node($xmlObjF2bMicropagamento,"url_retorno");
$WSMicroPayment->add_content($xmlObj,MODULE_PAYMENT_MICROPAGAMENTOF2B_URLRETURN);

// Cria o elemento cod_verificacao
$xmlObj = $WSMicroPayment->add_node($xmlObjF2bMicropagamento,"cod_verificacao");
$WSMicroPayment->add_content($xmlObj,$order->customer['email_address']);

// envia dados
$WSMicroPayment->send($WSMicroPayment->getXML());
$resposta = $WSMicroPayment->resposta;

if(strlen($resposta) > 0){
	// Reinicia a classe WSMicroPayment, agora com uma string XML
	$WSMicroPayment = new WSMicroPayment($resposta);

	// LOG
	$log = $WSMicroPayment->pegaLog();
	// Cdigo do Resultado
	$cod_resultado = $WSMicroPayment->pegaCod_Resultado();
	// Descrio do resultado
	$txt_resultado = $WSMicroPayment->pegaTxt_Resultado();
	// URL de Autenticao
	$url_autenticacao = $WSMicroPayment->pegaURL_Autenticacao();
 
	if($log["texto"] == ""){
       	if($cod_resultado["texto"] == "1"){

       		echo "<script>\r\n";
       		echo "window.location.href = '" . $url_autenticacao["texto"] . "'\r\n";
       		echo "</script>\r\n";

        } else {
            foreach($log as $key => $value){
                tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, 'error_message=' . urlencode($value), 'SSL'));
      	    }
        }
	} else {
        foreach($log as $key => $value){
            tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, 'error_message=' . urlencode($value), 'SSL'));
        }
	}
 
} else {
	tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, 'error_message=Sem resposta do servidor', 'SSL'));
}
?>
