<?php

require_once("includes/application_top.php");
require_once(DIR_WS_CLASSES . 'order.php');
$order = new order;

require_once("WSBilling.php");

// Inicia a classe WSBilling
$WSBilling = new WSBilling();

// Cria o cabealho SOAP
$xmlObj = $WSBilling->add_node("","soap-env:Envelope");
$WSBilling->add_attributes($xmlObj, array("xmlns:soap-env" => "http://schemas.xmlsoap.org/soap/envelope/") );
$xmlObj = $WSBilling->add_node($xmlObj,"soap-env:Body");

// Cria  o elemento m:F2bCobranca
$xmlObjF2bCobranca = $WSBilling->add_node($xmlObj,"m:F2bCobranca");
$WSBilling->add_attributes($xmlObjF2bCobranca, array("xmlns:m" => "http://www.f2b.com.br/soap/wsbilling.xsd") );

// Cria o elemento mensagem
$xmlObj = $WSBilling->add_node($xmlObjF2bCobranca,"mensagem");
$WSBilling->add_attributes($xmlObj, array("data" => date("Y-m-d"), 
                                          "numero" => date("His")));

// Cria o elemento sacador
$xmlObj = $WSBilling->add_node($xmlObjF2bCobranca,"sacador");

$WSBilling->add_attributes($xmlObj, array("conta" => MODULE_PAYMENT_BOLETOF2B_ID, 
                                          "senha" => MODULE_PAYMENT_BOLETOF2B_PASSWORD));
$WSBilling->add_content($xmlObj,MODULE_PAYMENT_BOLETOF2B_SACADOR);

// Cria o elemento cobranca
$xmlObjCobranca = $WSBilling->add_node($xmlObjF2bCobranca,"cobranca");
$WSBilling->add_attributes($xmlObjCobranca, array("valor" => $order->info['total'], "taxa" => MODULE_PAYMENT_BOLETOF2B_TAXA));

// Cria os elementos demonstrativos
$xmlObj = $WSBilling->add_node($xmlObjCobranca,"demonstrativo");
$WSBilling->add_content($xmlObj,MODULE_PAYMENT_BOLETOF2B_DEMONSTRATIVO1);
$xmlObj = $WSBilling->add_node($xmlObjCobranca,"demonstrativo");
$WSBilling->add_content($xmlObj,MODULE_PAYMENT_BOLETOF2B_DEMONSTRATIVO2);
$xmlObj = $WSBilling->add_node($xmlObjCobranca,"demonstrativo");
$WSBilling->add_content($xmlObj,MODULE_PAYMENT_BOLETOF2B_DEMONSTRATIVO3);
// Cria o elemento desconto
//$xmlObj = $WSBilling->add_node($xmlObjCobranca,"desconto");
//$WSBilling->add_attributes($xmlObj, array("valor" => "2.0", 
//                                          "antecedencia" => "5"));
// Cria o elemento multa
//$xmlObj = $WSBilling->add_node($xmlObjCobranca,"multa");
//$WSBilling->add_attributes($xmlObj, array("valor" => "1.0", 
//                                          "valor_dia" => "0.10",
//                                          "atraso" => "20"));

//Cria o elemento agendamento
$xmlObj = $WSBilling->add_node($xmlObjF2bCobranca,"agendamento");
$WSBilling->add_attributes($xmlObj, array("vencimento" => date('Y-m-d',time()+MODULE_PAYMENT_BOLETOF2B_PRAZOVENCIMENTO*24*60*60)));
$WSBilling->add_content($xmlObj,"Imediato");

// Cria o elemento sacado
$xmlObjSacado = $WSBilling->add_node($xmlObjF2bCobranca,"sacado");
//$WSBilling->add_attributes($xmlObjSacado, array("grupo" => "web service", "codigo" => "000001", "envio" => "e"));

// Cria o elemento nome
$xmlObj = $WSBilling->add_node($xmlObjSacado,"nome");
$WSBilling->add_content($xmlObj,$order->customer['firstname'] . ' ' . $order->customer['lastname']);
// Cria o elemento email
$xmlObj = $WSBilling->add_node($xmlObjSacado,"email");
$WSBilling->add_content($xmlObj,$order->customer['email_address']);
// Cria o elemento endereco
//$xmlObj = $WSBilling->add_node($xmlObjSacado,"endereco");
//$WSBilling->add_attributes($xmlObj, array("logradouro" => $order->customer['street_address'],
//                                          "numero" => "0",
//                                          "complemento" => "",
//                                          "bairro" => $order->customer['suburb'],
//                                          "cidade" => $order->customer['city'],
//                                          "estado" => $order->customer['state'],
//                                          "cep" => substr($order->customer['postcode'], 0, 5) . substr($order->customer['postcode'], 6, 8)));
// Cria o elemento telefone
//$xmlObj = $WSBilling->add_node($xmlObjSacado,"telefone");
//$WSBilling->add_attributes($xmlObj, array("ddd" => substr($order->customer['telephone'], 0, 2),
//                                          "numero" => substr($order->customer['telephone'], 2)));

// envia dados
$WSBilling->send($WSBilling->getXML());
$resposta = $WSBilling->resposta;
if(strlen($resposta) > 0){
	// Reinicia a classe WSBlling, agora com uma string XML
	$WSBilling = new WSBilling($resposta);

	// LOG 
	$log = $WSBilling->pegaLog();
	if($log["texto"] == "OK"){
		$cobranca = $WSBilling->pegaCobranca();

		echo "<script>\r\n";
		echo "var abrir = window.open ('" . $cobranca[0]["url"] . "','jan','toolbar=no,location=no,menubar=no,resizable=no,scrollbars=yes,width=600,height=500')\r\n";
	
		echo "window.location.href= '" . tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL', true) . "'\r\n";
		echo "</script>\r\n";

	} else {
		foreach($log as $key => $value){
			tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, 'error_message=' . urlencode($value), 'SSL'));
		}
	}
} else {
	tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, 'error_message=Sem resposta do servidor', 'SSL'));
}

?>
